/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.NativeBlas;
import org.jblas.SimpleBlas;
import org.jblas.exceptions.LapackArgumentException;
import org.jblas.exceptions.LapackPositivityException;
import org.jblas.util.Functions;
import org.jblas.util.Permutations;

public class Decompose {
    public static LUDecomposition<DoubleMatrix> lu(DoubleMatrix A) {
        int[] ipiv = new int[Functions.min(A.rows, A.columns)];
        DoubleMatrix result = A.dup();
        NativeBlas.dgetrf(A.rows, A.columns, result.data, 0, A.rows, ipiv, 0);
        DoubleMatrix l = new DoubleMatrix(A.rows, Functions.min(A.rows, A.columns));
        DoubleMatrix u = new DoubleMatrix(Functions.min(A.columns, A.rows), A.columns);
        Decompose.decomposeLowerUpper(result, l, u);
        DoubleMatrix p = Permutations.permutationDoubleMatrixFromPivotIndices(A.rows, ipiv);
        return new LUDecomposition<DoubleMatrix>(l, u, p);
    }

    private static void decomposeLowerUpper(DoubleMatrix A, DoubleMatrix L, DoubleMatrix U) {
        int i = 0;
        while (i < A.rows) {
            int j = 0;
            while (j < A.columns) {
                if (i < j) {
                    U.put(i, j, A.get(i, j));
                } else if (i == j) {
                    U.put(i, i, A.get(i, i));
                    L.put(i, i, 1.0);
                } else {
                    L.put(i, j, A.get(i, j));
                }
                ++j;
            }
            ++i;
        }
    }

    public static FloatMatrix cholesky(FloatMatrix A) {
        FloatMatrix result = A.dup();
        int info = NativeBlas.spotrf('U', A.rows, result.data, 0, A.rows);
        if (info < 0) {
            throw new LapackArgumentException("DPOTRF", -info);
        }
        if (info > 0) {
            throw new LapackPositivityException("DPOTRF", "Minor " + info + " was negative. Matrix must be positive definite.");
        }
        Decompose.clearLower(result);
        return result;
    }

    private static void clearLower(FloatMatrix A) {
        int j = 0;
        while (j < A.columns) {
            int i = j + 1;
            while (i < A.rows) {
                A.put(i, j, 0.0f);
                ++i;
            }
            ++j;
        }
    }

    public static LUDecomposition<FloatMatrix> lu(FloatMatrix A) {
        int[] ipiv = new int[Functions.min(A.rows, A.columns)];
        FloatMatrix result = A.dup();
        NativeBlas.sgetrf(A.rows, A.columns, result.data, 0, A.rows, ipiv, 0);
        FloatMatrix l = new FloatMatrix(A.rows, Functions.min(A.rows, A.columns));
        FloatMatrix u = new FloatMatrix(Functions.min(A.columns, A.rows), A.columns);
        Decompose.decomposeLowerUpper(result, l, u);
        FloatMatrix p = Permutations.permutationFloatMatrixFromPivotIndices(A.rows, ipiv);
        return new LUDecomposition<FloatMatrix>(l, u, p);
    }

    private static void decomposeLowerUpper(FloatMatrix A, FloatMatrix L, FloatMatrix U) {
        int i = 0;
        while (i < A.rows) {
            int j = 0;
            while (j < A.columns) {
                if (i < j) {
                    U.put(i, j, A.get(i, j));
                } else if (i == j) {
                    U.put(i, i, A.get(i, i));
                    L.put(i, i, 1.0f);
                } else {
                    L.put(i, j, A.get(i, j));
                }
                ++j;
            }
            ++i;
        }
    }

    public static DoubleMatrix cholesky(DoubleMatrix A) {
        DoubleMatrix result = A.dup();
        int info = NativeBlas.dpotrf('U', A.rows, result.data, 0, A.rows);
        if (info < 0) {
            throw new LapackArgumentException("DPOTRF", -info);
        }
        if (info > 0) {
            throw new LapackPositivityException("DPOTRF", "Minor " + info + " was negative. Matrix must be positive definite.");
        }
        Decompose.clearLower(result);
        return result;
    }

    private static void clearLower(DoubleMatrix A) {
        int j = 0;
        while (j < A.columns) {
            int i = j + 1;
            while (i < A.rows) {
                A.put(i, j, 0.0);
                ++i;
            }
            ++j;
        }
    }

    public static QRDecomposition<DoubleMatrix> qr(DoubleMatrix A) {
        int minmn = Functions.min(A.rows, A.columns);
        DoubleMatrix result = A.dup();
        DoubleMatrix tau = new DoubleMatrix(minmn);
        SimpleBlas.geqrf(result, tau);
        DoubleMatrix R = new DoubleMatrix(A.rows, A.columns);
        int i = 0;
        while (i < A.rows) {
            int j = i;
            while (j < A.columns) {
                R.put(i, j, result.get(i, j));
                ++j;
            }
            ++i;
        }
        DoubleMatrix Q = DoubleMatrix.eye(A.rows);
        SimpleBlas.ormqr('L', 'N', result, tau, Q);
        return new QRDecomposition<DoubleMatrix>(Q, R);
    }

    public static QRDecomposition<FloatMatrix> qr(FloatMatrix A) {
        int minmn = Functions.min(A.rows, A.columns);
        FloatMatrix result = A.dup();
        FloatMatrix tau = new FloatMatrix(minmn);
        SimpleBlas.geqrf(result, tau);
        FloatMatrix R = new FloatMatrix(A.rows, A.columns);
        int i = 0;
        while (i < A.rows) {
            int j = i;
            while (j < A.columns) {
                R.put(i, j, result.get(i, j));
                ++j;
            }
            ++i;
        }
        FloatMatrix Q = FloatMatrix.eye(A.rows);
        SimpleBlas.ormqr('L', 'N', result, tau, Q);
        return new QRDecomposition<FloatMatrix>(Q, R);
    }

    public static class LUDecomposition<T> {
        public T l;
        public T u;
        public T p;

        public LUDecomposition(T l, T u, T p) {
            this.l = l;
            this.u = u;
            this.p = p;
        }

        public String toString() {
            return String.format("<LUDecomposition L=%s U=%s P=%s>", this.l, this.u, this.p);
        }
    }

    public static class QRDecomposition<T> {
        public T q;
        public T r;

        QRDecomposition(T q, T r) {
            this.q = q;
            this.r = r;
        }

        public String toString() {
            return "<Q=" + this.q + " R=" + this.r + ">";
        }
    }
}

