/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.generallib.main.FakePlugin;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.PluginConfig;
import org.generallib.pluginbase.PluginManager;
import org.generallib.pluginbase.PluginProcedure;
import org.generallib.pluginbase.language.DefaultLanguages;
import org.generallib.serializetools.Utf8YamlConfiguration;

public final class PluginLanguage
implements PluginProcedure {
    private final String defaultLang;
    private final Set<String> supportLanguages;
    private final Map<String, LanguageFileSession> langFiles = new HashMap<String, LanguageFileSession>();
    private final Set<Language> languages = new HashSet<Language>(){
        {
            DefaultLanguages[] defaultLanguagesArray = DefaultLanguages.values();
            int n = defaultLanguagesArray.length;
            int n2 = 0;
            while (n2 < n) {
                DefaultLanguages lang = defaultLanguagesArray[n2];
                this.add(lang);
                ++n2;
            }
        }
    };
    private PluginBase base;
    private Queue<Double> doub = new LinkedList<Double>();
    private Queue<Integer> integer = new LinkedList<Integer>();
    private Queue<Long> llong = new LinkedList<Long>();
    private Queue<String> string = new LinkedList<String>();
    private Queue<Boolean> bool = new LinkedList<Boolean>();

    public PluginLanguage(Set<String> supportLanguages, String defaultLang) {
        Validate.notNull(supportLanguages);
        Validate.notNull((Object)defaultLang);
        this.supportLanguages = supportLanguages;
        this.defaultLang = defaultLang;
    }

    public PluginLanguage(Set<String> supportLanguages) {
        this(supportLanguages, Locale.ENGLISH.toString());
    }

    @Override
    public void onEnable(PluginBase base) throws Exception {
        this.base = base;
        File langFolder = new File(base.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (String string : this.supportLanguages) {
            File file = new File(langFolder, String.valueOf(string) + ".yml");
            LanguageFileSession session = null;
            try {
                session = new LanguageFileSession(file);
            }
            catch (IOException e) {
                base.getLogger().severe("While creating file [" + string + ".yml]: ");
                base.getLogger().severe(e.getMessage());
            }
            this.langFiles.put(string, session);
        }
        if (!this.langFiles.containsKey(this.defaultLang)) {
            throw new Exception("default language file[" + this.defaultLang + ".yml] doesn't exist!");
        }
        for (Map.Entry entry : this.langFiles.entrySet()) {
            this.fillIfEmpty(entry);
        }
    }

    @Override
    public void onDisable(PluginBase base) throws Exception {
    }

    @Override
    public void onReload(PluginBase base) throws Exception {
        this.reload();
    }

    private void save() throws IOException {
        for (Map.Entry<String, LanguageFileSession> entry : this.langFiles.entrySet()) {
            entry.getValue().save();
        }
    }

    private void reload() throws FileNotFoundException, IOException, InvalidConfigurationException {
        for (Map.Entry<String, LanguageFileSession> entry : this.langFiles.entrySet()) {
            this.base.getLogger().info("reloading language [" + entry.getKey() + "]...");
            entry.getValue().reload();
            this.fillIfEmpty(entry);
            this.base.getLogger().info("loaded!");
        }
    }

    public boolean registerLanguage(Language lang) {
        return this.languages.add(lang);
    }

    private void fillIfEmpty(Map.Entry<String, LanguageFileSession> entry) {
        String locale = entry.getKey();
        LanguageFileSession session = entry.getValue();
        int i = 0;
        int old = 0;
        for (Language lang : this.languages) {
            String str = PluginLanguage.convertToConfigName(lang.toString());
            List oldStyle = (List)session.config.get(lang.toString());
            session.config.set(lang.toString(), null);
            if (session.config.get(str) == null) {
                if (oldStyle != null) {
                    session.config.set(str, (Object)oldStyle);
                    ++old;
                } else {
                    session.config.set(str, (Object)new ArrayList<String>(lang){
                        {
                            this.addAll(Arrays.asList(language.getEngDefault()));
                        }
                    });
                    ++i;
                }
            }
            try {
                session.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.base.getLogger().info("Converted [" + old + "] old style langauges of [" + locale + "] locale.");
        this.base.getLogger().info("Added [" + i + "] new langauges to [" + locale + "] locale.");
    }

    public void addDouble(double doub) {
        this.doub.add(doub);
    }

    public void addInteger(int integer) {
        this.integer.add(integer);
    }

    public void addString(String string) {
        Validate.notNull((Object)string);
        this.string.add(string);
    }

    public void addString(String[] strs) {
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.addString(str);
            ++n2;
        }
    }

    public void addBoolean(boolean bool) {
        this.bool.add(bool);
    }

    public void addLong(long llong) {
        this.llong.add(llong);
    }

    public String parseFirstString(Language lang) {
        String[] result = this.parseStrings(null, lang, null);
        return result.length < 1 ? "NULL" : result[0];
    }

    public String parseFirstString(CommandSender sender, Language lang) {
        String[] result;
        String locale = null;
        if (sender instanceof Player) {
            locale = FakePlugin.nmsEntityManager.getLocale((Player)sender);
        }
        return (result = this.parseStrings(sender, lang, locale)).length < 1 ? "NULL" : result[0];
    }

    public String parseFirstString(CommandSender sender, Locale locale, Language lang) {
        String[] result = this.parseStrings(sender, lang, locale.toString());
        return result.length < 1 ? "NULL" : result[0];
    }

    public String parseFirstString(CommandSender sender, Language lang, String locale) {
        String[] result = this.parseStrings(sender, lang, locale);
        return result.length < 1 ? "NULL" : result[0];
    }

    public String[] parseStrings(Language lang) {
        return this.parseStrings(null, lang, null);
    }

    public String[] parseStrings(CommandSender sender, Language lang) {
        String locale = null;
        if (sender instanceof Player) {
            locale = FakePlugin.nmsEntityManager.getLocale((Player)sender);
        }
        return this.parseStrings(sender, lang, locale);
    }

    public String[] parseStrings(CommandSender sender, Locale locale, Language lang) {
        return this.parseStrings(sender, lang, locale.toString());
    }

    private static String convertToConfigName(String langName) {
        return langName.replaceAll("_", ".");
    }

    public String[] parseStrings(CommandSender sender, Language lang, String locale) {
        if (locale == null) {
            locale = this.defaultLang;
        }
        Validate.notNull((Object)lang);
        LanguageFileSession session = this.langFiles.get(locale);
        if (session == null) {
            session = this.langFiles.get(this.defaultLang);
        }
        if (session == null) {
            this.base.getLogger().severe("Cannot parse language with locale " + locale + "!");
            return new String[0];
        }
        ArrayList<String> str = new ArrayList<String>();
        List read = (List)session.config.get(PluginLanguage.convertToConfigName(lang.toString()));
        if (read != null) {
            str.addAll(read);
        }
        Validate.notNull(str);
        this.replaceVariables(sender, str);
        this.doub.clear();
        this.integer.clear();
        this.string.clear();
        this.bool.clear();
        this.llong.clear();
        return str.toArray(new String[str.size()]);
    }

    public String colorize(String msg) {
        String coloredMsg = "";
        int i = 0;
        while (i < msg.length()) {
            coloredMsg = msg.charAt(i) == '&' ? String.valueOf(coloredMsg) + '\u00a7' : String.valueOf(coloredMsg) + msg.charAt(i);
            ++i;
        }
        return coloredMsg;
    }

    private void replaceVariables(CommandSender sender, List<String> strings) {
        int i = 0;
        while (i < strings.size()) {
            block34: {
                String str;
                block35: {
                    str = strings.get(i);
                    if (str == null) break block34;
                    if (!(str = this.colorize(str)).contains("${")) break block35;
                    int start = -1;
                    int end = -1;
                    while ((start = str.indexOf("${")) != -1 && (end = str.indexOf("}")) != -1) {
                        String varName;
                        String leftStr = str.substring(0, start);
                        String rightStr = str.substring(end + 1, str.length());
                        switch (varName = str.substring(start + 2, end)) {
                            case "double": {
                                String form = "###,###,###.";
                                int n = 0;
                                while (n < ((PluginConfig)this.base.getPluginConfig()).Languages_Double_DecimalPoints) {
                                    form = String.valueOf(form) + "#";
                                    ++n;
                                }
                                DecimalFormat format = new DecimalFormat(form);
                                Double val = this.doub.poll();
                                String msg = null;
                                if (val != null) {
                                    msg = format.format(val);
                                }
                                str = String.valueOf(leftStr) + String.valueOf(msg) + rightStr;
                                break;
                            }
                            case "integer": {
                                str = String.valueOf(leftStr) + String.valueOf(this.integer.poll()) + rightStr;
                                break;
                            }
                            case "long": {
                                str = String.valueOf(leftStr) + String.valueOf(this.llong.poll()) + rightStr;
                                break;
                            }
                            case "string": {
                                str = String.valueOf(leftStr) + String.valueOf(this.string.poll()) + rightStr;
                                break;
                            }
                            case "bool": {
                                str = String.valueOf(leftStr) + String.valueOf(this.bool.poll()) + rightStr;
                                break;
                            }
                            case "player": {
                                str = String.valueOf(leftStr) + (sender == null ? "null" : sender.getName()) + rightStr;
                                break;
                            }
                            case "maincommand": {
                                str = String.valueOf(leftStr) + this.base.executor.mainCommand + rightStr;
                                break;
                            }
                            case "dbtype": {
                                String dbTypes = "[";
                                for (Map.Entry<Class<? extends PluginManager>, PluginManager> entry : this.base.pluginManagers.entrySet()) {
                                    Set<String> types = entry.getValue().getValidDBTypes();
                                    if (types == null) continue;
                                    dbTypes = String.valueOf(dbTypes) + entry.getKey().getSimpleName() + "@";
                                    for (String type : types) {
                                        dbTypes = String.valueOf(dbTypes) + type + ",";
                                    }
                                    dbTypes = String.valueOf(dbTypes) + entry.getKey().getSimpleName() + " ";
                                }
                                dbTypes = String.valueOf(dbTypes) + "]";
                                str = String.valueOf(leftStr) + dbTypes + rightStr;
                                break;
                            }
                            default: {
                                str = String.valueOf(leftStr) + String.valueOf("[?]") + rightStr;
                            }
                        }
                    }
                }
                strings.set(i, str);
            }
            ++i;
        }
    }

    public static interface Language {
        public String[] getEngDefault();
    }

    private class LanguageFileSession {
        private File file;
        FileConfiguration config;

        public LanguageFileSession(File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
            this.file = file;
            if (!file.exists()) {
                file.createNewFile();
            }
            this.config = new Utf8YamlConfiguration();
            this.config.load(file);
        }

        public void reload() throws FileNotFoundException, IOException, InvalidConfigurationException {
            this.config.load(this.file);
        }

        public void save() throws IOException {
            this.config.save(this.file);
        }
    }
}

