/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.nms.world.v1_8_R3;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.v1_8_R3.ChunkProviderServer;
import net.minecraft.server.v1_8_R3.IChunkLoader;
import net.minecraft.server.v1_8_R3.IChunkProvider;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.generator.NormalChunkGenerator;
import org.generallib.main.FakePlugin;
import org.generallib.nms.world.BlockFilter;
import org.generallib.nms.world.INmsWorldManager;
import org.generallib.pluginbase.PluginBase;

public class NmsChunkManager
implements INmsWorldManager {
    private static Map<String, ChunkProviderServer> _serv = new ConcurrentHashMap<String, ChunkProviderServer>();

    private void initNatural(World w) {
        if (!_serv.containsKey(w.getName())) {
            CraftWorld cw = (CraftWorld)w;
            WorldServer ws = cw.getHandle();
            IChunkLoader loader = ws.getDataManager().createChunkLoader(ws.worldProvider);
            NormalChunkGenerator _gen = new NormalChunkGenerator((net.minecraft.server.v1_8_R3.World)ws, w.getSeed());
            _serv.put(w.getName(), new ChunkProviderServer(ws, loader, (IChunkProvider)_gen));
        }
    }

    @Override
    public void regenerateChunk(World w, int i, int j, BlockFilter filter) {
        this.initNatural(w);
        Chunk c = NmsChunkManager._serv.get((Object)w.getName()).getChunkAt((int)i, (int)j).bukkitChunk;
        Chunk chunk = w.getChunkAt(i, j);
        int x = 0;
        while (x < 16) {
            int z = 0;
            while (z < 16) {
                int y = 0;
                while (y < 128) {
                    final Block block = c.getBlock(x, y, z);
                    if (filter.allow(block.getTypeId(), block.getData())) {
                        final Block target = chunk.getBlock(x, y, z);
                        PluginBase.runAsynchronously(new Runnable(){

                            @Override
                            public void run() {
                                Bukkit.getScheduler().runTask(FakePlugin.instance, new Runnable(){

                                    @Override
                                    public void run() {
                                        target.setTypeId(block.getTypeId());
                                        target.setData(block.getData());
                                    }
                                });
                            }
                        });
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }
}

