/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.nms.entity.v1_8_R3;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_8_R3.PlayerInteractManager;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.generallib.nms.entity.INmsEntityManager;
import org.generallib.reflection.utils.ReflectionHelper;

public class NmsEntityProvider
implements INmsEntityManager {
    @Override
    public String getLocale(Player player) {
        CraftPlayer cp = (CraftPlayer)player;
        return cp.getHandle().locale.split("_")[0];
    }

    @Override
    public Player createFakePlayer(UUID uuid) {
        OfflinePlayer offp = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offp == null || !offp.hasPlayedBefore()) {
            return null;
        }
        MinecraftServer ms = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer ws = ms.getWorldServer(0);
        GameProfile profile = new GameProfile(uuid, offp.getName());
        PlayerInteractManager pim = new PlayerInteractManager((World)ws);
        EntityPlayer ep = new EntityPlayer(ms, ws, profile, pim);
        CraftPlayer player = ep.getBukkitEntity();
        player.loadData();
        return player;
    }

    @Override
    public void changeOfflinePlayerName(UUID uuid, String name) {
        MinecraftServer ms = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer ws = ms.getWorldServer(0);
        GameProfile profile = new GameProfile(uuid, name);
        PlayerInteractManager pim = new PlayerInteractManager((World)ws);
        EntityPlayer ep = new EntityPlayer(ms, ws, profile, pim);
        ep.getBukkitEntity().saveData();
    }

    @Override
    public void destroyEntity(Player[] player, int[] entityID) {
        PacketPlayOutEntityDestroy ppoed = new PacketPlayOutEntityDestroy(entityID);
        Player[] playerArray = player;
        int n = player.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            CraftPlayer cp = (CraftPlayer)p;
            EntityPlayer ep = cp.getHandle();
            ep.playerConnection.sendPacket((Packet)ppoed);
            ++n2;
        }
    }

    @Override
    public void sendTeamColor(Player[] player, String teamName, String prefix, Set<String> playersUUID, int mode) {
        PacketPlayOutScoreboardTeam ppost = new PacketPlayOutScoreboardTeam();
        ReflectionHelper.setPrivateField(ppost, "a", teamName);
        ReflectionHelper.setPrivateField(ppost, "c", prefix);
        ReflectionHelper.setPrivateField(ppost, "h", playersUUID);
        ReflectionHelper.setPrivateField(ppost, "i", mode);
        Player[] playerArray = player;
        int n = player.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            CraftPlayer cp = (CraftPlayer)p;
            EntityPlayer ep = cp.getHandle();
            ep.playerConnection.sendPacket((Packet)ppost);
            ++n2;
        }
    }

    @Override
    public void swingRightArm(Player[] player) {
        ArrayList<PacketPlayOutAnimation> packets = new ArrayList<PacketPlayOutAnimation>();
        Player[] playerArray = player;
        int n = player.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            CraftPlayer craftPlayer = (CraftPlayer)p;
            EntityPlayer ep = craftPlayer.getHandle();
            packets.add(new PacketPlayOutAnimation((net.minecraft.server.v1_8_R3.Entity)ep, 3));
            ++n2;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            CraftPlayer cp = (CraftPlayer)p;
            EntityPlayer ep = cp.getHandle();
            for (Packet packet : packets) {
                ep.playerConnection.sendPacket(packet);
            }
        }
    }

    @Override
    public float getYaw(Entity entity) {
        CraftEntity cf = (CraftEntity)entity;
        return cf.getHandle().getHeadRotation();
    }
}

