/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.main;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.generallib.nms.entity.INmsEntityManager;
import org.generallib.nms.particle.INmsParticleSender;
import org.generallib.nms.world.BlockFilter;
import org.generallib.nms.world.INmsWorldManager;

public class FakePlugin
extends JavaPlugin {
    public static Plugin instance;
    public static INmsWorldManager nmsWorldManager;
    public static INmsEntityManager nmsEntityManager;
    public static INmsParticleSender nmsParticleSender;
    private static final String packageName = "org.generallib.nms";
    private static Set<Integer> ores;
    private static UUID temp;

    static {
        ores = new HashSet<Integer>(){
            {
                Material[] materialArray = Material.values();
                int n = materialArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Material mat = materialArray[n2];
                    if (mat.name().endsWith("_ORE")) {
                        this.add(mat.getId());
                    }
                    ++n2;
                }
            }
        };
        temp = UUID.randomUUID();
    }

    public void onEnable() {
        instance = this;
        String packageName = this.getServer().getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        try {
            this.initWorldNms(version);
            this.initEntityrNms(version);
            this.initParticleNms(version);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getLogger().severe("Version [" + version + "] is not supported by this plugin.");
            this.setEnabled(false);
        }
    }

    private void initWorldNms(String version) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName("org.generallib.nms.world." + version + "." + "NmsChunkManager");
        nmsWorldManager = (INmsWorldManager)clazz.newInstance();
    }

    private void initEntityrNms(String version) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName("org.generallib.nms.entity." + version + "." + "NmsEntityProvider");
        nmsEntityManager = (INmsEntityManager)clazz.newInstance();
    }

    private void initParticleNms(String version) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName("org.generallib.nms.particle." + version + "." + "NmsParticleSender");
        nmsParticleSender = (INmsParticleSender)clazz.newInstance();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && !((Player)sender).isOp()) {
            return true;
        }
        if (!label.equals("glib")) {
            return true;
        }
        try {
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("glow")) {
                    Player player = (Player)sender;
                    int x = player.getLocation().getBlockX();
                    int y = player.getLocation().getBlockY();
                    int z = player.getLocation().getBlockZ();
                    nmsParticleSender.showGlowingBlock(new Player[]{player}, -700, temp, x, y, z);
                } else if (args[0].equalsIgnoreCase("del")) {
                    Player player = (Player)sender;
                    nmsEntityManager.destroyEntity(new Player[]{player}, new int[]{-700});
                } else if (args[0].equalsIgnoreCase("color")) {
                    Player player = (Player)sender;
                    nmsEntityManager.sendTeamColor(new Player[]{player}, "temp", "" + ChatColor.RED, (Set<String>)new HashSet<String>(){
                        {
                            this.add(temp.toString());
                        }
                    }, 2);
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("chunk")) {
                    Player player = (Player)sender;
                    int i = Integer.parseInt(args[1]);
                    int j = Integer.parseInt(args[2]);
                    nmsWorldManager.regenerateChunk(player.getWorld(), i, j, new BlockFilter(){

                        @Override
                        public boolean allow(int blockID, byte data) {
                            return ores.contains(blockID);
                        }
                    });
                }
            } else if (args.length == 4 && args[0].equalsIgnoreCase("chunk")) {
                World world = Bukkit.getWorld((String)args[3]);
                int i = Integer.parseInt(args[1]);
                int j = Integer.parseInt(args[2]);
                nmsWorldManager.regenerateChunk(world, i, j, new BlockFilter(){

                    @Override
                    public boolean allow(int blockID, byte data) {
                        return ores.contains(blockID);
                    }
                });
            }
        }
        catch (Exception e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
            return true;
        }
        return true;
    }
}

