/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.deeplearning.selforganizingmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.generallib.deeplearning.selforganizingmap.Node;

public class SelfOrganizingMap<T extends Node> {
    private static boolean isDrawing = false;
    private Node[] nodeMap;
    private int clientWidth;
    private int clientHeight;
    private double radius;
    private int iteration = 0;
    private final double initLearningRate;
    private double learningRate = 1.0;
    private IterationTracker tracker;
    private Random rand = new Random();

    public static void main(String[] ar) {
        SelfOrganizingMap map = new SelfOrganizingMap(3, 40, 40, 1.0, new NodeConstructor(){

            @Override
            public Node create(int dimension, double x, double y) {
                return new Node(dimension, x, y){

                    public String toString() {
                        return String.valueOf(this.getX()) + ", " + this.getY();
                    }
                };
            }
        });
        final LinkedList nodesForDraw = new LinkedList();
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(1280, 1280);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                while (!nodesForDraw.isEmpty()) {
                    double[] weights;
                    Node node = (Node)nodesForDraw.poll();
                    if (node == null || (weights = node.getWeights()).length != 3) continue;
                    int red = (int)(weights[0] * 255.0);
                    int green = (int)(weights[1] * 255.0);
                    int blue = (int)(weights[2] * 255.0);
                    g.setColor(new Color(red, green, blue));
                    g.fillRect((int)node.getX() * 10, (int)node.getY() * 10, 10, 10);
                }
                JFrame jFrame = frame;
                synchronized (jFrame) {
                    isDrawing = false;
                    frame.notifyAll();
                }
            }
        };
        frame.setLayout(new BorderLayout());
        frame.setPreferredSize(new Dimension(1280, 1280));
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        map.setTracker(new IterationTracker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInteration(Node[] map, int currernt) {
                Node[] nodeArray = map;
                int n = map.length;
                int n2 = 0;
                while (n2 < n) {
                    Node node = nodeArray[n2];
                    nodesForDraw.add(node);
                    ++n2;
                }
                isDrawing = true;
                frame.validate();
                frame.repaint();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                while (isDrawing) {
                    JFrame jFrame = frame;
                    synchronized (jFrame) {
                        try {
                            frame.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        map.train((double[][])new double[][]{{Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}, {Math.random(), Math.random(), Math.random()}}, 500);
        System.out.println("red: " + map.findBMU(new double[]{1.0, 0.0, 0.0}, 0.1));
        System.out.println("green: " + map.findBMU(new double[]{0.0, 1.0, 0.0}, 0.1));
        System.out.println("blue: " + map.findBMU(new double[]{0.0, 0.0, 1.0}, 0.1));
        System.out.println("black: " + map.findBMU(new double[]{0.0, 0.0, 0.0}, 0.1));
        System.out.println("white: " + map.findBMU(new double[]{1.0, 1.0, 1.0}, 0.1));
        System.out.println("?: " + map.findBMU(new double[]{1.0, 0.0, 1.0}, 0.1));
        System.out.println("?: " + map.findBMU(new double[]{1.0, 0.005, 1.0}, 0.1));
    }

    public SelfOrganizingMap(int dimension, int clientWidth, int clientHeight, double initLearningRate, NodeConstructor nodeConstructor) {
        this.clientWidth = clientWidth;
        this.clientHeight = clientHeight;
        this.nodeMap = new Node[clientWidth * clientHeight];
        this.initLearningRate = initLearningRate;
        this.learningRate = initLearningRate;
        int i = 0;
        while (i < clientWidth * clientHeight) {
            this.nodeMap[i] = nodeConstructor.create(dimension, i % clientWidth, i / clientWidth);
            ++i;
        }
        this.radius = (double)Math.max(clientWidth, clientHeight) / 2.0;
    }

    IterationTracker getTracker() {
        return this.tracker;
    }

    void setTracker(IterationTracker tracker) {
        this.tracker = tracker;
    }

    public void train(double[][] input, int interationCount) {
        double timeConstant = (double)interationCount / Math.log(this.radius);
        this.iteration = 0;
        while (this.iteration < interationCount) {
            this.train(input, timeConstant);
            this.learningRate = this.initLearningRate * Math.exp(-((double)this.iteration) / (double)interationCount);
            if (this.tracker != null) {
                this.tracker.onInteration(this.nodeMap, this.iteration);
            }
            ++this.iteration;
        }
    }

    private void train(double[][] input, double timeConstant) {
        int randVal = this.rand.nextInt(input.length);
        Node winningNode = this.findBMU(input[randVal]);
        double neighbourhood = this.radius * Math.exp(-((double)this.iteration) / timeConstant);
        int i = 0;
        while (i < this.nodeMap.length) {
            double radSquared;
            double distSquared = (winningNode.getX() - this.nodeMap[i].getX()) * (winningNode.getX() - this.nodeMap[i].getX()) + (winningNode.getY() - this.nodeMap[i].getY()) * (winningNode.getY() - this.nodeMap[i].getY());
            if (distSquared < (radSquared = neighbourhood * neighbourhood)) {
                double influence = Math.exp(-distSquared / (2.0 * radSquared));
                this.nodeMap[i].adjustWeight(input[randVal], this.learningRate, influence);
            }
            ++i;
        }
    }

    private Node findBMU(double[] vector) {
        Node BMU = this.nodeMap[0];
        double minDist = BMU.eculideanDistance(vector);
        int i = 1;
        while (i < this.nodeMap.length) {
            double eculidean = this.nodeMap[i].eculideanDistance(vector);
            if (eculidean < minDist) {
                BMU = this.nodeMap[i];
                minDist = eculidean;
            }
            ++i;
        }
        return BMU;
    }

    public Node findBMU(double[] vector, double accuracy) {
        Node BMU = this.nodeMap[0];
        double minDist = BMU.eculideanDistance(vector);
        int i = 1;
        while (i < this.nodeMap.length) {
            double eculidean = this.nodeMap[i].eculideanDistance(vector);
            if (eculidean < minDist) {
                BMU = this.nodeMap[i];
                minDist = eculidean;
            }
            ++i;
        }
        if (minDist < accuracy) {
            return BMU;
        }
        return null;
    }

    public static interface IterationTracker {
        public void onInteration(Node[] var1, int var2);
    }

    public static interface NodeConstructor {
        public Node create(int var1, double var2, double var4);
    }
}

