/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.deeplearning.selforganizingmap;

public abstract class Node {
    private double x;
    private double y;
    private double[] weights;
    private static Operation sum = new Operation(){

        @Override
        public double[] calc(double[] left, double[] right) {
            if (left.length != right.length) {
                throw new RuntimeException("Dimension does not match.");
            }
            double[] result = new double[left.length];
            int i = 0;
            while (i < left.length) {
                result[i] = left[i] + right[i];
                ++i;
            }
            return result;
        }
    };
    private static Operation sub = new Operation(){

        @Override
        public double[] calc(double[] left, double[] right) {
            if (left.length != right.length) {
                throw new RuntimeException("Dimension does not match.");
            }
            double[] result = new double[left.length];
            int i = 0;
            while (i < left.length) {
                result[i] = left[i] - right[i];
                ++i;
            }
            return result;
        }
    };
    private static Operation2 mult = new Operation2(){

        @Override
        public double[] calc(double factor, double[] input) {
            double[] result = new double[input.length];
            int i = 0;
            while (i < input.length) {
                result[i] = factor * input[i];
                ++i;
            }
            return result;
        }
    };

    protected Node(int dimension, double x, double y) {
        this.x = x;
        this.y = y;
        this.weights = new double[dimension];
        int i = 0;
        while (i < dimension) {
            this.weights[i] = Math.random();
            ++i;
        }
    }

    double getX() {
        return this.x;
    }

    double getY() {
        return this.y;
    }

    double[] getWeights() {
        return this.weights;
    }

    double eculideanDistance(double[] input) {
        double sum = 0.0;
        int i = 0;
        while (i < this.weights.length) {
            sum += (input[i] - this.weights[i]) * (input[i] - this.weights[i]);
            ++i;
        }
        return sum;
    }

    void adjustWeight(double[] input, double learningRate, double influence) {
        double[] diff = sub.calc(input, this.weights);
        double[] decayed = mult.calc(influence, mult.calc(learningRate, diff));
        this.weights = sum.calc(this.weights, decayed);
    }

    static interface Operation {
        public double[] calc(double[] var1, double[] var2);
    }

    static interface Operation2 {
        public double[] calc(double var1, double[] var3);
    }
}

