/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.database.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.generallib.database.Database;

public class DatabaseTransferTask
implements Runnable {
    private Plugin plugin;
    private List<TransferPair> pairs;

    public DatabaseTransferTask(Plugin plugin, List<TransferPair> pairs) {
        this.plugin = plugin;
        this.pairs = pairs;
    }

    public DatabaseTransferTask(Plugin plugin, Set<TransferPair> pairs) {
        this.plugin = plugin;
        this.pairs = new ArrayList<TransferPair>();
        this.pairs.addAll(pairs);
    }

    @Override
    public void run() {
        Bukkit.getPluginManager().disablePlugin(this.plugin);
        int pairi = 0;
        for (TransferPair pair : this.pairs) {
            Database from = pair.from;
            Database to = pair.to;
            Set<String> keys = from.getKeys();
            int i = 0;
            int percentage = -1;
            for (String key : keys) {
                try {
                    try {
                        Object data = from.load(key, null);
                        to.save(key, data);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (this.getPercentage(i, keys.size()) % 5 == 0) {
                            percentage = this.getPercentage(i, keys.size());
                            this.plugin.getLogger().info(String.valueOf(pairi) + ". " + pair.toString());
                            this.plugin.getLogger().info("Transfer [" + percentage + "%] done...");
                        }
                        ++i;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (this.getPercentage(i, keys.size()) % 5 == 0) {
                        percentage = this.getPercentage(i, keys.size());
                        this.plugin.getLogger().info(String.valueOf(pairi) + ". " + pair.toString());
                        this.plugin.getLogger().info("Transfer [" + percentage + "%] done...");
                    }
                    ++i;
                    throw throwable;
                }
                if (this.getPercentage(i, keys.size()) % 5 == 0) {
                    percentage = this.getPercentage(i, keys.size());
                    this.plugin.getLogger().info(String.valueOf(pairi) + ". " + pair.toString());
                    this.plugin.getLogger().info("Transfer [" + percentage + "%] done...");
                }
                ++i;
            }
            this.plugin.getLogger().info(String.valueOf(pairi) + ". " + pair.toString());
            this.plugin.getLogger().info("Transfer [100%] finished!");
            ++pairi;
        }
        Bukkit.getPluginManager().enablePlugin(this.plugin);
        System.gc();
    }

    private int getPercentage(int cur, int outOf) {
        return (int)((double)cur / (double)outOf * 100.0);
    }

    public static class TransferPair<T> {
        private Database<T> from;
        private Database<T> to;

        public TransferPair(Database<T> from, Database<T> to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return String.valueOf(this.from.getClass().getSimpleName()) + " ==> " + this.to.getClass().getSimpleName();
        }
    }
}

