/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.damage.util;

import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.generallib.possiblity.utils.Possibility;

public class DamageUtil {
    public static void damageNaturally(LivingEntity target, Entity damager, double damage) {
        int defensePoints = DamageUtil.getDefensePoints(target.getEquipment());
        int toughness = DamageUtil.getToughness(target.getEquipment());
        damage *= 1.0 - Math.min(20.0, Math.max((double)defensePoints / 5.0, (double)defensePoints - damage / (2.0 + (double)toughness / 4.0))) / 25.0;
        target.damage(damage);
    }

    public static void damageNaturally(ItemStack using, LivingEntity target, Entity damager) {
        double damage = DamageUtil.getWeaponDamage(using);
        damage += DamageUtil.getExtraDamageForEnchantment(using, target.getType());
        int defensePoints = DamageUtil.getDefensePoints(target.getEquipment());
        int toughness = DamageUtil.getToughness(target.getEquipment());
        damage *= 1.0 - Math.min(20.0, Math.max((double)defensePoints / 5.0, (double)defensePoints - damage / (2.0 + (double)toughness / 4.0))) / 25.0;
        target.damage(damage);
    }

    private static int getDefensePoints(EntityEquipment equip) {
        int sum = 0;
        ItemStack[] itemStackArray = equip.getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat;
            ItemStack IS = itemStackArray[n2];
            if (IS != null && (mat = IS.getType()) != Material.AIR && mat.name().contains("_")) {
                String[] split = mat.name().split("_");
                String material = split[0];
                String equipType = split[1];
                if (material.equals("LEATHER")) {
                    if (equipType.equals("HELMET")) {
                        ++sum;
                    } else if (equipType.equals("CHESTPLATE")) {
                        sum += 3;
                    } else if (equipType.equals("LEGGINGS")) {
                        sum += 2;
                    } else if (equipType.equals("BOOTS")) {
                        ++sum;
                    }
                } else if (material.equals("GOLD")) {
                    if (equipType.equals("HELMET")) {
                        sum += 2;
                    } else if (equipType.equals("CHESTPLATE")) {
                        sum += 5;
                    } else if (equipType.equals("LEGGINGS")) {
                        sum += 3;
                    } else if (equipType.equals("BOOTS")) {
                        ++sum;
                    }
                } else if (material.equals("CHAIN")) {
                    if (equipType.equals("HELMET")) {
                        sum += 2;
                    } else if (equipType.equals("CHESTPLATE")) {
                        sum += 5;
                    } else if (equipType.equals("LEGGINGS")) {
                        sum += 4;
                    } else if (equipType.equals("BOOTS")) {
                        ++sum;
                    }
                } else if (material.equals("IRON")) {
                    if (equipType.equals("HELMET")) {
                        sum += 2;
                    } else if (equipType.equals("CHESTPLATE")) {
                        sum += 6;
                    } else if (equipType.equals("LEGGINGS")) {
                        sum += 5;
                    } else if (equipType.equals("BOOTS")) {
                        sum += 2;
                    }
                } else if (material.equals("DIAMOND")) {
                    if (equipType.equals("HELMET")) {
                        sum += 3;
                    } else if (equipType.equals("CHESTPLATE")) {
                        sum += 8;
                    } else if (equipType.equals("LEGGINGS")) {
                        sum += 6;
                    } else if (equipType.equals("BOOTS")) {
                        sum += 3;
                    }
                }
            }
            ++n2;
        }
        return sum;
    }

    private static int getToughness(EntityEquipment equip) {
        int sum = 0;
        ItemStack[] itemStackArray = equip.getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat;
            String[] split;
            String material;
            ItemStack IS = itemStackArray[n2];
            if (IS != null && (material = (split = (mat = IS.getType()).name().split("_"))[0]).equals("DIAMOND")) {
                sum += 2;
            }
            ++n2;
        }
        return sum;
    }

    public static void consumeDurability(ItemStack tool) {
        int level = tool.getEnchantmentLevel(Enchantment.DURABILITY);
        if (level == 0) {
            tool.setDurability((short)(tool.getDurability() + 1));
        } else if (Possibility.isWin(1.0 / (double)(level + 1), 2)) {
            tool.setDurability((short)(tool.getDurability() + 1));
        }
    }

    public static boolean isBroken(ItemStack tool) {
        if (!tool.getType().name().endsWith("_AXE")) {
            return false;
        }
        return tool.getDurability() >= tool.getType().getMaxDurability();
    }

    public static double getWeaponDamage(ItemStack weapon) {
        Material mat = weapon.getType();
        String[] split = mat.name().split("_");
        if (split.length != 2) {
            return 1.0;
        }
        double damage = 1.0;
        String name = split[0];
        damage = split[1].equals("SWORD") ? (name.equals("WOOD") ? 4.0 : (name.equals("GOLD") ? 4.0 : (name.equals("STONE") ? 5.0 : (name.equals("IRON") ? 6.0 : (name.equals("DIAMOND") ? 7.0 : 1.0))))) : (split[1].equals("AXE") ? (name.equals("WOOD") ? 7.0 : (name.equals("GOLD") ? 7.0 : (name.equals("STONE") ? 9.0 : (name.equals("IRON") ? 9.0 : (name.equals("DIAMOND") ? 9.0 : 1.0))))) : 1.0);
        return damage;
    }

    public static double getExtraDamageForEnchantment(ItemStack weapon, EntityType target) {
        int sharpness = weapon.getEnchantmentLevel(Enchantment.DAMAGE_ALL);
        int smite = weapon.getEnchantmentLevel(Enchantment.DAMAGE_UNDEAD);
        int bane = weapon.getEnchantmentLevel(Enchantment.DAMAGE_ARTHROPODS);
        double damage = 0.0;
        if (sharpness > 0) {
            damage += 1.0;
            damage += (double)(--sharpness) * 0.5;
        }
        switch (target) {
            case SKELETON: 
            case ZOMBIE: 
            case PIG_ZOMBIE: 
            case WITHER: {
                damage += (double)smite * 2.5;
                break;
            }
            case SPIDER: 
            case CAVE_SPIDER: 
            case SILVERFISH: 
            case ENDERMITE: {
                damage += (double)bane * 2.5;
                break;
            }
        }
        return damage;
    }
}

