/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.model.BlockInfo;
import net.coreprotect.model.Config;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class Lookup
extends Queue {
    public static String block_lookup(Statement statement, Block block, String user, int offset, int page, int limit) {
        String result = "";
        try {
            if (block == null) {
                return result;
            }
            boolean found = false;
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int time = (int)(System.currentTimeMillis() / 1000L);
            int wid = Functions.getWorldId(block.getWorld().getName());
            int check_time = 0;
            int count = 0;
            int row_max = page * limit;
            int page_start = row_max - limit;
            if (offset > 0) {
                check_time = time - offset;
            }
            String query = "SELECT COUNT(*) as count from " + Config.prefix + "block WHERE wid = '" + wid + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND action IN(0,1) AND time >= '" + check_time + "' LIMIT 0, 1";
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            int total_pages = (int)Math.ceil((double)count / ((double)limit + 0.0));
            query = "SELECT time,user,action,type,data,rolled_back FROM " + Config.prefix + "block WHERE wid = '" + wid + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND action IN(0,1) AND time >= '" + check_time + "' ORDER BY rowid DESC LIMIT " + page_start + ", " + limit + "";
            rs = statement.executeQuery(query);
            while (rs.next()) {
                int result_userid = rs.getInt("user");
                int result_action = rs.getInt("action");
                int result_type = rs.getInt("type");
                int result_data = rs.getInt("data");
                int result_time = rs.getInt("time");
                int result_rolled_back = rs.getInt("rolled_back");
                if (Config.player_id_cache_reversed.get(result_userid) == null) {
                    Database.loadUserName(statement.getConnection(), result_userid);
                }
                String result_user = Config.player_id_cache_reversed.get(result_userid);
                double time_since = (double)time - ((double)result_time + 0.0);
                time_since /= 60.0;
                String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                if (!found) {
                    result = "\u00a7f----- \u00a73CoreProtect \u00a7f----- \u00a77(x" + x + "/y" + y + "/z" + z + ")\n";
                }
                found = true;
                String a2 = "placed";
                if (result_action == 0) {
                    a2 = "removed";
                } else if (result_action == 2) {
                    a2 = "clicked";
                } else if (result_action == 3) {
                    a2 = "killed";
                }
                String rbd = "";
                if (result_rolled_back == 1) {
                    rbd = "\u00a7m";
                }
                String dname = "";
                if (result_action == 3) {
                    dname = Functions.getEntityType(result_type).name();
                } else {
                    dname = Functions.nameFilter(Functions.getType(result_type).name().toLowerCase(), result_data);
                    dname = "minecraft:" + dname.toLowerCase();
                }
                if (dname.length() > 0) {
                    dname = "" + dname + "";
                }
                if (dname.contains("minecraft:")) {
                    String[] block_name_split = dname.split(":");
                    dname = block_name_split[1];
                }
                result = result + "\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + rbd + "" + result_user + " \u00a7f" + rbd + "" + a2 + " \u00a73" + rbd + "" + dname + "\u00a7f.\n";
            }
            rs.close();
            if (found) {
                if (count > limit) {
                    String n = "\u00a7f-----\n";
                    n = n + "\u00a7fPage " + page + "/" + total_pages + ". View older data by typing \"\u00a73/co l <page>\u00a7f\".\n";
                    result = result + n;
                }
            } else if (!found) {
                result = row_max > count && count > 0 ? "\u00a73CoreProtect \u00a7f- \u00a7fNo block data found for that page." : "\u00a73CoreProtect \u00a7f- \u00a7fNo block data found for this location.";
            }
            String bc = x + "." + y + "." + z + "." + wid + ".0." + limit;
            Config.lookup_page.put(user, page);
            Config.lookup_type.put(user, 2);
            Config.lookup_command.put(user, bc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<String[]> block_lookup_api(Block block, int offset) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        try {
            Connection connection;
            if (block == null) {
                return result;
            }
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int time = (int)(System.currentTimeMillis() / 1000L);
            int wid = Functions.getWorldId(block.getWorld().getName());
            int check_time = 0;
            if (offset > 0) {
                check_time = time - offset;
            }
            if ((connection = Database.getConnection(false)) == null) {
                return result;
            }
            Statement statement = connection.createStatement();
            String query = "SELECT time,user,action,type,data,rolled_back FROM " + Config.prefix + "block WHERE wid = '" + wid + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND time > '" + check_time + "' ORDER BY rowid DESC";
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                int result_time = rs.getInt("time");
                int result_userid = rs.getInt("user");
                int result_action = rs.getInt("action");
                int result_type = rs.getInt("type");
                int result_data = rs.getInt("data");
                int result_rolled_back = rs.getInt("rolled_back");
                if (Config.player_id_cache_reversed.get(result_userid) == null) {
                    Database.loadUserName(connection, result_userid);
                }
                String result_user = Config.player_id_cache_reversed.get(result_userid);
                String line = result_time + "," + result_user + "," + x + "." + y + "." + z + "," + result_type + "," + result_data + "," + result_action + "," + result_rolled_back + "," + wid + ",";
                String[] ldata = Functions.toStringArray(line);
                result.add(ldata);
            }
            rs.close();
            statement.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String chest_transactions(Statement statement, Location l, String lookup_user, int page, int limit) {
        String result = "";
        try {
            if (l == null) {
                return result;
            }
            boolean found = false;
            int x = (int)Math.floor(l.getX());
            int y = (int)Math.floor(l.getY());
            int z = (int)Math.floor(l.getZ());
            int x2 = (int)Math.ceil(l.getX());
            int y2 = (int)Math.ceil(l.getY());
            int z2 = (int)Math.ceil(l.getZ());
            int time = (int)(System.currentTimeMillis() / 1000L);
            int wid = Functions.getWorldId(l.getWorld().getName());
            int count = 0;
            int row_max = page * limit;
            int page_start = row_max - limit;
            String query = "SELECT COUNT(*) as count from " + Config.prefix + "container WHERE wid = '" + wid + "' AND (x = '" + x + "' OR x = '" + x2 + "') AND (z = '" + z + "' OR z = '" + z2 + "') AND y = '" + y + "' LIMIT 0, 1";
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            int total_pages = (int)Math.ceil((double)count / ((double)limit + 0.0));
            query = "SELECT time,user,action,type,data,amount,rolled_back FROM " + Config.prefix + "container WHERE wid = '" + wid + "' AND (x = '" + x + "' OR x = '" + x2 + "') AND (z = '" + z + "' OR z = '" + z2 + "') AND y = '" + y + "' ORDER BY rowid DESC LIMIT " + page_start + ", " + limit + "";
            rs = statement.executeQuery(query);
            while (rs.next()) {
                int result_userid = rs.getInt("user");
                int result_action = rs.getInt("action");
                int result_type = rs.getInt("type");
                int result_data = rs.getInt("data");
                int result_time = rs.getInt("time");
                int result_amount = rs.getInt("amount");
                int result_rolled_back = rs.getInt("rolled_back");
                if (Config.player_id_cache_reversed.get(result_userid) == null) {
                    Database.loadUserName(statement.getConnection(), result_userid);
                }
                String result_user = Config.player_id_cache_reversed.get(result_userid);
                double time_since = (double)time - ((double)result_time + 0.0);
                time_since /= 60.0;
                String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                if (!found) {
                    result = "\u00a7f----- \u00a73Container Transactions \u00a7f----- \u00a77(x" + x + "/y" + y + "/z" + z + ")\n";
                }
                found = true;
                String a2 = "added";
                if (result_action == 0) {
                    a2 = "removed";
                }
                String rbd = "";
                if (result_rolled_back == 1) {
                    rbd = "\u00a7m";
                }
                String dname = Functions.getType(result_type).name().toLowerCase();
                if ((dname = Functions.nameFilter(dname, result_data)).length() > 0) {
                    dname = "minecraft:" + dname.toLowerCase() + "";
                }
                if (dname.contains("minecraft:")) {
                    String[] block_name_split = dname.split(":");
                    dname = block_name_split[1];
                }
                result = result + "\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + rbd + "" + result_user + " \u00a7f" + rbd + "" + a2 + " x" + result_amount + " \u00a73" + rbd + "" + dname + "\u00a7f.\n";
            }
            rs.close();
            if (found) {
                if (count > limit) {
                    String n = "\u00a7f-----\n";
                    n = n + "\u00a7fPage " + page + "/" + total_pages + ". View older data by typing \"\u00a73/co l <page>\u00a7f\".\n";
                    result = result + n;
                }
            } else if (!found) {
                result = row_max > count && count > 0 ? "\u00a73CoreProtect \u00a7f- \u00a7fNo container transactions found for that page." : "\u00a73CoreProtect \u00a7f- \u00a7fNo container transactions at this location.";
            }
            String bc = x + "." + y + "." + z + "." + wid + "." + x2 + "." + y2 + "." + z2 + "." + limit;
            Config.lookup_type.put(lookup_user, 1);
            Config.lookup_page.put(lookup_user, page);
            Config.lookup_command.put(lookup_user, bc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static List<String[]> convertRawLookup(Statement statement, List<Object[]> list) {
        ArrayList<String[]> new_list = new ArrayList<String[]>();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object[] map = list.get(i);
            int new_length = map.length - 1;
            String[] results = new String[new_length];
            for (int i2 = 0; i2 < map.length; ++i2) {
                try {
                    int new_id = i2 - 1;
                    if (i2 == 2) {
                        if (map[i2] instanceof Integer) {
                            String user_result;
                            int user_id = (Integer)map[i2];
                            if (Config.player_id_cache_reversed.get(user_id) == null) {
                                Database.loadUserName(statement.getConnection(), user_id);
                            }
                            results[new_id] = user_result = Config.player_id_cache_reversed.get(user_id);
                            continue;
                        }
                        results[new_id] = (String)map[i2];
                        continue;
                    }
                    if (i2 <= 0) continue;
                    if (map[i2] instanceof Integer) {
                        results[new_id] = map[i2].toString();
                        continue;
                    }
                    if (!(map[i2] instanceof String)) continue;
                    results[new_id] = (String)map[i2];
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            new_list.add(results);
        }
        return new_list;
    }

    public static int countLookupRows(Statement statement, CommandSender user, List<String> check_uuids, List<String> check_users, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, Location location, Integer[] radius, int check_time, boolean restrict_world, boolean lookup) {
        int rows = 0;
        try {
            while (Consumer.is_paused) {
                Thread.sleep(1L);
            }
            Consumer.is_paused = true;
            ResultSet rs = Lookup.rawLookupResultSet(statement, user, check_uuids, check_users, restrict_list, exclude_list, exclude_user_list, action_list, location, radius, check_time, -1, -1, restrict_world, lookup, true);
            while (rs.next()) {
                rows = rs.getInt("count");
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Consumer.is_paused = false;
        return rows;
    }

    public static void finishRollbackRestore(CommandSender user, Location location, List<String> check_users, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, String time_string, int file, int seconds, int item_count, int block_count, int entity_count, int rollback_type, Integer[] radius, boolean verbose, boolean restrict_world, int preview) {
        try {
            String e;
            String value_name;
            if (preview == 2) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Preview cancelled.");
                return;
            }
            user.sendMessage("-----");
            String users = "";
            for (String value : check_users) {
                if (users.length() == 0) {
                    users = "" + value + "";
                    continue;
                }
                users = users + ", " + value;
            }
            if (users.equals("#global") && restrict_world) {
                users = "#" + location.getWorld().getName();
            }
            if (preview > 0) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Preview completed for \"" + users + "\".");
            } else if (rollback_type == 1) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Restore completed for \"" + users + "\".");
            } else if (rollback_type == 0) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Rollback completed for \"" + users + "\".");
            }
            if (preview == 1) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Time:" + time_string + ".");
            } else if (rollback_type == 1) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Restored" + time_string + ".");
            } else if (rollback_type == 0) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Rolled back" + time_string + ".");
            }
            if (radius != null) {
                int worldedit = radius[7];
                if (worldedit == 0) {
                    int rad = radius[0];
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Radius: " + rad + " block(s).");
                } else {
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Radius: #worldedit.");
                }
            }
            if (restrict_world && radius == null && location != null) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to world: \"" + location.getWorld().getName() + "\".");
            }
            if (action_list.contains(4)) {
                if (action_list.contains(0)) {
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to action: \"-container\".");
                } else if (action_list.contains(1)) {
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to action: \"+container\".");
                }
            } else if (action_list.contains(0) && action_list.contains(1)) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to action: \"block-change\".");
            } else if (action_list.contains(0)) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to action: \"block-break\".");
            } else if (action_list.contains(1)) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to action: \"block-place\".");
            } else if (action_list.contains(3)) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to action: \"entity-kill\".");
            }
            if (restrict_list.size() > 0) {
                String r = "";
                int rc = 0;
                for (Object object : restrict_list) {
                    value_name = "";
                    if (object instanceof Material) {
                        value_name = ((Material)object).name().toLowerCase();
                    } else if (object instanceof EntityType) {
                        value_name = ((EntityType)object).name().toLowerCase();
                    }
                    r = rc == 0 ? "" + value_name + "" : r + ", " + value_name;
                    ++rc;
                }
                user.sendMessage("\u00a73CoreProtect \u00a7f- Limited to block type(s): " + r + ".");
            }
            if (exclude_list.size() > 0) {
                e = "";
                int ec = 0;
                for (Object object : exclude_list) {
                    value_name = "";
                    if (object instanceof Material) {
                        value_name = ((Material)object).name().toLowerCase();
                    } else if (object instanceof EntityType) {
                        value_name = ((EntityType)object).name().toLowerCase();
                    }
                    e = ec == 0 ? "" + value_name + "" : e + ", " + value_name;
                    ++ec;
                }
                user.sendMessage("\u00a73CoreProtect \u00a7f- Excluded block type(s): " + e + ".");
            }
            if (exclude_user_list.size() > 0) {
                e = "";
                int ec = 0;
                for (String string : exclude_user_list) {
                    e = ec == 0 ? "" + string + "" : e + ", " + string;
                    ++ec;
                }
                user.sendMessage("\u00a73CoreProtect \u00a7f- Excluded user(s): " + e + ".");
            }
            if (action_list.contains(5)) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Approx. " + block_count + " item(s) changed.");
            } else if (preview == 0) {
                if (item_count > 0) {
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Approx. " + item_count + " item(s) changed.");
                }
                if (entity_count > 0) {
                    if (entity_count == 1) {
                        user.sendMessage("\u00a73CoreProtect \u00a7f- Approx. " + entity_count + " entity changed.");
                    } else {
                        user.sendMessage("\u00a73CoreProtect \u00a7f- Approx. " + entity_count + " entities changed.");
                    }
                }
                user.sendMessage("\u00a73CoreProtect \u00a7f- Approx. " + block_count + " block(s) changed.");
            } else if (preview > 0) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Approx. " + block_count + " block(s) to change.");
            }
            if (verbose && preview == 0 && file > -1) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Modified " + file + " chunk(s).");
            }
            if (preview == 0) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Time taken: " + seconds + " second(s).");
            }
            user.sendMessage("-----");
            if (preview > 0) {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Please select: \"/co apply\" or \"/co cancel\".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String interaction_lookup(Statement statement, Block block, String user, int offset, int page, int limit) {
        String result = "";
        try {
            if (block == null) {
                return result;
            }
            boolean found = false;
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int time = (int)(System.currentTimeMillis() / 1000L);
            int wid = Functions.getWorldId(block.getWorld().getName());
            int check_time = 0;
            int count = 0;
            int row_max = page * limit;
            int page_start = row_max - limit;
            if (offset > 0) {
                check_time = time - offset;
            }
            String query = "SELECT COUNT(*) as count from " + Config.prefix + "block WHERE wid = '" + wid + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND action='2' AND time >= '" + check_time + "' LIMIT 0, 1";
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                count = rs.getInt("count");
            }
            rs.close();
            int total_pages = (int)Math.ceil((double)count / ((double)limit + 0.0));
            query = "SELECT time,user,action,type,data,rolled_back FROM " + Config.prefix + "block WHERE wid = '" + wid + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND action='2' AND time >= '" + check_time + "' ORDER BY rowid DESC LIMIT " + page_start + ", " + limit + "";
            rs = statement.executeQuery(query);
            while (rs.next()) {
                int result_userid = rs.getInt("user");
                int result_action = rs.getInt("action");
                int result_type = rs.getInt("type");
                int result_data = rs.getInt("data");
                int result_time = rs.getInt("time");
                int result_rolled_back = rs.getInt("rolled_back");
                if (Config.player_id_cache_reversed.get(result_userid) == null) {
                    Database.loadUserName(statement.getConnection(), result_userid);
                }
                String result_user = Config.player_id_cache_reversed.get(result_userid);
                double time_since = (double)time - ((double)result_time + 0.0);
                time_since /= 60.0;
                String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                if (!found) {
                    result = "\u00a7f----- \u00a73Player Interactions \u00a7f----- \u00a77(x" + x + "/y" + y + "/z" + z + ")\n";
                }
                found = true;
                String a2 = "placed";
                if (result_action == 0) {
                    a2 = "removed";
                } else if (result_action == 2) {
                    a2 = "clicked";
                }
                String rbd = "";
                if (result_rolled_back == 1) {
                    rbd = "\u00a7m";
                }
                String dname = Functions.getType(result_type).name().toLowerCase();
                if ((dname = Functions.nameFilter(dname, result_data)).length() > 0) {
                    dname = "minecraft:" + dname.toLowerCase() + "";
                }
                if (dname.contains("minecraft:")) {
                    String[] block_name_split = dname.split(":");
                    dname = block_name_split[1];
                }
                result = result + "\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + rbd + "" + result_user + " \u00a7f" + rbd + "" + a2 + " \u00a73" + rbd + "" + dname + "\u00a7f.\n";
            }
            rs.close();
            if (found) {
                if (count > limit) {
                    String n = "\u00a7f-----\n";
                    n = n + "\u00a7fPage " + page + "/" + total_pages + ". View older data by typing \"\u00a73/co l <page>\u00a7f\".\n";
                    result = result + n;
                }
            } else if (!found) {
                result = row_max > count && count > 0 ? "\u00a73CoreProtect \u00a7f- \u00a7fNo player interactions found for that page." : "\u00a73CoreProtect \u00a7f- \u00a7fNo player interactions found for this location.";
            }
            String bc = x + "." + y + "." + z + "." + wid + ".2." + limit;
            Config.lookup_page.put(user, page);
            Config.lookup_type.put(user, 7);
            Config.lookup_command.put(user, bc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void modifyContainerItems(Material type, Object container, int slot, ItemStack itemstack, int action) {
        try {
            ItemStack[] contents = null;
            if (type.equals((Object)Material.ARMOR_STAND)) {
                EntityEquipment equipment = (EntityEquipment)container;
                if (equipment != null) {
                    contents = equipment.getArmorContents();
                    if (action == 1) {
                        itemstack.setAmount(1);
                    } else {
                        itemstack.setType(Material.AIR);
                        itemstack.setAmount(0);
                    }
                    if (slot >= 0) {
                        contents[slot] = itemstack;
                    }
                    equipment.setArmorContents(contents);
                }
            } else {
                Inventory inventory = (Inventory)container;
                if (inventory != null) {
                    int amount = itemstack.getAmount();
                    itemstack.setAmount(1);
                    for (int count = 0; count < amount; ++count) {
                        if (action == 1) {
                            inventory.addItem(new ItemStack[]{itemstack});
                            continue;
                        }
                        inventory.removeItem(new ItemStack[]{itemstack});
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void performContainerRollbackRestore(Statement statement, CommandSender user, List<String> check_uuids, List<String> check_users, String time_string, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, final Location location, Integer[] radius, int check_time, boolean restrict_world, boolean lookup, boolean verbose, final int rollback_type) {
        try {
            long time1 = System.currentTimeMillis();
            final List<Object[]> lookup_list = Lookup.performLookupRaw(statement, user, check_uuids, check_users, restrict_list, exclude_list, exclude_user_list, action_list, location, radius, check_time, -1, -1, restrict_world, lookup);
            if (rollback_type == 1) {
                Collections.reverse(lookup_list);
            }
            String user_string = "#server";
            if (user != null) {
                user_string = user.getName();
            }
            Queue.queueContainerRollbackUpdate(user_string, location, lookup_list, rollback_type);
            final String final_user_string = user_string;
            Config.rollback_hash.put(user_string, new int[]{0, 0, 0, 0});
            CoreProtect.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CoreProtect.getInstance(), new Runnable(){

                @Override
                public void run() {
                    try {
                        int[] rollback_hash_data = Config.rollback_hash.get(final_user_string);
                        int item_count = rollback_hash_data[0];
                        int entity_count = rollback_hash_data[2];
                        Block block = location.getBlock();
                        if (!block.getWorld().isChunkLoaded(block.getChunk())) {
                            block.getWorld().loadChunk(block.getChunk());
                        }
                        Inventory container = null;
                        Material type = block.getType();
                        if (BlockInfo.containers.contains(type)) {
                            container = Functions.getContainerInventory(block.getState(), false);
                        } else {
                            for (Entity entity : block.getChunk().getEntities()) {
                                if (!(entity instanceof ArmorStand) || entity.getLocation().getBlockX() != location.getBlockX() || entity.getLocation().getBlockY() != location.getBlockY() || entity.getLocation().getBlockZ() != location.getBlockZ()) continue;
                                type = Material.ARMOR_STAND;
                                container = Functions.getEntityEquipment((LivingEntity)entity);
                            }
                        }
                        int modify_count = 0;
                        if (container != null) {
                            for (Object[] row : lookup_list) {
                                int row_type_raw = (Integer)row[6];
                                int row_data = (Integer)row[7];
                                int row_action = (Integer)row[8];
                                int row_rolled_back = (Integer)row[9];
                                int row_amount = (Integer)row[11];
                                byte[] row_metadata = (byte[])row[12];
                                Material row_type = Functions.getType(row_type_raw);
                                if ((rollback_type != 0 || row_rolled_back != 0) && (rollback_type != 1 || row_rolled_back != 1)) continue;
                                modify_count += row_amount;
                                int action = 0;
                                if (rollback_type == 0 && row_action == 0) {
                                    action = 1;
                                }
                                if (rollback_type == 1 && row_action == 1) {
                                    action = 1;
                                }
                                ItemStack itemstack = new ItemStack(row_type, row_amount, (short)row_data);
                                Object[] populatedStack = Lookup.populateItemStack(itemstack, row_metadata);
                                int slot = (Integer)populatedStack[0];
                                itemstack = (ItemStack)populatedStack[1];
                                Lookup.modifyContainerItems(type, container, slot, itemstack, action);
                            }
                        }
                        Config.rollback_hash.put(final_user_string, new int[]{item_count, modify_count, entity_count, 1});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, 0L);
            int[] rollback_hash_data = Config.rollback_hash.get(final_user_string);
            int next = rollback_hash_data[3];
            int sleep_time = 0;
            while (next == 0) {
                Thread.sleep(5L);
                rollback_hash_data = Config.rollback_hash.get(final_user_string);
                next = rollback_hash_data[3];
                if ((sleep_time += 5) <= 300000) continue;
                System.out.println("[CoreProtect] Rollback or restore aborted.");
                break;
            }
            rollback_hash_data = Config.rollback_hash.get(final_user_string);
            int block_count = rollback_hash_data[1];
            long time2 = System.currentTimeMillis();
            int seconds = (int)((time2 - time1) / 1000L);
            if (user != null) {
                int file = -1;
                if (block_count > 0) {
                    file = 1;
                }
                int item_count = 0;
                int entity_count = 0;
                Lookup.finishRollbackRestore(user, location, check_users, restrict_list, exclude_list, exclude_user_list, action_list, time_string, file, seconds, item_count, block_count, entity_count, rollback_type, radius, verbose, restrict_world, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String[]> performLookup(Statement statement, CommandSender user, List<String> check_uuids, List<String> check_users, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, Location location, Integer[] radius, int check_time, boolean restrict_world, boolean lookup) {
        List<String[]> new_list = new ArrayList<String[]>();
        try {
            List<Object[]> lookup_list = Lookup.performLookupRaw(statement, user, check_uuids, check_users, restrict_list, exclude_list, exclude_user_list, action_list, location, radius, check_time, -1, -1, restrict_world, lookup);
            new_list = Lookup.convertRawLookup(statement, lookup_list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new_list;
    }

    public static List<Object[]> performLookupRaw(Statement statement, CommandSender user, List<String> check_uuids, List<String> check_users, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, Location location, Integer[] radius, int check_time, int limit_offset, int limit_count, boolean restrict_world, boolean lookup) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        ArrayList<Integer> invalid_rollback_actions = new ArrayList<Integer>();
        invalid_rollback_actions.add(2);
        if (Config.config.get("rollback-entities") == 0 && !action_list.contains(3)) {
            invalid_rollback_actions.add(3);
        }
        try {
            while (Consumer.is_paused) {
                Thread.sleep(1L);
            }
            Consumer.is_paused = true;
            ResultSet rs = Lookup.rawLookupResultSet(statement, user, check_uuids, check_users, restrict_list, exclude_list, exclude_user_list, action_list, location, radius, check_time, limit_offset, limit_count, restrict_world, lookup, false);
            while (rs.next()) {
                Object[] data_array;
                int result_id;
                if (action_list.contains(6) || action_list.contains(7)) {
                    result_id = rs.getInt("id");
                    int result_time = rs.getInt("time");
                    int result_userid = rs.getInt("user");
                    String result_message = rs.getString("message");
                    Object[] data_array2 = new Object[]{result_id, result_time, result_userid, result_message};
                    list.add(data_array2);
                    continue;
                }
                if (action_list.contains(8)) {
                    result_id = rs.getInt("id");
                    int result_time = rs.getInt("time");
                    int result_userid = rs.getInt("user");
                    int result_wid = rs.getInt("wid");
                    int result_x = rs.getInt("x");
                    int result_y = rs.getInt("y");
                    int result_z = rs.getInt("z");
                    int result_action = rs.getInt("action");
                    Object[] data_array3 = new Object[]{result_id, result_time, result_userid, result_wid, result_x, result_y, result_z, result_action};
                    list.add(data_array3);
                    continue;
                }
                if (action_list.contains(9)) {
                    result_id = rs.getInt("id");
                    int result_time = rs.getInt("time");
                    String result_uuid = rs.getString("uuid");
                    String result_user = rs.getString("user");
                    Object[] data_array4 = new Object[]{result_id, result_time, result_uuid, result_user};
                    list.add(data_array4);
                    continue;
                }
                int result_amount = 0;
                byte[] result_meta = null;
                int result_id2 = rs.getInt("id");
                int result_userid = rs.getInt("user");
                int result_action = rs.getInt("action");
                int result_type = rs.getInt("type");
                int result_data = rs.getInt("data");
                int result_rolled_back = rs.getInt("rolled_back");
                int result_time = rs.getInt("time");
                int result_x = rs.getInt("x");
                int result_y = rs.getInt("y");
                int result_z = rs.getInt("z");
                int result_wid = rs.getInt("wid");
                if (action_list.contains(4) || action_list.contains(5)) {
                    result_amount = rs.getInt("amount");
                    result_meta = rs.getBytes("metadata");
                } else {
                    result_meta = rs.getBytes("meta");
                }
                boolean valid = true;
                if (!lookup && invalid_rollback_actions.contains(result_action)) {
                    valid = false;
                }
                if (!valid) continue;
                if (action_list.contains(4) || action_list.contains(5)) {
                    data_array = new Object[]{result_id2, result_time, result_userid, result_x, result_y, result_z, result_type, result_data, result_action, result_rolled_back, result_wid, result_amount, result_meta};
                    list.add(data_array);
                    continue;
                }
                data_array = new Object[]{result_id2, result_time, result_userid, result_x, result_y, result_z, result_type, result_data, result_action, result_rolled_back, result_wid, result_meta};
                list.add(data_array);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Consumer.is_paused = false;
        return list;
    }

    public static List<String[]> performPartialLookup(Statement statement, CommandSender user, List<String> check_uuids, List<String> check_users, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, Location location, Integer[] radius, int check_time, int limit_offset, int limit_count, boolean restrict_world, boolean lookup) {
        List<String[]> new_list = new ArrayList<String[]>();
        try {
            List<Object[]> lookup_list = Lookup.performLookupRaw(statement, user, check_uuids, check_users, restrict_list, exclude_list, exclude_user_list, action_list, location, radius, check_time, limit_offset, limit_count, restrict_world, lookup);
            new_list = Lookup.convertRawLookup(statement, lookup_list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new_list;
    }

    public static List<String[]> performRollbackRestore(Statement statement, CommandSender user, List<String> check_uuids, List<String> check_users, String time_string, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, Location location, Integer[] radius, int check_time, boolean restrict_world, boolean lookup, boolean verbose, final int rollback_type, final int preview) {
        ArrayList<String[]> list = new ArrayList();
        try {
            long time1 = System.currentTimeMillis();
            List<Object> lookup_list = new ArrayList();
            if (!(action_list.contains(4) || action_list.contains(5) || check_users.contains("#container"))) {
                lookup_list = Lookup.performLookupRaw(statement, user, check_uuids, check_users, restrict_list, exclude_list, exclude_user_list, action_list, location, radius, check_time, -1, -1, restrict_world, lookup);
            }
            if (lookup_list == null) {
                return null;
            }
            List<Object[]> item_list = new ArrayList<Object[]>();
            if (Config.config.get("rollback-items") == 1 && !check_users.contains("#container") && (action_list.size() == 0 || action_list.contains(4)) && preview == 0) {
                ArrayList<Integer> item_action_list = new ArrayList<Integer>();
                item_action_list.addAll(action_list);
                if (!item_action_list.contains(4)) {
                    item_action_list.add(4);
                }
                item_list = Lookup.performLookupRaw(statement, user, check_uuids, check_users, restrict_list, exclude_list, exclude_user_list, item_action_list, location, radius, check_time, -1, -1, restrict_world, lookup);
            }
            TreeMap<String, Integer> chunk_list = new TreeMap<String, Integer>();
            HashMap data_list = new HashMap();
            HashMap item_data_list = new HashMap();
            for (int list_c = 0; list_c < 2; ++list_c) {
                List<Object> scan_list = lookup_list;
                if (list_c == 1) {
                    scan_list = item_list;
                }
                for (Object[] objectArray : scan_list) {
                    int user_id = (Integer)objectArray[2];
                    int n = (Integer)objectArray[3] >> 4;
                    int chunk_z = (Integer)objectArray[5] >> 4;
                    if (chunk_list.get(n + "." + chunk_z) == null) {
                        int distance = 0;
                        if (location != null) {
                            distance = (int)Math.sqrt(Math.pow((Integer)objectArray[3] - location.getBlockX(), 2.0) + Math.pow((Integer)objectArray[5] - location.getBlockZ(), 2.0));
                        }
                        chunk_list.put(n + "." + chunk_z, distance);
                    }
                    if (Config.player_id_cache_reversed.get(user_id) == null) {
                        Database.loadUserName(statement.getConnection(), user_id);
                    }
                    HashMap modify_list = data_list;
                    if (list_c == 1) {
                        modify_list = item_data_list;
                    }
                    if (modify_list.get(n + "." + chunk_z) == null) {
                        data_list.put(n + "." + chunk_z, new ArrayList());
                        item_data_list.put(n + "." + chunk_z, new ArrayList());
                    }
                    ((ArrayList)modify_list.get(n + "." + chunk_z)).add(objectArray);
                }
            }
            if (rollback_type == 1) {
                Iterator it = data_list.entrySet().iterator();
                while (it.hasNext()) {
                    Collections.reverse((List)it.next().getValue());
                }
                it = item_data_list.entrySet().iterator();
                while (it.hasNext()) {
                    Collections.reverse((List)it.next().getValue());
                }
            }
            int file = 0;
            String user_string = "#server";
            if (user != null) {
                user_string = user.getName();
                if (verbose && preview == 0) {
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Found " + chunk_list.size() + " chunk(s) to modify.");
                }
            }
            if (preview == 0) {
                Queue.queueRollbackUpdate(user_string, location, lookup_list, rollback_type);
                Queue.queueContainerRollbackUpdate(user_string, location, item_list, rollback_type);
            }
            Config.rollback_hash.put(user_string, new int[]{0, 0, 0, 0});
            final String string = user_string;
            for (Map.Entry entry : Functions.entriesSortedByValues(chunk_list)) {
                ++file;
                int item_count = 0;
                int block_count = 0;
                int entity_count = 0;
                int[] rollback_hash_data = Config.rollback_hash.get(string);
                item_count = rollback_hash_data[0];
                block_count = rollback_hash_data[1];
                entity_count = rollback_hash_data[2];
                String[] chunk_cords = ((String)entry.getKey()).split("\\.");
                final int final_chunk_x = Integer.parseInt(chunk_cords[0]);
                final int final_chunk_z = Integer.parseInt(chunk_cords[1]);
                final CommandSender final_user = user;
                final HashMap final_block_list = data_list;
                final HashMap final_item_list = item_data_list;
                Config.rollback_hash.put(string, new int[]{item_count, block_count, entity_count, 0});
                CoreProtect.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CoreProtect.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Player player;
                            Location location;
                            Chunk chunk;
                            Block block;
                            boolean clearInventories = false;
                            if (Config.config.get("rollback-items") == 1) {
                                clearInventories = true;
                            }
                            ArrayList data = (ArrayList)final_block_list.get(final_chunk_x + "." + final_chunk_z);
                            ArrayList item_data = (ArrayList)final_item_list.get(final_chunk_x + "." + final_chunk_z);
                            HashMap<String, Integer> hanging_delay = new HashMap<String, Integer>();
                            for (Object[] row : data) {
                                String world;
                                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                                int[] rollback_hash_data = Config.rollback_hash.get(string);
                                int item_count = rollback_hash_data[0];
                                int block_count = rollback_hash_data[1];
                                int entity_count = rollback_hash_data[2];
                                int row_time = (Integer)row[1];
                                int row_userid = (Integer)row[2];
                                int row_x = (Integer)row[3];
                                int row_y = (Integer)row[4];
                                int row_z = (Integer)row[5];
                                int row_type_raw = (Integer)row[6];
                                int row_data = (Integer)row[7];
                                int row_action = (Integer)row[8];
                                int row_rolled_back = (Integer)row[9];
                                int row_wid = (Integer)row[10];
                                byte[] row_meta = (byte[])row[11];
                                Material row_type = Functions.getType(row_type_raw);
                                List meta = null;
                                if (row_meta != null) {
                                    List list;
                                    ByteArrayInputStream bais = new ByteArrayInputStream(row_meta);
                                    ObjectInputStream ins = new ObjectInputStream(bais);
                                    meta = list = (List)ins.readObject();
                                }
                                String row_user = Config.player_id_cache_reversed.get(row_userid);
                                int old_type_raw = row_type_raw;
                                Material old_type_material = Functions.getType(old_type_raw);
                                if (row_action == 1 && rollback_type == 0) {
                                    row_type = Material.AIR;
                                    row_type_raw = 0;
                                } else if (row_action == 0 && rollback_type == 1) {
                                    row_type = Material.AIR;
                                    row_type_raw = 0;
                                } else if (row_action == 4 && rollback_type == 0) {
                                    row_type = null;
                                    row_type_raw = 0;
                                } else if (row_action == 3 && rollback_type == 1) {
                                    row_type = null;
                                    row_type_raw = 0;
                                }
                                if (preview > 0) {
                                    if (row_action != 3) {
                                        Player player2 = (Player)final_user;
                                        world = Functions.getWorldName(row_wid);
                                        Location location2 = new Location(CoreProtect.getInstance().getServer().getWorld(world), (double)row_x, (double)row_y, (double)row_z);
                                        if (preview == 2) {
                                            Block block2 = location2.getBlock();
                                            Material block_type = block2.getType();
                                            byte block_data = Functions.getData(block2);
                                            if (!(block_type.equals((Object)Material.PAINTING) || block_type.equals((Object)Material.ITEM_FRAME) || block_type.equals((Object)Material.ARMOR_STAND))) {
                                                Functions.sendBlockChange(player2, location2, block_type, block_data);
                                            }
                                        } else if (!(row_type.equals((Object)Material.PAINTING) || row_type.equals((Object)Material.ITEM_FRAME) || row_type.equals((Object)Material.ARMOR_STAND))) {
                                            Functions.sendBlockChange(player2, location2, row_type, (byte)row_data);
                                            ++block_count;
                                        }
                                    }
                                } else if (row_action == 3) {
                                    String world2 = Functions.getWorldName(row_wid);
                                    Block block3 = CoreProtect.getInstance().getServer().getWorld(world2).getBlockAt(row_x, row_y, row_z);
                                    if (!CoreProtect.getInstance().getServer().getWorld(world2).isChunkLoaded(block3.getChunk())) {
                                        CoreProtect.getInstance().getServer().getWorld(world2).loadChunk(block3.getChunk());
                                    }
                                    if (row_type_raw > 0) {
                                        if (row_rolled_back == 0) {
                                            EntityType entity_type = Functions.getEntityType(row_type_raw);
                                            Lookup.queueEntitySpawn(row_user, block3.getState(), entity_type, row_data);
                                        }
                                    } else if (old_type_raw > 0 && row_rolled_back == 1) {
                                        boolean removed = false;
                                        int entity_id = -1;
                                        String entity_name = Functions.getEntityType(old_type_raw).name();
                                        String token = "" + row_x + "." + row_y + "." + row_z + "." + row_wid + "." + entity_name + "";
                                        Object[] cached_entity = Config.entity_cache.get(token);
                                        if (cached_entity != null) {
                                            entity_id = (Integer)cached_entity[1];
                                        }
                                        int xmin = row_x - 5;
                                        int xmax = row_x + 5;
                                        int ymin = row_y - 1;
                                        int ymax = row_y + 1;
                                        int zmin = row_z - 5;
                                        int zmax = row_z + 5;
                                        for (Entity e : block3.getChunk().getEntities()) {
                                            if (entity_id > -1) {
                                                int id = e.getEntityId();
                                                if (id != entity_id) continue;
                                                ++entity_count;
                                                removed = true;
                                                e.remove();
                                                break;
                                            }
                                            if (!e.getType().equals((Object)Functions.getEntityType(old_type_raw))) continue;
                                            Location el = e.getLocation();
                                            int e_x = el.getBlockX();
                                            int e_y = el.getBlockY();
                                            int e_z = el.getBlockZ();
                                            if (e_x < xmin || e_x > xmax || e_y < ymin || e_y > ymax || e_z < zmin || e_z > zmax) continue;
                                            ++entity_count;
                                            removed = true;
                                            e.remove();
                                            break;
                                        }
                                        if (!removed && entity_id > -1) {
                                            for (Entity e : block3.getWorld().getLivingEntities()) {
                                                int id = e.getEntityId();
                                                if (id != entity_id) continue;
                                                ++entity_count;
                                                removed = true;
                                                e.remove();
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    boolean change_block;
                                    block124: {
                                        List<Material> update_state = Arrays.asList(Material.POWERED_RAIL, Material.DETECTOR_RAIL, Material.TORCH, Material.REDSTONE_WIRE, Material.BURNING_FURNACE, Material.LEVER, Material.REDSTONE_TORCH_OFF, Material.REDSTONE_TORCH_ON, Material.GLOWSTONE, Material.JACK_O_LANTERN, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.REDSTONE_LAMP_ON, Material.BEACON, Material.REDSTONE_COMPARATOR_OFF, Material.REDSTONE_COMPARATOR_ON, Material.DAYLIGHT_DETECTOR, Material.REDSTONE_BLOCK, Material.HOPPER, Material.ACTIVATOR_RAIL);
                                        world = Functions.getWorldName(row_wid);
                                        block = CoreProtect.getInstance().getServer().getWorld(world).getBlockAt(row_x, row_y, row_z);
                                        if (!CoreProtect.getInstance().getServer().getWorld(world).isChunkLoaded(block.getChunk())) {
                                            CoreProtect.getInstance().getServer().getWorld(world).loadChunk(block.getChunk());
                                        }
                                        change_block = true;
                                        boolean count_block = true;
                                        Material ctype = block.getType();
                                        byte cdata = Functions.getData(block);
                                        if (row_rolled_back == 1 && rollback_type == 0) {
                                            count_block = false;
                                        }
                                        if (!(!row_type.equals((Object)ctype) || old_type_material.equals((Object)Material.PAINTING) || old_type_material.equals((Object)Material.ITEM_FRAME) || old_type_material.equals((Object)Material.ARMOR_STAND) || old_type_material.equals((Object)Material.END_CRYSTAL))) {
                                            if (row_data == cdata) {
                                                change_block = false;
                                            }
                                            count_block = false;
                                        } else if (!ctype.equals((Object)Material.AIR)) {
                                            count_block = true;
                                        }
                                        if (count_block) {
                                            List<Material> c1 = Arrays.asList(Material.GRASS, Material.WATER, Material.LAVA);
                                            List<Material> c2 = Arrays.asList(Material.DIRT, Material.STATIONARY_WATER, Material.STATIONARY_LAVA);
                                            int c = 0;
                                            for (Material cv1 : c1) {
                                                Material cv2 = c2.get(c);
                                                if (row_type.equals((Object)cv1) && ctype.equals((Object)cv2) || row_type.equals((Object)cv2) && ctype.equals((Object)cv1)) {
                                                    count_block = false;
                                                }
                                                ++c;
                                            }
                                        }
                                        try {
                                            int i$;
                                            if (!change_block) break block124;
                                            if (row_type.equals((Object)Material.AIR) && (old_type_material.equals((Object)Material.PAINTING) || old_type_material.equals((Object)Material.ITEM_FRAME))) {
                                                int delay = Functions.getHangingDelay(hanging_delay, row_wid, row_x, row_y, row_z);
                                                Lookup.queueHangingRemove(row_user, block.getState(), delay);
                                                break block124;
                                            }
                                            if (row_type.equals((Object)Material.DOUBLE_PLANT) || row_type.equals((Object)Material.AIR) && old_type_material.equals((Object)Material.DOUBLE_PLANT)) {
                                                if (row_data < 8) {
                                                    int top_data = 8;
                                                    if (row_data == 0 || row_data == 4) {
                                                        top_data = 9;
                                                    }
                                                    Block block_above = CoreProtect.getInstance().getServer().getWorld(world).getBlockAt(row_x, row_y + 1, row_z);
                                                    Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                    Functions.setTypeAndData(block_above, row_type, (byte)top_data, false);
                                                }
                                                break block124;
                                            }
                                            if (row_type.equals((Object)Material.PAINTING) || row_type.equals((Object)Material.ITEM_FRAME)) {
                                                int delay = Functions.getHangingDelay(hanging_delay, row_wid, row_x, row_y, row_z);
                                                Lookup.queueHangingSpawn(row_user, block.getState(), row_type, row_data, delay);
                                                break block124;
                                            }
                                            if (row_type.equals((Object)Material.ARMOR_STAND)) {
                                                Location location3 = block.getLocation();
                                                location3.setX(location3.getX() + 0.5);
                                                location3.setZ(location3.getZ() + 0.5);
                                                location3.setYaw((float)row_data);
                                                boolean exists = false;
                                                for (Entity entity : block.getChunk().getEntities()) {
                                                    if (!(entity instanceof ArmorStand) || entity.getLocation().getBlockX() != location3.getBlockX() || entity.getLocation().getBlockY() != location3.getBlockY() || entity.getLocation().getBlockZ() != location3.getBlockZ()) continue;
                                                    exists = true;
                                                }
                                                if (!exists) {
                                                    Entity entity = block.getLocation().getWorld().spawnEntity(location3, EntityType.ARMOR_STAND);
                                                    entity.teleport(location3);
                                                }
                                                break block124;
                                            }
                                            if (row_type.equals((Object)Material.END_CRYSTAL)) {
                                                Location location4 = block.getLocation();
                                                location4.setX(location4.getX() + 0.5);
                                                location4.setZ(location4.getZ() + 0.5);
                                                boolean exists = false;
                                                for (Entity entity : block.getChunk().getEntities()) {
                                                    if (!(entity instanceof EnderCrystal) || entity.getLocation().getBlockX() != location4.getBlockX() || entity.getLocation().getBlockY() != location4.getBlockY() || entity.getLocation().getBlockZ() != location4.getBlockZ()) continue;
                                                    exists = true;
                                                }
                                                if (!exists) {
                                                    Entity entity = block.getLocation().getWorld().spawnEntity(location4, EntityType.ENDER_CRYSTAL);
                                                    EnderCrystal enderCrystal = (EnderCrystal)entity;
                                                    enderCrystal.setShowingBottom(row_data != 0);
                                                    entity.teleport(location4);
                                                }
                                                break block124;
                                            }
                                            if (row_type.equals((Object)Material.AIR) && old_type_material.equals((Object)Material.END_CRYSTAL)) {
                                                Entity[] arr$ = block.getChunk().getEntities();
                                                int len$ = arr$.length;
                                                for (i$ = 0; i$ < len$; ++i$) {
                                                    Entity entity = arr$[i$];
                                                    if (!(entity instanceof EnderCrystal) || entity.getLocation().getBlockX() != row_x || entity.getLocation().getBlockY() != row_y || entity.getLocation().getBlockZ() != row_z) continue;
                                                    entity.remove();
                                                }
                                                break block124;
                                            }
                                            if (rollback_type == 0 && row_action == 0 && row_type.equals((Object)Material.AIR)) break block124;
                                            if (row_type.equals((Object)Material.AIR) || row_type.equals((Object)Material.TNT)) {
                                                if (clearInventories) {
                                                    if (BlockInfo.containers.contains(ctype)) {
                                                        Inventory inventory = Functions.getContainerInventory(block.getState(), false);
                                                        if (inventory != null) {
                                                            inventory.clear();
                                                        }
                                                    } else if (BlockInfo.containers.contains(Material.ARMOR_STAND) && old_type_material.equals((Object)Material.ARMOR_STAND)) {
                                                        Entity[] arr$ = block.getChunk().getEntities();
                                                        int len$ = arr$.length;
                                                        for (i$ = 0; i$ < len$; ++i$) {
                                                            Entity entity = arr$[i$];
                                                            if (!(entity instanceof ArmorStand) || entity.getLocation().getBlockX() != row_x || entity.getLocation().getBlockY() != row_y || entity.getLocation().getBlockZ() != row_z) continue;
                                                            EntityEquipment equipment = Functions.getEntityEquipment((LivingEntity)entity);
                                                            if (equipment != null) {
                                                                equipment.clear();
                                                            }
                                                            Location location5 = entity.getLocation();
                                                            location5.setY(location5.getY() - 1.0);
                                                            entity.teleport(location5);
                                                            entity.remove();
                                                        }
                                                    }
                                                }
                                                Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                                break block124;
                                            }
                                            if (row_type.equals((Object)Material.MOB_SPAWNER)) {
                                                try {
                                                    Functions.setTypeAndData(block, row_type, (byte)0, false);
                                                    CreatureSpawner mobSpawner = (CreatureSpawner)block.getState();
                                                    mobSpawner.setSpawnedType(Functions.getSpawnerType(row_data));
                                                    if (count_block) {
                                                        ++block_count;
                                                    }
                                                    break block124;
                                                }
                                                catch (Exception e) {}
                                                break block124;
                                            }
                                            if (row_type.equals((Object)Material.SKULL)) {
                                                block.setType(row_type, false);
                                                Lookup.queueSkullUpdate(row_user, block.getState(), row_data);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                            } else if (row_type.equals((Object)Material.SIGN_POST) || row_type.equals((Object)Material.WALL_SIGN)) {
                                                Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                Lookup.queueSignUpdate(row_user, block.getState(), rollback_type, row_time);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                            } else if (BlockInfo.shulker_boxes.contains(row_type)) {
                                                Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                                if (meta != null) {
                                                    Inventory inventory = Functions.getContainerInventory(block.getState(), false);
                                                    for (Object value : meta) {
                                                        if (!(value instanceof Map)) continue;
                                                        Map itemMap = (Map)value;
                                                        ItemStack item = ItemStack.deserialize((Map)((Map)itemMap.get(0)));
                                                        List metadata = (List)itemMap.get(1);
                                                        Object[] populatedStack = Lookup.populateItemStack(item, metadata);
                                                        item = (ItemStack)populatedStack[1];
                                                        Lookup.modifyContainerItems(item.getType(), inventory, 0, item, 1);
                                                    }
                                                }
                                            } else if (row_type.equals((Object)Material.COMMAND)) {
                                                Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                                if (meta != null) {
                                                    CommandBlock command_block = (CommandBlock)block.getState();
                                                    for (Object value : meta) {
                                                        if (!(value instanceof String)) continue;
                                                        String string2 = (String)value;
                                                        command_block.setCommand(string2);
                                                        command_block.update();
                                                    }
                                                }
                                            } else if (row_type.equals((Object)Material.WALL_BANNER) || row_type.equals((Object)Material.STANDING_BANNER)) {
                                                Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                                if (meta != null) {
                                                    Banner banner = (Banner)block.getState();
                                                    for (Object value : meta) {
                                                        if (value instanceof DyeColor) {
                                                            banner.setBaseColor((DyeColor)value);
                                                            continue;
                                                        }
                                                        if (!(value instanceof Map)) continue;
                                                        Pattern pattern = new Pattern((Map)value);
                                                        banner.addPattern(pattern);
                                                    }
                                                    banner.update();
                                                }
                                            } else if (update_state.contains(row_type)) {
                                                Functions.setTypeAndData(block, row_type, (byte)row_data, true);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                            } else if (row_type != ctype && BlockInfo.containers.contains(row_type) && BlockInfo.containers.contains(ctype)) {
                                                block.setType(Material.AIR);
                                                Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                            } else {
                                                if (BlockInfo.containers.contains(row_type)) {
                                                    block.setType(row_type);
                                                    Functions.setData(block, (byte)row_data);
                                                } else {
                                                    Functions.setTypeAndData(block, row_type, (byte)row_data, false);
                                                }
                                                if (count_block) {
                                                    ++block_count;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (!row_type.equals((Object)Material.AIR) && change_block && row_user.length() > 0) {
                                        Config.lookup_cache.put("" + row_x + "." + row_y + "." + row_z + "." + row_wid + "", new Object[]{unixtimestamp, row_user, row_type});
                                    }
                                }
                                Config.rollback_hash.put(string, new int[]{item_count, ++block_count, ++entity_count, 0});
                            }
                            hanging_delay.clear();
                            Inventory container = null;
                            Material container_type = null;
                            boolean container_init = false;
                            int last_x = 0;
                            int last_y = 0;
                            int last_z = 0;
                            int last_wid = 0;
                            for (Object[] row : item_data) {
                                int[] rollback_hash_data = Config.rollback_hash.get(string);
                                int item_count = rollback_hash_data[0];
                                int block_count = rollback_hash_data[1];
                                int entity_count = rollback_hash_data[2];
                                int row_x = (Integer)row[3];
                                int row_y = (Integer)row[4];
                                int row_z = (Integer)row[5];
                                int row_type_raw = (Integer)row[6];
                                int row_data = (Integer)row[7];
                                int row_action = (Integer)row[8];
                                int row_rolled_back = (Integer)row[9];
                                int row_wid = (Integer)row[10];
                                int row_amount = (Integer)row[11];
                                byte[] row_metadata = (byte[])row[12];
                                Material row_type = Functions.getType(row_type_raw);
                                if (rollback_type == 0 && row_rolled_back == 0 || rollback_type == 1 && row_rolled_back == 1) {
                                    if (!container_init || row_x != last_x || row_y != last_y || row_z != last_z || row_wid != last_wid) {
                                        container = null;
                                        String world = Functions.getWorldName(row_wid);
                                        block = CoreProtect.getInstance().getServer().getWorld(world).getBlockAt(row_x, row_y, row_z);
                                        if (!CoreProtect.getInstance().getServer().getWorld(world).isChunkLoaded(block.getChunk())) {
                                            CoreProtect.getInstance().getServer().getWorld(world).loadChunk(block.getChunk());
                                        }
                                        if (BlockInfo.containers.contains(block.getType())) {
                                            container = Functions.getContainerInventory(block.getState(), false);
                                            container_type = block.getType();
                                        } else if (BlockInfo.containers.contains(Material.ARMOR_STAND)) {
                                            for (Entity entity : block.getChunk().getEntities()) {
                                                if (!(entity instanceof ArmorStand) || entity.getLocation().getBlockX() != row_x || entity.getLocation().getBlockY() != row_y || entity.getLocation().getBlockZ() != row_z) continue;
                                                container = Functions.getEntityEquipment((LivingEntity)entity);
                                                container_type = Material.ARMOR_STAND;
                                            }
                                        }
                                        last_x = row_x;
                                        last_y = row_y;
                                        last_z = row_z;
                                        last_wid = row_wid;
                                    }
                                    if (container != null) {
                                        int action = 0;
                                        if (rollback_type == 0 && row_action == 0) {
                                            action = 1;
                                        }
                                        if (rollback_type == 1 && row_action == 1) {
                                            action = 1;
                                        }
                                        ItemStack itemstack = new ItemStack(row_type, row_amount, (short)row_data);
                                        Object[] populatedStack = Lookup.populateItemStack(itemstack, row_metadata);
                                        int slot = (Integer)populatedStack[0];
                                        itemstack = (ItemStack)populatedStack[1];
                                        Lookup.modifyContainerItems(container_type, container, slot, itemstack, action);
                                        item_count += row_amount;
                                    }
                                    container_init = true;
                                }
                                Config.rollback_hash.put(string, new int[]{item_count, block_count, entity_count, 0});
                            }
                            int[] rollback_hash_data = Config.rollback_hash.get(string);
                            int item_count = rollback_hash_data[0];
                            int block_count = rollback_hash_data[1];
                            int entity_count = rollback_hash_data[2];
                            Config.rollback_hash.put(string, new int[]{item_count, block_count, entity_count, 1});
                            if (final_user instanceof Player && preview == 0 && (chunk = (location = (player = (Player)final_user).getLocation()).getChunk()).getX() == final_chunk_x && chunk.getZ() == final_chunk_z) {
                                List<Integer> unsafe_blocks = Arrays.asList(10, 11, 51);
                                int player_x = location.getBlockX();
                                int player_y = location.getBlockY();
                                int player_z = location.getBlockZ();
                                int check_y = player_y - 1;
                                boolean safe_block = false;
                                boolean place_safe = false;
                                while (!safe_block) {
                                    int above = check_y + 1;
                                    if (above > 256) {
                                        above = 256;
                                    }
                                    Block block_type1 = location.getWorld().getBlockAt(player_x, check_y, player_z);
                                    Block block_type2 = location.getWorld().getBlockAt(player_x, above, player_z);
                                    Material type1 = block_type1.getType();
                                    Material type2 = block_type2.getType();
                                    if (BlockInfo.non_solid_entity_blocks.contains(type1) && BlockInfo.non_solid_entity_blocks.contains(type2)) {
                                        if (unsafe_blocks.contains(type1)) {
                                            place_safe = true;
                                        } else {
                                            safe_block = true;
                                            if (place_safe) {
                                                int below = check_y - 1;
                                                Block block_below = location.getWorld().getBlockAt(player_x, below, player_z);
                                                if (unsafe_blocks.contains(block_below.getType())) {
                                                    block_type1.setType(Material.DIRT);
                                                    ++check_y;
                                                }
                                            }
                                        }
                                    }
                                    if (check_y >= 256) {
                                        safe_block = true;
                                    }
                                    if (safe_block && check_y > player_y) {
                                        if (check_y > 256) {
                                            check_y = 256;
                                        }
                                        location.setY((double)check_y);
                                        player.teleport(location);
                                        player.sendMessage("\u00a73CoreProtect \u00a7f- Teleported you to safety.");
                                        if (place_safe) {
                                            player.sendMessage("\u00a73CoreProtect \u00a7f- Placed a dirt block under you.");
                                        }
                                    }
                                    ++check_y;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            int[] rollback_hash_data = Config.rollback_hash.get(string);
                            int item_count = rollback_hash_data[0];
                            int block_count = rollback_hash_data[1];
                            int entity_count = rollback_hash_data[2];
                            Config.rollback_hash.put(string, new int[]{item_count, block_count, entity_count, 2});
                        }
                    }
                }, 0L);
                rollback_hash_data = Config.rollback_hash.get(string);
                int next = rollback_hash_data[3];
                int sleep_time = 0;
                boolean abort = false;
                while (next == 0) {
                    if (preview == 1) {
                        ++sleep_time;
                        Thread.sleep(1L);
                    } else {
                        sleep_time += 5;
                        Thread.sleep(5L);
                    }
                    rollback_hash_data = Config.rollback_hash.get(string);
                    next = rollback_hash_data[3];
                    if (sleep_time <= 300000) continue;
                    abort = true;
                    break;
                }
                if (abort || next == 2) {
                    System.out.println("[CoreProtect] Rollback or restore aborted.");
                    break;
                }
                rollback_hash_data = Config.rollback_hash.get(string);
                item_count = rollback_hash_data[0];
                block_count = rollback_hash_data[1];
                entity_count = rollback_hash_data[2];
                Config.rollback_hash.put(string, new int[]{item_count, block_count, entity_count, 0});
                if (!verbose || user == null || preview != 0) continue;
                user.sendMessage("\u00a73CoreProtect \u00a7f- Modified " + file + "/" + chunk_list.size() + " chunk(s).");
            }
            int[] rollback_hash_data = Config.rollback_hash.get(string);
            int n = rollback_hash_data[0];
            int block_count = rollback_hash_data[1];
            int entity_count = rollback_hash_data[2];
            long time2 = System.currentTimeMillis();
            int seconds = (int)((time2 - time1) / 1000L);
            if (user != null) {
                Lookup.finishRollbackRestore(user, location, check_users, restrict_list, exclude_list, exclude_user_list, action_list, time_string, file, seconds, n, block_count, entity_count, rollback_type, radius, verbose, restrict_world, preview);
            }
            list = Lookup.convertRawLookup(statement, lookup_list);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean playerExists(Connection connection, String user) {
        try {
            int id = -1;
            String uuid = null;
            if (Config.player_id_cache.get(user.toLowerCase()) != null) {
                return true;
            }
            String query = "SELECT rowid as id, uuid FROM " + Config.prefix + "user WHERE user LIKE ? LIMIT 0, 1";
            PreparedStatement preparedStmt = connection.prepareStatement(query);
            preparedStmt.setString(1, user);
            ResultSet rs = preparedStmt.executeQuery();
            while (rs.next()) {
                id = rs.getInt("id");
                uuid = rs.getString("uuid");
            }
            rs.close();
            preparedStmt.close();
            if (id > -1) {
                if (uuid != null) {
                    Config.uuid_cache.put(user.toLowerCase(), uuid);
                    Config.uuid_cache_reversed.put(uuid, user);
                }
                Config.player_id_cache.put(user.toLowerCase(), id);
                Config.player_id_cache_reversed.put(id, user);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Object[] populateItemStack(ItemStack itemstack, List<List<Map<String, Object>>> list) {
        int slot = 0;
        try {
            Material row_type = itemstack.getType();
            int item_count = 0;
            FireworkEffect.Builder effect_builder = FireworkEffect.builder();
            for (List<Map<String, Object>> map : list) {
                Map<String, Object> mapData = map.get(0);
                if (mapData.get("slot") != null) {
                    slot = (Integer)mapData.get("slot");
                } else if (item_count == 0) {
                    ItemMeta meta = Functions.deserializeItemMeta(itemstack.getItemMeta().getClass(), map.get(0));
                    itemstack.setItemMeta(meta);
                } else if (row_type.equals((Object)Material.LEATHER_HELMET) || row_type.equals((Object)Material.LEATHER_CHESTPLATE) || row_type.equals((Object)Material.LEATHER_LEGGINGS) || row_type.equals((Object)Material.LEATHER_BOOTS)) {
                    for (Map<String, Object> l : map) {
                        LeatherArmorMeta meta = (LeatherArmorMeta)itemstack.getItemMeta();
                        Color color = Color.deserialize(l);
                        meta.setColor(color);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (row_type.equals((Object)Material.POTION)) {
                    for (Map<String, Object> l : map) {
                        PotionMeta meta = (PotionMeta)itemstack.getItemMeta();
                        PotionEffect effect = new PotionEffect(l);
                        meta.addCustomEffect(effect, true);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (row_type.equals((Object)Material.BANNER)) {
                    for (Map<String, Object> l : map) {
                        BannerMeta meta = (BannerMeta)itemstack.getItemMeta();
                        Pattern pattern = new Pattern(l);
                        meta.addPattern(pattern);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (row_type.equals((Object)Material.MAP)) {
                    for (Map<String, Object> l : map) {
                        MapMeta meta = (MapMeta)itemstack.getItemMeta();
                        Color color = Color.deserialize(l);
                        meta.setColor(color);
                        itemstack.setItemMeta((ItemMeta)meta);
                    }
                } else if (row_type.equals((Object)Material.FIREWORK) || row_type.equals((Object)Material.FIREWORK_CHARGE)) {
                    if (item_count == 1) {
                        for (Map<String, Object> l : map) {
                            boolean hasFlicker = (Boolean)l.get("flicker");
                            boolean hasTrail = (Boolean)l.get("trail");
                            effect_builder.flicker(hasFlicker);
                            effect_builder.trail(hasTrail);
                        }
                    } else if (item_count == 2) {
                        for (Map<String, Object> l : map) {
                            Color color = Color.deserialize(l);
                            effect_builder.withColor(color);
                        }
                    } else if (item_count == 3) {
                        FireworkMeta meta;
                        for (Map<String, Object> l : map) {
                            Color color = Color.deserialize(l);
                            effect_builder.withFade(color);
                        }
                        FireworkEffect effect = effect_builder.build();
                        if (row_type.equals((Object)Material.FIREWORK)) {
                            meta = (FireworkMeta)itemstack.getItemMeta();
                            meta.addEffect(effect);
                            itemstack.setItemMeta((ItemMeta)meta);
                        } else if (row_type.equals((Object)Material.FIREWORK_CHARGE)) {
                            meta = (FireworkEffectMeta)itemstack.getItemMeta();
                            meta.setEffect(effect);
                            itemstack.setItemMeta((ItemMeta)meta);
                        }
                        effect_builder = FireworkEffect.builder();
                        item_count = 0;
                    }
                }
                ++item_count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object[]{slot, itemstack};
    }

    private static Object[] populateItemStack(ItemStack itemstack, byte[] metadata) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(metadata);
            ObjectInputStream ins = new ObjectInputStream(bais);
            List list = (List)ins.readObject();
            return Lookup.populateItemStack(itemstack, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Object[]{0, itemstack};
        }
    }

    private static ResultSet rawLookupResultSet(Statement statement, CommandSender user, List<String> check_uuids, List<String> check_users, List<Object> restrict_list, List<Object> exclude_list, List<String> exclude_user_list, List<Integer> action_list, Location location, Integer[] radius, int check_time, int limit_offset, int limit_count, boolean restrict_world, boolean lookup, boolean count) {
        ResultSet rs = null;
        try {
            String list;
            List<Integer> valid_actions = Arrays.asList(0, 1, 2, 3);
            if (radius != null) {
                restrict_world = true;
            }
            boolean valid_action = false;
            String query_extra = "";
            String query_limit = "";
            String query_table = "block";
            String action = "";
            String exclude = "";
            String restrict = "";
            String users = "";
            String uuids = "";
            String exclude_users = "";
            String index = "";
            if (check_uuids.size() > 0) {
                list = "";
                for (String string : check_uuids) {
                    if (list.length() == 0) {
                        list = "'" + string + "'";
                        continue;
                    }
                    list = list + ",'" + string + "'";
                }
                uuids = list;
            }
            if (!check_users.contains("#global")) {
                list = "";
                for (String string : check_users) {
                    if (string.equals("#container")) continue;
                    if (Config.player_id_cache.get(string.toLowerCase()) == null) {
                        Database.loadUserID(statement.getConnection(), string, null);
                    }
                    int userid = Config.player_id_cache.get(string.toLowerCase());
                    if (list.length() == 0) {
                        list = "" + userid + "";
                        continue;
                    }
                    list = list + "," + userid;
                }
                users = list;
            }
            if (restrict_list.size() > 0) {
                list = "";
                for (Object object : restrict_list) {
                    String value_name = "";
                    if (object instanceof Material) {
                        value_name = ((Material)object).name();
                        if (list.length() == 0) {
                            list = "" + Functions.block_id(value_name, false) + "";
                            continue;
                        }
                        list = list + "," + Functions.block_id(value_name, false);
                        continue;
                    }
                    if (!(object instanceof EntityType)) continue;
                    value_name = ((EntityType)object).name();
                    if (list.length() == 0) {
                        list = "" + Functions.getEntityId(value_name, false) + "";
                        continue;
                    }
                    list = list + "," + Functions.getEntityId(value_name, false);
                }
                restrict = list;
            }
            if (exclude_list.size() > 0) {
                list = "";
                for (Object object : exclude_list) {
                    String value_name = "";
                    if (object instanceof Material) {
                        value_name = ((Material)object).name();
                        if (list.length() == 0) {
                            list = "" + Functions.block_id(value_name, false) + "";
                            continue;
                        }
                        list = list + "," + Functions.block_id(value_name, false);
                        continue;
                    }
                    if (!(object instanceof EntityType)) continue;
                    value_name = ((EntityType)object).name();
                    if (list.length() == 0) {
                        list = "" + Functions.getEntityId(value_name, false) + "";
                        continue;
                    }
                    list = list + "," + Functions.getEntityId(value_name, false);
                }
                exclude = list;
            }
            if (exclude_user_list.size() > 0) {
                list = "";
                for (String string : exclude_user_list) {
                    if (Config.player_id_cache.get(string.toLowerCase()) == null) {
                        Database.loadUserID(statement.getConnection(), string, null);
                    }
                    int userid = Config.player_id_cache.get(string.toLowerCase());
                    if (list.length() == 0) {
                        list = "" + userid + "";
                        continue;
                    }
                    list = list + "," + userid;
                }
                exclude_users = list;
            }
            if (action_list.size() > 0) {
                list = "";
                for (Integer n : action_list) {
                    if (!valid_actions.contains(n)) continue;
                    if (list.length() == 0) {
                        list = "" + n + "";
                        continue;
                    }
                    list = list + "," + n;
                }
                action = list;
            }
            for (Integer value : action_list) {
                if (!valid_actions.contains(value)) continue;
                valid_action = true;
            }
            if (restrict_world) {
                int wid = Functions.getWorldId(location.getWorld().getName());
                query_extra = query_extra + " wid=" + wid + " AND";
            }
            if (radius != null) {
                int xmin = radius[1];
                int xmax = radius[2];
                int n = radius[3];
                int ymax = radius[4];
                int zmin = radius[5];
                int zmax = radius[6];
                String query_y = "";
                if (n > -1 && ymax > -1) {
                    query_y = " y >= '" + n + "' AND y <= '" + ymax + "' AND";
                }
                query_extra = query_extra + " x >= '" + xmin + "' AND x <= '" + xmax + "' AND z >= '" + zmin + "' AND z <= '" + zmax + "' AND" + query_y;
            } else if (action_list.contains(5)) {
                int wid = Functions.getWorldId(location.getWorld().getName());
                int x = (int)Math.floor(location.getX());
                int n = (int)Math.floor(location.getZ());
                int x2 = (int)Math.ceil(location.getX());
                int z2 = (int)Math.ceil(location.getZ());
                query_extra = query_extra + " wid=" + wid + " AND (x = '" + x + "' OR x = '" + x2 + "') AND (z = '" + n + "' OR z = '" + z2 + "') AND y = '" + location.getBlockY() + "' AND";
            }
            if (valid_action) {
                query_extra = query_extra + " action IN(" + action + ") AND";
            }
            if (restrict.length() > 0) {
                query_extra = query_extra + " type IN(" + restrict + ") AND";
            }
            if (exclude.length() > 0) {
                query_extra = query_extra + " type NOT IN(" + exclude + ") AND";
            }
            if (uuids.length() > 0) {
                query_extra = query_extra + " uuid IN(" + uuids + ") AND";
            }
            if (users.length() > 0) {
                query_extra = query_extra + " user IN(" + users + ") AND";
            }
            if (exclude_users.length() > 0) {
                query_extra = query_extra + " user NOT IN(" + exclude_users + ") AND";
            }
            if (check_time > 0) {
                query_extra = query_extra + " time > '" + check_time + "' AND";
            }
            if (query_extra.length() > 0) {
                query_extra = query_extra.substring(0, query_extra.length() - 4);
            }
            if (query_extra.length() == 0) {
                query_extra = " 1";
            }
            if (limit_offset > -1 && limit_count > -1) {
                query_limit = " LIMIT " + limit_offset + ", " + limit_count + "";
            }
            String rows = "rowid as id,time,user,wid,x,y,z,action,type,data,meta,rolled_back";
            String query_order = " ORDER BY rowid DESC";
            if (lookup) {
                query_order = " ORDER BY time DESC";
            }
            if (action_list.contains(4) || action_list.contains(5)) {
                query_table = "container";
                rows = "rowid as id,time,user,wid,x,y,z,action,type,data,rolled_back,amount,metadata";
            } else if (action_list.contains(6) || action_list.contains(7)) {
                query_table = "chat";
                rows = "rowid as id,time,user,message";
                if (action_list.contains(7)) {
                    query_table = "command";
                }
            } else if (action_list.contains(8)) {
                query_table = "session";
                rows = "rowid as id,time,user,wid,x,y,z,action";
            } else if (action_list.contains(9)) {
                query_table = "username_log";
                rows = "rowid as id,time,uuid,user";
            }
            if (count) {
                rows = "COUNT(*) as count";
                query_limit = " LIMIT 0, 1";
                query_order = "";
            }
            if (Config.config.get("use-mysql") == 1) {
                if ((radius == null || users.length() > 0 || restrict.length() > 0) && users.length() > 0) {
                    // empty if block
                }
            } else if (query_table.equals("block")) {
                if (restrict.length() > 0 || exclude.length() > 0) {
                    index = "INDEXED BY block_type_index ";
                }
                if (users.length() > 0 || exclude_users.length() > 0) {
                    index = "INDEXED BY block_user_index ";
                }
                if (radius != null || action_list.contains(5) || index.equals("") && restrict_world) {
                    index = "INDEXED BY block_index ";
                }
            }
            String string = "SELECT " + rows + " FROM " + Config.prefix + query_table + " " + index + "WHERE" + query_extra + query_order + query_limit + "";
            rs = statement.executeQuery(string);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static String who_placed(Statement statement, BlockState block) {
        String result = "";
        try {
            if (block == null) {
                return result;
            }
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int time = (int)(System.currentTimeMillis() / 1000L);
            int wid = Functions.getWorldId(block.getWorld().getName());
            String query = "SELECT user,type FROM " + Config.prefix + "block WHERE wid = '" + wid + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND rolled_back = '0' AND action='1' ORDER BY rowid DESC LIMIT 0, 1";
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                int result_userid = rs.getInt("user");
                int result_type = rs.getInt("type");
                if (Config.player_id_cache_reversed.get(result_userid) == null) {
                    Database.loadUserName(statement.getConnection(), result_userid);
                }
                if ((result = Config.player_id_cache_reversed.get(result_userid)).length() <= 0) continue;
                Material result_material = Functions.getType(result_type);
                Config.lookup_cache.put("" + x + "." + y + "." + z + "." + wid + "", new Object[]{time, result, result_material});
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String who_placed_cache(Block block) {
        String result = "";
        try {
            if (block == null) {
                return result;
            }
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int wid = Functions.getWorldId(block.getWorld().getName());
            String cords = "" + x + "." + y + "." + z + "." + wid + "";
            Object[] data = Config.lookup_cache.get(cords);
            if (data != null) {
                result = (String)data[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String who_removed_cache(BlockState block) {
        String result = "";
        try {
            if (block != null) {
                int x = block.getX();
                int y = block.getY();
                int z = block.getZ();
                int wid = Functions.getWorldId(block.getWorld().getName());
                String cords = "" + x + "." + y + "." + z + "." + wid + "";
                Object[] data = Config.break_cache.get(cords);
                if (data != null) {
                    result = (String)data[1];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

