/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.command.ApplyCommand;
import net.coreprotect.command.CancelCommand;
import net.coreprotect.command.HelpCommand;
import net.coreprotect.command.InspectCommand;
import net.coreprotect.command.LookupCommand;
import net.coreprotect.command.PurgeCommand;
import net.coreprotect.command.ReloadCommand;
import net.coreprotect.command.RollbackRestoreCommand;
import net.coreprotect.command.UndoCommand;
import net.coreprotect.command.VersionCommand;
import net.coreprotect.model.BlockInfo;
import net.coreprotect.model.Config;
import net.coreprotect.worldedit.WorldEdit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private static CommandHandler instance;
    protected static List<Material> natural_blocks;

    public static CommandHandler getInstance() {
        if (instance == null) {
            instance = new CommandHandler();
        }
        return instance;
    }

    protected static List<Integer> parseAction(String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<Integer> result = new ArrayList<Integer>();
        int count = 0;
        boolean next = false;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("a:") || i.equals("action:")) {
                    next = true;
                } else if (next || i.startsWith("a:") || i.startsWith("action:")) {
                    result.clear();
                    i = i.replaceAll("action:", "");
                    i = i.replaceAll("a:", "");
                    if (i.startsWith("#")) {
                        i = i.replaceFirst("#", "");
                    }
                    if (i.equals("broke") || i.equals("break") || i.equals("remove") || i.equals("destroy") || i.equals("block-break") || i.equals("block-remove") || i.equals("-block") || i.equals("block-")) {
                        result.add(0);
                    } else if (i.equals("placed") || i.equals("place") || i.equals("block-place") || i.equals("+block") || i.equals("block+")) {
                        result.add(1);
                    } else if (i.equals("block") || i.equals("block-change") || i.equals("change")) {
                        result.add(0);
                        result.add(1);
                    } else if (i.equals("click") || i.equals("clicks") || i.equals("interact") || i.equals("interaction") || i.equals("player-interact") || i.equals("player-interaction") || i.equals("player-click")) {
                        result.add(2);
                    } else if (i.equals("death") || i.equals("deaths") || i.equals("entity-death") || i.equals("entity-deaths") || i.equals("kill") || i.equals("kills") || i.equals("entity-kill") || i.equals("entity-kills")) {
                        result.add(3);
                    } else if (i.equals("container") || i.equals("container-change") || i.equals("containers") || i.equals("chest") || i.equals("transaction") || i.equals("transactions")) {
                        result.add(4);
                    } else if (i.equals("-container") || i.equals("container-") || i.equals("remove-container")) {
                        result.add(4);
                        result.add(0);
                    } else if (i.equals("+container") || i.equals("container+") || i.equals("container-add") || i.equals("add-container")) {
                        result.add(4);
                        result.add(1);
                    } else if (i.equals("chat")) {
                        result.add(6);
                    } else if (i.equals("command") || i.equals("commands")) {
                        result.add(7);
                    } else if (i.equals("login") || i.equals("+session") || i.equals("session+") || i.equals("+connection") || i.equals("connection+")) {
                        result.add(8);
                        result.add(1);
                    } else if (i.equals("logout") || i.equals("-session") || i.equals("session-") || i.equals("-connection") || i.equals("connection-")) {
                        result.add(8);
                        result.add(0);
                    } else if (i.equals("session") || i.equals("sessions") || i.equals("connection") || i.equals("connections")) {
                        result.add(8);
                    } else if (i.equals("username") || i.equals("usernames") || i.equals("user") || i.equals("users") || i.equals("name") || i.equals("names") || i.equals("uuid") || i.equals("uuids") || i.equals("username-change") || i.equals("username-changes") || i.equals("name-change") || i.equals("name-changes")) {
                        result.add(9);
                    } else {
                        result.add(-1);
                    }
                    next = false;
                } else {
                    next = false;
                }
            }
            ++count;
        }
        return result;
    }

    protected static Location parseCoordinates(Location location, String[] args_input) {
        String[] args = (String[])args_input.clone();
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("c:") || i.equals("coord:") || i.equals("coords:") || i.equals("cord:") || i.equals("cords:") || i.equals("coordinate:") || i.equals("coordinates:") || i.equals("cordinate:") || i.equals("cordinates:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("c:") || i.startsWith("coord:") || i.startsWith("coords:") || i.startsWith("cord:") || i.startsWith("cords:") || i.startsWith("coordinate:") || i.startsWith("coordinates:") || i.startsWith("cordinate:") || i.startsWith("cordinates:")) {
                    i = i.replaceAll("coordinates:", "");
                    i = i.replaceAll("coordinate:", "");
                    i = i.replaceAll("cordinates:", "");
                    i = i.replaceAll("cordinate:", "");
                    i = i.replaceAll("coords:", "");
                    i = i.replaceAll("coord:", "");
                    i = i.replaceAll("cords:", "");
                    i = i.replaceAll("cord:", "");
                    if ((i = i.replaceAll("c:", "")).contains(",")) {
                        String[] i2 = i.split(",");
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        int c_count = 0;
                        for (String coord : i2) {
                            if ((coord = coord.replaceAll("[^0-9.\\-]", "")).length() <= 0 || coord.equals(".") || coord.equals("-")) continue;
                            double parsedCoord = Double.parseDouble(coord);
                            if (c_count == 0) {
                                x = parsedCoord;
                            } else if (c_count == 1) {
                                z = parsedCoord;
                            } else if (c_count == 2) {
                                y = z;
                                z = parsedCoord;
                            }
                            ++c_count;
                        }
                        if (y < 0.0) {
                            y = 0.0;
                        }
                        if (y > 255.0) {
                            y = 255.0;
                        }
                        if (c_count > 1) {
                            location.setX(x);
                            location.setY(y);
                            location.setZ(z);
                        }
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return location;
    }

    protected static boolean parseCount(String[] args_input) {
        String[] args = (String[])args_input.clone();
        boolean result = false;
        int count = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("#count") || i.equals("#sum")) {
                    result = true;
                }
            }
            ++count;
        }
        return result;
    }

    protected static List<Object> parseExcluded(CommandSender player, String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<Object> excluded = new ArrayList<Object>();
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("e:") || i.equals("exclude:")) {
                    next = 5;
                } else if (next == 5 || i.startsWith("e:") || i.startsWith("exclude:")) {
                    i = i.replaceAll("exclude:", "");
                    if ((i = i.replaceAll("e:", "")).contains(",")) {
                        String[] i2;
                        for (String i3 : i2 = i.split(",")) {
                            if (i3.equals("#natural")) {
                                excluded.addAll(natural_blocks);
                                continue;
                            }
                            Material i3_material = Functions.getType(i3);
                            if (i3_material != null) {
                                excluded.add(i3_material);
                                continue;
                            }
                            EntityType i3_entity = Functions.getEntityType(i3);
                            if (i3_entity == null) continue;
                            excluded.add(i3_entity);
                        }
                        next = i.endsWith(",") ? 5 : 0;
                    } else {
                        if (i.equals("#natural")) {
                            excluded.addAll(natural_blocks);
                        } else {
                            Material i_material = Functions.getType(i);
                            if (i_material != null) {
                                excluded.add(i_material);
                            } else {
                                EntityType i_entity = Functions.getEntityType(i);
                                if (i_entity != null) {
                                    excluded.add(i_entity);
                                }
                            }
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return excluded;
    }

    protected static List<String> parseExcludedUsers(CommandSender player, String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<String> excluded = new ArrayList<String>();
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("e:") || i.equals("exclude:")) {
                    next = 5;
                } else if (next == 5 || i.startsWith("e:") || i.startsWith("exclude:")) {
                    i = i.replaceAll("exclude:", "");
                    if ((i = i.replaceAll("e:", "")).contains(",")) {
                        String[] i2;
                        for (String i3 : i2 = i.split(",")) {
                            boolean isBlock = false;
                            if (i3.equals("#natural")) {
                                isBlock = true;
                            } else {
                                Material i3_material = Functions.getType(i3);
                                if (i3_material != null) {
                                    isBlock = true;
                                } else {
                                    EntityType i3_entity = Functions.getEntityType(i3);
                                    if (i3_entity != null) {
                                        isBlock = true;
                                    }
                                }
                            }
                            if (isBlock) continue;
                            excluded.add(i3);
                        }
                        next = i.endsWith(",") ? 5 : 0;
                    } else {
                        boolean isBlock = false;
                        if (i.equals("#natural")) {
                            isBlock = true;
                        } else {
                            Material i_material = Functions.getType(i);
                            if (i_material != null) {
                                isBlock = true;
                            } else {
                                EntityType i_entity = Functions.getEntityType(i);
                                if (i_entity != null) {
                                    isBlock = true;
                                }
                            }
                        }
                        if (!isBlock) {
                            excluded.add(i);
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return excluded;
    }

    protected static boolean parseForceGlobal(String[] args_input) {
        String[] args = (String[])args_input.clone();
        boolean result = false;
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    int world_id;
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#global") || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false")) {
                        result = true;
                    } else if (i.startsWith("#") && (world_id = Functions.matchWorld(i)) > 0) {
                        result = true;
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return result;
    }

    protected static Location parseLocation(CommandSender user, String[] args) {
        Location location = null;
        if (user instanceof Player) {
            location = ((Player)user).getLocation();
        } else if (user instanceof BlockCommandSender) {
            location = ((BlockCommandSender)user).getBlock().getLocation();
        }
        if (location != null) {
            location = CommandHandler.parseCoordinates(location, args);
        }
        return location;
    }

    protected static int parseNoisy(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int noisy = 0;
        int count = 0;
        if (Config.config.get("verbose") == 1) {
            noisy = 1;
        }
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("n") || i.equals("noisy") || i.equals("v") || i.equals("verbose") || i.equals("#v") || i.equals("#verbose")) {
                    noisy = 1;
                } else if (i.equals("#silent")) {
                    noisy = 0;
                }
            }
            ++count;
        }
        return noisy;
    }

    protected static int parsePreview(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int result = 0;
        int count = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("#preview")) {
                    result = 1;
                } else if (i.equals("#preview_cancel")) {
                    result = 2;
                }
            }
            ++count;
        }
        return result;
    }

    protected static Integer[] parseRadius(String[] args_input, CommandSender user, Location location) {
        String[] args = (String[])args_input.clone();
        Integer[] radius = null;
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we")) {
                        WorldEditPlugin wep = WorldEdit.getWorldEdit(user.getServer());
                        if (wep != null && user instanceof Player) {
                            try {
                                Region region;
                                LocalSession ls = wep.getSession((Player)user);
                                World lw = ls.getSelectionWorld();
                                if (lw != null && (region = ls.getSelection(lw)) != null && lw.getName().equals(((Player)user).getWorld().getName())) {
                                    Vector v1 = region.getMinimumPoint();
                                    int x1 = v1.getBlockX();
                                    int y1 = v1.getBlockY();
                                    int z1 = v1.getBlockZ();
                                    int w = region.getWidth();
                                    int h = region.getHeight();
                                    int l = region.getLength();
                                    int max = w;
                                    if (h > max) {
                                        max = h;
                                    }
                                    if (l > max) {
                                        max = l;
                                    }
                                    int xmin = x1;
                                    int xmax = x1 + (w - 1);
                                    int ymin = y1;
                                    int ymax = y1 + (h - 1);
                                    int zmin = z1;
                                    int zmax = z1 + (l - 1);
                                    radius = new Integer[]{max, xmin, xmax, ymin, ymax, zmin, zmax, 1};
                                }
                            }
                            catch (Exception e) {}
                        }
                    } else if (!(i.startsWith("#") && i.length() > 1 || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false"))) {
                        int rcount = 0;
                        int r_x = 0;
                        int r_y = -1;
                        int r_z = 0;
                        String[] r_dat = new String[]{i};
                        boolean validRadius = false;
                        if (i.contains("x")) {
                            r_dat = i.split("x");
                        }
                        for (String value : r_dat) {
                            String i4 = value.replaceAll("[^0-9.]", "");
                            if (i4.length() > 0 && i4.length() == value.length() && i4.replaceAll("[^0-9]", "").length() > 0) {
                                double a1 = Double.parseDouble(i4);
                                if (rcount == 0) {
                                    r_x = (int)a1;
                                    r_z = (int)a1;
                                } else if (rcount == 1) {
                                    r_y = (int)a1;
                                } else if (rcount == 2) {
                                    r_z = (int)a1;
                                }
                                validRadius = true;
                            }
                            ++rcount;
                        }
                        if (location != null) {
                            int max;
                            int xmin = location.getBlockX() - r_x;
                            int xmax = location.getBlockX() + r_x;
                            int ymin = -1;
                            int ymax = -1;
                            int zmin = location.getBlockZ() - r_z;
                            int zmax = location.getBlockZ() + r_z;
                            if (r_y > -1) {
                                ymin = location.getBlockY() - r_y;
                                ymax = location.getBlockY() + r_y;
                            }
                            if (r_y > (max = r_x)) {
                                max = r_y;
                            }
                            if (r_z > max) {
                                max = r_z;
                            }
                            radius = validRadius ? new Integer[]{max, xmin, xmax, ymin, ymax, zmin, zmax, 0} : new Integer[]{-1};
                        }
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return radius;
    }

    protected static List<Object> parseRestricted(CommandSender player, String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<Object> restricted = new ArrayList<Object>();
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("b:") || i.equals("block:") || i.equals("blocks:")) {
                    next = 4;
                } else if (next == 4 || i.startsWith("b:") || i.startsWith("block:") || i.startsWith("blocks:")) {
                    i = i.replaceAll("blocks:", "");
                    i = i.replaceAll("block:", "");
                    if ((i = i.replaceAll("b:", "")).contains(",")) {
                        String[] i2;
                        for (String i3 : i2 = i.split(",")) {
                            if (i3.equals("#natural")) {
                                restricted.addAll(natural_blocks);
                                continue;
                            }
                            Material i3_material = Functions.getType(i3);
                            if (i3_material != null) {
                                restricted.add(i3_material);
                                continue;
                            }
                            EntityType i3_entity = Functions.getEntityType(i3);
                            if (i3_entity != null) {
                                restricted.add(i3_entity);
                                continue;
                            }
                            player.sendMessage("\u00a73CoreProtect \u00a7f- Sorry, \"" + i3 + "\" is an invalid block name.");
                            player.sendMessage("\u00a73CoreProtect \u00a7f- Please view \"/co help blocks\".");
                            return null;
                        }
                        next = i.endsWith(",") ? 4 : 0;
                    } else {
                        if (i.equals("#natural")) {
                            restricted.addAll(natural_blocks);
                        } else {
                            Material i_material = Functions.getType(i);
                            if (i_material != null) {
                                restricted.add(i_material);
                            } else {
                                EntityType i_entity = Functions.getEntityType(i);
                                if (i_entity != null) {
                                    restricted.add(i_entity);
                                } else {
                                    player.sendMessage("\u00a73CoreProtect \u00a7f- Sorry, \"" + i + "\" is an invalid block name.");
                                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please view \"/co help blocks\".");
                                    return null;
                                }
                            }
                        }
                        next = 0;
                    }
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return restricted;
    }

    protected static int parseTime(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int time = 0;
        int count = 0;
        boolean next = false;
        double w = 0.0;
        double d = 0.0;
        double h = 0.0;
        double m = 0.0;
        double s = 0.0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("t:") || i.equals("time:")) {
                    next = true;
                } else if (next || i.startsWith("t:") || i.startsWith("time:")) {
                    String[] i2;
                    i = i.replaceAll("time:", "");
                    i = i.replaceAll("t:", "");
                    i = i.replaceAll("y", "y:");
                    i = i.replaceAll("m", "m:");
                    i = i.replaceAll("w", "w:");
                    i = i.replaceAll("d", "d:");
                    i = i.replaceAll("h", "h:");
                    i = i.replaceAll("s", "s:");
                    for (String i3 : i2 = i.split(":")) {
                        String i4;
                        if (i3.endsWith("w")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            w = Double.parseDouble(i4);
                            continue;
                        }
                        if (i3.endsWith("d")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            d = Double.parseDouble(i4);
                            continue;
                        }
                        if (i3.endsWith("h")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            h = Double.parseDouble(i4);
                            continue;
                        }
                        if (i3.endsWith("m")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            m = Double.parseDouble(i4);
                            continue;
                        }
                        if (!i3.endsWith("s") || (i4 = i3.replaceAll("[^0-9.]", "")).length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                        s = Double.parseDouble(i4);
                    }
                    double rs = w * 7.0 * 24.0 * 60.0 * 60.0 + d * 24.0 * 60.0 * 60.0 + h * 60.0 * 60.0 + m * 60.0 + s;
                    time = (int)rs;
                    next = false;
                } else {
                    next = false;
                }
            }
            ++count;
        }
        return time;
    }

    protected static String parseTimeString(String[] args_input) {
        String[] args = (String[])args_input.clone();
        String time = "";
        int count = 0;
        boolean next = false;
        double w = 0.0;
        double d = 0.0;
        double h = 0.0;
        double m = 0.0;
        double s = 0.0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("t:") || i.equals("time:")) {
                    next = true;
                } else if (next || i.startsWith("t:") || i.startsWith("time:")) {
                    String[] i2;
                    i = i.replaceAll("time:", "");
                    i = i.replaceAll("t:", "");
                    i = i.replaceAll("y", "y:");
                    i = i.replaceAll("m", "m:");
                    i = i.replaceAll("w", "w:");
                    i = i.replaceAll("d", "d:");
                    i = i.replaceAll("h", "h:");
                    i = i.replaceAll("s", "s:");
                    for (String i3 : i2 = i.split(":")) {
                        String i4;
                        if (i3.endsWith("w")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            w = Double.parseDouble(i4);
                            time = time + " " + w + " week(s)";
                            continue;
                        }
                        if (i3.endsWith("d")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            d = Double.parseDouble(i4);
                            time = time + " " + d + " day(s)";
                            continue;
                        }
                        if (i3.endsWith("h")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            h = Double.parseDouble(i4);
                            time = time + " " + h + " hour(s)";
                            continue;
                        }
                        if (i3.endsWith("m")) {
                            i4 = i3.replaceAll("[^0-9.]", "");
                            if (i4.length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                            m = Double.parseDouble(i4);
                            time = time + " " + m + " minute(s)";
                            continue;
                        }
                        if (!i3.endsWith("s") || (i4 = i3.replaceAll("[^0-9.]", "")).length() <= 0 || i4.replaceAll("[^0-9]", "").length() <= 0) continue;
                        s = Double.parseDouble(i4);
                        time = time + " " + s + " second(s)";
                    }
                    next = false;
                } else {
                    next = false;
                }
            }
            ++count;
        }
        return time;
    }

    private static void parseUser(List<String> users, String string) {
        if ((string = string.trim()).contains(",")) {
            String[] data;
            for (String user : data = string.split(",")) {
                CommandHandler.validUserCheck(users, user);
            }
        } else {
            CommandHandler.validUserCheck(users, string);
        }
    }

    protected static List<String> parseUsers(String[] args_input) {
        String[] args = (String[])args_input.clone();
        ArrayList<String> users = new ArrayList<String>();
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                i = i.replaceAll("'", "");
                if (next == 2) {
                    next = i.endsWith(",") ? 2 : 0;
                } else if (i.equals("p:") || i.equals("user:") || i.equals("u:")) {
                    next = 1;
                } else if (next == 1 || i.startsWith("p:") || i.startsWith("user:") || i.startsWith("u:")) {
                    i = i.replaceAll("user:", "");
                    i = i.replaceAll("p:", "");
                    if ((i = i.replaceAll("u:", "")).contains(",")) {
                        String[] i2;
                        for (String i3 : i2 = i.split(",")) {
                            CommandHandler.parseUser(users, i3);
                        }
                        next = i.endsWith(",") ? 1 : 0;
                    } else {
                        CommandHandler.parseUser(users, i);
                        next = 0;
                    }
                } else if (i.endsWith(",") || i.endsWith(":")) {
                    next = 2;
                } else if (i.contains(":")) {
                    next = 0;
                } else {
                    CommandHandler.parseUser(users, i);
                    next = 0;
                }
            }
            ++count;
        }
        return users;
    }

    protected static int parseWorld(String[] args_input) {
        String[] args = (String[])args_input.clone();
        int world_id = 0;
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we") || i.equals("#global") || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false")) {
                        world_id = 0;
                    } else if (i.startsWith("#")) {
                        world_id = Functions.matchWorld(i);
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return world_id;
    }

    protected static boolean parseWorldEdit(String[] args_input) {
        String[] args = (String[])args_input.clone();
        boolean result = false;
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we")) {
                        result = true;
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return result;
    }

    protected static String parseWorldName(String[] args_input) {
        String[] args = (String[])args_input.clone();
        String world_name = "";
        int count = 0;
        int next = 0;
        for (String i : args) {
            if (count > 0) {
                i = i.trim().toLowerCase();
                i = i.replaceAll("\\\\", "");
                if ((i = i.replaceAll("'", "")).equals("r:") || i.equals("radius:")) {
                    next = 2;
                } else if (next == 2 || i.startsWith("r:") || i.startsWith("radius:")) {
                    i = i.replaceAll("radius:", "");
                    if ((i = i.replaceAll("r:", "")).equals("#worldedit") || i.equals("#we") || i.equals("#global") || i.equals("global") || i.equals("off") || i.equals("-1") || i.equals("none") || i.equals("false")) {
                        world_name = "";
                    } else if (i.startsWith("#")) {
                        world_name = i.replaceFirst("#", "");
                    }
                    next = 0;
                } else {
                    next = 0;
                }
            }
            ++count;
        }
        return world_name;
    }

    private static void validUserCheck(List<String> users, String user) {
        List<String> bad_users = Arrays.asList("n", "noisy", "v", "verbose", "#v", "#verbose", "#silent", "#preview", "#preview_cancel", "#count", "#sum");
        String check = user.replaceAll("[^a-zA-Z0-9#_]", "");
        if (check.equals(user) && check.length() > 0) {
            if (user.equalsIgnoreCase("#global")) {
                user = "#global";
            }
            if (!bad_users.contains(user.toLowerCase())) {
                users.add(user);
            }
        }
    }

    public boolean onCommand(CommandSender user, Command command, String commandLabel, String[] args) {
        String commandName = command.getName().toLowerCase();
        if (commandName.equals("core") || commandName.equals("coreprotect") || commandName.equals("co")) {
            int resultc = args.length;
            if (resultc > -1) {
                String corecommand = "help";
                if (resultc > 0) {
                    corecommand = args[0].toLowerCase();
                }
                boolean permission = false;
                if (user.isOp()) {
                    permission = true;
                }
                if (!permission) {
                    if (user.hasPermission("coreprotect.rollback") && (corecommand.equals("rollback") || corecommand.equals("rb") || corecommand.equals("ro") || corecommand.equals("apply") || corecommand.equals("cancel"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.restore") && (corecommand.equals("restore") || corecommand.equals("rs") || corecommand.equals("re") || corecommand.equals("undo") || corecommand.equals("apply") || corecommand.equals("cancel"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.inspect") && (corecommand.equals("i") || corecommand.equals("inspect"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.help") && corecommand.equals("help")) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.purge") && corecommand.equals("purge")) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.lookup") && (corecommand.equals("l") || corecommand.equals("lookup") || corecommand.equals("near"))) {
                        permission = true;
                    } else if (user.hasPermission("coreprotect.reload") && corecommand.equals("reload")) {
                        permission = true;
                    }
                }
                if (corecommand.equals("rollback") || corecommand.equals("restore") || corecommand.equals("rb") || corecommand.equals("rs") || corecommand.equals("ro") || corecommand.equals("re")) {
                    RollbackRestoreCommand.runCommand(user, permission, args, 0);
                } else if (corecommand.equals("apply")) {
                    ApplyCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("cancel")) {
                    CancelCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("undo")) {
                    UndoCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("help")) {
                    HelpCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("purge")) {
                    PurgeCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("inspect") || corecommand.equals("i")) {
                    InspectCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("lookup") || corecommand.equals("l")) {
                    LookupCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("near")) {
                    LookupCommand.runCommand(user, permission, new String[]{"l", "r:5x5"});
                } else if (corecommand.equals("version")) {
                    VersionCommand.runCommand(user, permission, args);
                } else if (corecommand.equals("reload")) {
                    ReloadCommand.runCommand(user, permission, args);
                } else {
                    user.sendMessage("\u00a73CoreProtect \u00a7f- Command \"\u00a73/co " + corecommand + "\u00a7f\" not found.");
                }
            } else {
                user.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"\u00a73/co <parameters>\u00a7f\".");
            }
            return true;
        }
        return false;
    }

    static {
        natural_blocks = BlockInfo.natural_blocks;
    }
}

