/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect;

import java.io.File;
import net.coreprotect.CoreProtectAPI;
import net.coreprotect.Functions;
import net.coreprotect.Metrics;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.consumer.Process;
import net.coreprotect.listener.BlockListener;
import net.coreprotect.listener.EntityListener;
import net.coreprotect.listener.HangingListener;
import net.coreprotect.listener.PlayerListener;
import net.coreprotect.listener.WorldListener;
import net.coreprotect.model.Config;
import net.coreprotect.thread.CacheCleanUp;
import net.coreprotect.thread.CheckUpdate;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class CoreProtect
extends JavaPlugin {
    protected static CoreProtect instance;
    private CoreProtectAPI api = new CoreProtectAPI();

    public static CoreProtect getInstance() {
        return instance;
    }

    public CoreProtectAPI getAPI() {
        return this.api;
    }

    private static boolean performVersionChecks() {
        try {
            String requiredBukkitVersion = "1.11";
            String[] bukkitVersion = CoreProtect.getInstance().getServer().getBukkitVersion().split("-|\\.");
            if (Functions.newVersion(bukkitVersion[0] + "." + bukkitVersion[1], requiredBukkitVersion)) {
                System.out.println("[CoreProtect] Spigot " + requiredBukkitVersion + " or higher is required.");
                return false;
            }
            String requiredJavaVersion = "1.7";
            String[] javaVersion = System.getProperty("java.version").split("\\.");
            if (Functions.newVersion(javaVersion[0] + "." + javaVersion[1], requiredJavaVersion)) {
                System.out.println("[CoreProtect] Java " + requiredJavaVersion + " or higher is required.");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void onEnable() {
        instance = this;
        PluginDescriptionFile pluginDescription = this.getDescription();
        boolean start = CoreProtect.performVersionChecks();
        if (start) {
            try {
                Consumer.initialize();
                this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)new HangingListener(), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
                this.getCommand("coreprotect").setExecutor((CommandExecutor)CommandHandler.getInstance());
                this.getCommand("core").setExecutor((CommandExecutor)CommandHandler.getInstance());
                this.getCommand("co").setExecutor((CommandExecutor)CommandHandler.getInstance());
                boolean exists = new File("plugins/CoreProtect/").exists();
                if (!exists) {
                    new File("plugins/CoreProtect").mkdir();
                }
                start = Config.performInitialization();
            }
            catch (Exception e) {
                e.printStackTrace();
                start = false;
            }
        }
        if (start) {
            System.out.println("[CoreProtect] " + pluginDescription.getName() + " has been successfully enabled!");
            if (Config.config.get("use-mysql") == 1) {
                System.out.println("[CoreProtect] Using MySQL for data storage.");
            } else {
                System.out.println("[CoreProtect] Using SQLite for data storage.");
            }
            if (Config.config.get("check-updates") == 1) {
                Thread checkUpdateThread = new Thread(new CheckUpdate(true));
                checkUpdateThread.start();
            }
            Thread cacheCleanUpThread = new Thread(new CacheCleanUp());
            cacheCleanUpThread.start();
            Thread consumerThread = new Thread(new Consumer());
            consumerThread.start();
            try {
                Metrics metrics = new Metrics((Plugin)this);
                metrics.start();
            }
            catch (Exception e) {}
        } else {
            System.out.println("[CoreProtect] " + pluginDescription.getName() + " was unable to start.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        CoreProtect.safeShutdown();
    }

    private static void safeShutdown() {
        try {
            int time_start = (int)(System.currentTimeMillis() / 1000L);
            boolean processConsumer = Config.server_running;
            if (Config.converter_running) {
                processConsumer = false;
            }
            boolean message_shown = false;
            Config.server_running = false;
            while ((Consumer.isRunning() || Config.converter_running) && !Config.purge_running) {
                int time = (int)(System.currentTimeMillis() / 1000L);
                if (time > time_start && !message_shown) {
                    if (Config.converter_running) {
                        Functions.messageOwner("Finishing up data conversion. Please wait...");
                    } else {
                        Functions.messageOwner("Finishing up data logging. Please wait...");
                    }
                    message_shown = true;
                }
                Thread.sleep(1L);
            }
            if (message_shown) {
                System.out.println("[CoreProtect] Success! Resuming server shutdown.");
            }
            if (processConsumer) {
                Process.processConsumer(Consumer.current_consumer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

