/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

public class SmoothMeta {
    private volatile long lastTime = System.currentTimeMillis();
    private volatile float speedFactor = 0.0f;
    private volatile float accFac = 1.0f;

    public SmoothMeta(float accFac) {
        this.accFac = accFac;
    }

    public float getFactor() {
        this.updateTime();
        this.incrementFactor();
        return this.speedFactor;
    }

    public void updateAccelerationFactor(float accFac) {
        this.accFac = accFac;
    }

    private float getA() {
        return (float)(0.025 * (double)this.accFac);
    }

    private void incrementFactor() {
        if ((double)this.speedFactor >= 0.97) {
            this.speedFactor = 1.0f;
            return;
        }
        float diff = 1.0f - this.speedFactor;
        this.speedFactor += this.getA() * diff;
    }

    public void resetAcel() {
        this.speedFactor = 0.0f;
    }

    private void updateTime() {
        long now = System.currentTimeMillis();
        if (now - this.lastTime > 500L) {
            this.speedFactor = 0.0f;
        }
        this.lastTime = now;
    }
}

