/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.ComparableVersion;
import de.diddiz.util.UUIDFetcher;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

class Updater {
    private final LogBlock logblock;
    final int UUID_CONVERT_BATCH_SIZE = 100;

    Updater(LogBlock logblock) {
        this.logblock = logblock;
    }

    boolean update() {
        ResultSet rs;
        Statement st;
        Connection conn;
        ComparableVersion configVersion;
        FileConfiguration config = this.logblock.getConfig();
        String versionString = config.getString("version");
        if (Pattern.matches("1\\.\\d{2}", versionString)) {
            versionString = "1." + versionString.charAt(2) + "." + versionString.charAt(3);
            config.set("version", (Object)versionString);
            this.logblock.saveConfig();
        }
        if ((configVersion = new ComparableVersion(versionString)).compareTo(new ComparableVersion(this.logblock.getDescription().getVersion())) >= 0) {
            return false;
        }
        if (configVersion.compareTo(new ComparableVersion("1.2.7")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.2.7 ...");
            if (Config.isLogging(Logging.CHAT)) {
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-chat` ENGINE = MyISAM, ADD FULLTEXT message (message)");
                    st.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            config.set("version", (Object)"1.2.7");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3")) < 0) {
            Bukkit.getLogger().info("Updating config to 1.3.0 ...");
            for (String tool : config.getConfigurationSection("tools").getKeys(false)) {
                if (config.get("tools." + tool + ".permissionDefault") != null) continue;
                config.set("tools." + tool + ".permissionDefault", (Object)"OP");
            }
            config.set("version", (Object)"1.3.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3.1")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.3.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.execute("ALTER TABLE `lb-players` ADD COLUMN lastlogin DATETIME NOT NULL, ADD COLUMN onlinetime TIME NOT NULL, ADD COLUMN ip VARCHAR(255) NOT NULL");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.3.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.3.2")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.3.2 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                st.execute("ALTER TABLE `lb-players` ADD COLUMN firstlogin DATETIME NOT NULL AFTER playername");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.3.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.4")) < 0) {
            Bukkit.getLogger().info("Updating config to 1.4.0 ...");
            config.set("clearlog.keepLogDays", null);
            config.set("version", (Object)"1.4.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.4.2")) < 0) {
            Bukkit.getLogger().info("Updating config to 1.4.2 ...");
            for (String world : config.getStringList("loggedWorlds")) {
                File file = new File(this.logblock.getDataFolder(), BukkitUtils.friendlyWorldname(world) + ".yml");
                WorldConfig wcfg = YamlConfiguration.loadConfiguration((File)file);
                if (wcfg.contains("logBlockCreations")) {
                    wcfg.set("logging.BLOCKPLACE", wcfg.getBoolean("logBlockCreations"));
                }
                if (wcfg.contains("logBlockDestroyings")) {
                    wcfg.set("logging.BLOCKBREAK", wcfg.getBoolean("logBlockDestroyings"));
                }
                if (wcfg.contains("logSignTexts")) {
                    wcfg.set("logging.SIGNTEXT", wcfg.getBoolean("logSignTexts"));
                }
                if (wcfg.contains("logFire")) {
                    wcfg.set("logging.FIRE", wcfg.getBoolean("logFire"));
                }
                if (wcfg.contains("logLeavesDecay")) {
                    wcfg.set("logging.LEAVESDECAY", wcfg.getBoolean("logLeavesDecay"));
                }
                if (wcfg.contains("logLavaFlow")) {
                    wcfg.set("logging.LAVAFLOW", wcfg.getBoolean("logLavaFlow"));
                }
                if (wcfg.contains("logWaterFlow")) {
                    wcfg.set("logging.WATERFLOW", wcfg.getBoolean("logWaterFlow"));
                }
                if (wcfg.contains("logChestAccess")) {
                    wcfg.set("logging.CHESTACCESS", wcfg.getBoolean("logChestAccess"));
                }
                if (wcfg.contains("logButtonsAndLevers")) {
                    wcfg.set("logging.SWITCHINTERACT", wcfg.getBoolean("logButtonsAndLevers"));
                }
                if (wcfg.contains("logKills")) {
                    wcfg.set("logging.KILL", wcfg.getBoolean("logKills"));
                }
                if (wcfg.contains("logChat")) {
                    wcfg.set("logging.CHAT", wcfg.getBoolean("logChat"));
                }
                if (wcfg.contains("logSnowForm")) {
                    wcfg.set("logging.SNOWFORM", wcfg.getBoolean("logSnowForm"));
                }
                if (wcfg.contains("logSnowFade")) {
                    wcfg.set("logging.SNOWFADE", wcfg.getBoolean("logSnowFade"));
                }
                if (wcfg.contains("logDoors")) {
                    wcfg.set("logging.DOORINTERACT", wcfg.getBoolean("logDoors"));
                }
                if (wcfg.contains("logCakes")) {
                    wcfg.set("logging.CAKEEAT", wcfg.getBoolean("logCakes"));
                }
                if (wcfg.contains("logEndermen")) {
                    wcfg.set("logging.ENDERMEN", wcfg.getBoolean("logEndermen"));
                }
                if (wcfg.contains("logExplosions")) {
                    boolean logExplosions = wcfg.getBoolean("logExplosions");
                    wcfg.set("logging.TNTEXPLOSION", logExplosions);
                    wcfg.set("logging.MISCEXPLOSION", logExplosions);
                    wcfg.set("logging.CREEPEREXPLOSION", logExplosions);
                    wcfg.set("logging.GHASTFIREBALLEXPLOSION", logExplosions);
                }
                wcfg.set("logBlockCreations", null);
                wcfg.set("logBlockDestroyings", null);
                wcfg.set("logSignTexts", null);
                wcfg.set("logExplosions", null);
                wcfg.set("logFire", null);
                wcfg.set("logLeavesDecay", null);
                wcfg.set("logLavaFlow", null);
                wcfg.set("logWaterFlow", null);
                wcfg.set("logChestAccess", null);
                wcfg.set("logButtonsAndLevers", null);
                wcfg.set("logKills", null);
                wcfg.set("logChat", null);
                wcfg.set("logSnowForm", null);
                wcfg.set("logSnowFade", null);
                wcfg.set("logDoors", null);
                wcfg.set("logCakes", null);
                wcfg.set("logEndermen", null);
                try {
                    wcfg.save(file);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                }
            }
            config.set("clearlog.keepLogDays", null);
            config.set("version", (Object)"1.4.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.5.1")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.5.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    if (!wcfg.isLogging(Logging.KILL)) continue;
                    st.execute("ALTER TABLE `" + wcfg.table + "-kills` ADD (x MEDIUMINT NOT NULL DEFAULT 0, y SMALLINT NOT NULL DEFAULT 0, z MEDIUMINT NOT NULL DEFAULT 0)");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.5.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.5.2")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.5.2 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                rs = st.executeQuery("SHOW COLUMNS FROM `lb-players` WHERE field = 'onlinetime'");
                if (rs.next() && rs.getString("Type").equalsIgnoreCase("time")) {
                    st.execute("ALTER TABLE `lb-players` ADD onlinetime2 INT UNSIGNED NOT NULL");
                    st.execute("UPDATE `lb-players` SET onlinetime2 = HOUR(onlinetime) * 3600 + MINUTE(onlinetime) * 60 + SECOND(onlinetime)");
                    st.execute("ALTER TABLE `lb-players` DROP onlinetime");
                    st.execute("ALTER TABLE `lb-players` CHANGE onlinetime2 onlinetime INT UNSIGNED NOT NULL");
                } else {
                    Bukkit.getLogger().info("Column lb-players was already modified, skipping it.");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.5.2");
        }
        if (configVersion.compareTo(new ComparableVersion("1.8.1")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.8.1 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    if (!wcfg.isLogging(Logging.CHESTACCESS)) continue;
                    st.execute("ALTER TABLE `" + wcfg.table + "-chest` CHANGE itemdata itemdata SMALLINT NOT NULL");
                    Bukkit.getLogger().info("Table " + wcfg.table + "-chest modified");
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.8.1");
        }
        if (configVersion.compareTo(new ComparableVersion("1.9")) < 0) {
            block74: {
                Bukkit.getLogger().info("Updating tables to 1.9.0 ...");
                Bukkit.getLogger().info("Importing UUIDs for large databases may take some time");
                conn = this.logblock.getConnection();
                try {
                    conn.setAutoCommit(true);
                    st = conn.createStatement();
                    st.execute("ALTER TABLE `lb-players` ADD `UUID` VARCHAR(36) NOT NULL");
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 1060) break block74;
                    Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                    return false;
                }
            }
            try {
                String unimportedPrefix = "noimport_";
                conn.setAutoCommit(true);
                Statement st2 = conn.createStatement();
                if (config.getBoolean("logging.logPlayerInfo")) {
                    st2.execute("UPDATE `lb-players` SET UUID = CONCAT ('log_',playername) WHERE onlinetime=0 AND LENGTH(UUID) = 0");
                } else {
                    unimportedPrefix = "log_";
                }
                rs = st2.executeQuery("SELECT COUNT(playername) FROM `lb-players` WHERE LENGTH(UUID)=0");
                rs.next();
                String total = Integer.toString(rs.getInt(1));
                Bukkit.getLogger().info(total + " players to convert");
                int done = 0;
                conn.setAutoCommit(false);
                HashMap<String, Integer> players = new HashMap<String, Integer>();
                ArrayList<String> names = new ArrayList<String>(100);
                rs = st2.executeQuery("SELECT playerid,playername FROM `lb-players` WHERE LENGTH(UUID)=0 LIMIT " + Integer.toString(100));
                while (rs.next()) {
                    do {
                        players.put(rs.getString(2), rs.getInt(1));
                        names.add(rs.getString(2));
                    } while (rs.next());
                    if (names.size() <= 0) continue;
                    Map<String, UUID> response = UUIDFetcher.getUUIDs(names);
                    for (Map.Entry entry : players.entrySet()) {
                        String theUUID;
                        if (response.get(entry.getKey()) == null) {
                            theUUID = unimportedPrefix + (String)entry.getKey();
                            Bukkit.getLogger().warning((String)entry.getKey() + " not found - giving UUID of " + theUUID);
                        } else {
                            theUUID = response.get(entry.getKey()).toString();
                        }
                        String thePID = ((Integer)entry.getValue()).toString();
                        st2.execute("UPDATE `lb-players` SET UUID = '" + theUUID + "' WHERE playerid = " + thePID);
                        ++done;
                    }
                    conn.commit();
                    players.clear();
                    names.clear();
                    Bukkit.getLogger().info("Processed " + Integer.toString(done) + " out of " + total);
                    rs = st2.executeQuery("SELECT playerid,playername FROM `lb-players` WHERE LENGTH(UUID)=0 LIMIT " + Integer.toString(100));
                }
                st2.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[UUID importer]", ex);
                return false;
            }
            config.set("version", (Object)"1.9.0");
        }
        if (configVersion.compareTo(new ComparableVersion("1.9.4")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.9.4 ...");
            conn = this.logblock.getConnection();
            try {
                block76: {
                    block75: {
                        conn.setAutoCommit(true);
                        st = conn.createStatement();
                        try {
                            st.execute("DROP INDEX UUID ON `lb-players`");
                        }
                        catch (SQLException ex) {
                            if (ex.getErrorCode() == 1091) break block75;
                            Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                            return false;
                        }
                    }
                    try {
                        st.execute("DROP INDEX playername ON `lb-players`");
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 1091) break block76;
                        Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                        return false;
                    }
                }
                st.execute("CREATE INDEX UUID ON `lb-players` (UUID);");
                st.execute("CREATE INDEX playername ON `lb-players` (playername);");
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.9.4");
        }
        if (configVersion.compareTo(new ComparableVersion("1.10.0")) < 0) {
            Bukkit.getLogger().info("Updating tables to 1.10.0 ...");
            conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                st = conn.createStatement();
                this.checkCharset("lb-players", "name", st);
                if (Config.isLogging(Logging.CHAT)) {
                    this.checkCharset("lb-chat", "message", st);
                }
                for (WorldConfig wcfg : Config.getLoggedWorlds()) {
                    if (!wcfg.isLogging(Logging.SIGNTEXT)) continue;
                    this.checkCharset(wcfg.table + "-sign", "signtext", st);
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
                return false;
            }
            config.set("version", (Object)"1.10.0");
        }
        this.logblock.saveConfig();
        return true;
    }

    void checkCharset(String table, String column, Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SHOW FULL COLUMNS FROM `" + table + "` WHERE field = '" + column + "'");
        String charset = "utf8";
        if (Config.mb4) {
            charset = "utf8mb4";
        }
        if (rs.next() && !rs.getString("Collation").substring(0, charset.length()).equalsIgnoreCase(charset)) {
            st.execute("ALTER TABLE `" + table + "` CONVERT TO CHARSET " + charset);
            Bukkit.getLogger().info("Table " + table + " modified");
        } else {
            Bukkit.getLogger().info("Table " + table + " already fine, skipping it");
        }
    }

    void checkTables() throws SQLException {
        Connection conn;
        String charset = "utf8";
        if (Config.mb4) {
            charset = "utf8mb4";
        }
        if ((conn = this.logblock.getConnection()) == null) {
            throw new SQLException("No connection");
        }
        Statement state = conn.createStatement();
        DatabaseMetaData dbm = conn.getMetaData();
        conn.setAutoCommit(true);
        Updater.createTable(dbm, state, "lb-players", "(playerid INT UNSIGNED NOT NULL AUTO_INCREMENT, UUID varchar(36) NOT NULL, playername varchar(32) NOT NULL, firstlogin DATETIME NOT NULL, lastlogin DATETIME NOT NULL, onlinetime INT UNSIGNED NOT NULL, ip varchar(255) NOT NULL, PRIMARY KEY (playerid), INDEX (UUID), INDEX (playername)) DEFAULT CHARSET " + charset);
        ResultSet rs = state.executeQuery("SELECT NULL FROM `lb-players` LIMIT 1;");
        if (!rs.next()) {
            state.execute("INSERT IGNORE INTO `lb-players` (UUID,playername) VALUES ('log_dummy_record','dummy_record')");
        }
        if (Config.isLogging(Logging.CHAT)) {
            Updater.createTable(dbm, state, "lb-chat", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, message VARCHAR(255) NOT NULL, PRIMARY KEY (id), KEY playerid (playerid), FULLTEXT message (message)) ENGINE=MyISAM DEFAULT CHARSET " + charset);
        }
        for (WorldConfig wcfg : Config.getLoggedWorlds()) {
            Updater.createTable(dbm, state, wcfg.table, "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, playerid INT UNSIGNED NOT NULL, replaced TINYINT UNSIGNED NOT NULL, type TINYINT UNSIGNED NOT NULL, data TINYINT UNSIGNED NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT UNSIGNED NOT NULL, z MEDIUMINT NOT NULL, PRIMARY KEY (id), KEY coords (x, z, y), KEY date (date), KEY playerid (playerid))");
            Updater.createTable(dbm, state, wcfg.table + "-sign", "(id INT UNSIGNED NOT NULL, signtext VARCHAR(255) NOT NULL, PRIMARY KEY (id)) DEFAULT CHARSET " + charset);
            Updater.createTable(dbm, state, wcfg.table + "-chest", "(id INT UNSIGNED NOT NULL, itemtype SMALLINT UNSIGNED NOT NULL, itemamount SMALLINT NOT NULL, itemdata SMALLINT NOT NULL, PRIMARY KEY (id))");
            if (!wcfg.isLogging(Logging.KILL)) continue;
            Updater.createTable(dbm, state, wcfg.table + "-kills", "(id INT UNSIGNED NOT NULL AUTO_INCREMENT, date DATETIME NOT NULL, killer INT UNSIGNED, victim INT UNSIGNED NOT NULL, weapon SMALLINT UNSIGNED NOT NULL, x MEDIUMINT NOT NULL, y SMALLINT NOT NULL, z MEDIUMINT NOT NULL, PRIMARY KEY (id))");
        }
        state.close();
        conn.close();
    }

    private static void createTable(DatabaseMetaData dbm, Statement state, String table, String query) throws SQLException {
        if (!dbm.getTables(null, null, table, null).next()) {
            Bukkit.getLogger().log(Level.INFO, "Creating table " + table + ".");
            state.execute("CREATE TABLE `" + table + "` " + query);
            if (!dbm.getTables(null, null, table, null).next()) {
                throw new SQLException("Table " + table + " not found and failed to create");
            }
        }
    }

    public static class PlayerCountChecker
    implements Runnable {
        private LogBlock logblock;

        public PlayerCountChecker(LogBlock logblock) {
            this.logblock = logblock;
        }

        @Override
        public void run() {
            Connection conn = this.logblock.getConnection();
            try {
                conn.setAutoCommit(true);
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery("SELECT auto_increment FROM information_schema.columns AS col join information_schema.tables AS tab ON (col.table_schema=tab.table_schema AND col.table_name=tab.table_name) WHERE col.table_name = 'lb-players' AND col.column_name = 'playerid' AND col.data_type = 'smallint' AND col.table_schema = DATABASE() AND auto_increment > 65000;");
                if (rs.next()) {
                    for (int i = 0; i < 6; ++i) {
                        this.logblock.getLogger().warning("Your server reached 65000 players. You should soon update your database table schema - see FAQ: https://github.com/LogBlock/LogBlock/wiki/FAQ#logblock-your-server-reached-65000-players-");
                    }
                }
                st.close();
                conn.close();
            }
            catch (SQLException ex) {
                this.logblock.getLogger().log(Level.SEVERE, "[Updater] Error: ", ex);
            }
        }
    }
}

