/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.stuff;

import java.util.HashMap;
import java.util.Map;

public enum ChatColor {
    BLACK('0', 0),
    DARK_BLUE('1', 1),
    DARK_GREEN('2', 2),
    DARK_AQUA('3', 3),
    DARK_RED('4', 4),
    DARK_PURPLE('5', 5),
    GOLD('6', 6),
    GRAY('7', 7),
    DARK_GRAY('8', 8),
    BLUE('9', 9),
    GREEN('a', 10),
    AQUA('b', 11),
    RED('c', 12),
    LIGHT_PURPLE('d', 13),
    YELLOW('e', 14),
    WHITE('f', 15);

    private static final char COLOR_CHAR = '\u00a7';
    private final char code;
    private final int intCode;
    private final String toString;
    private static final Map<Integer, ChatColor> intMap;
    private static final Map<Character, ChatColor> charMap;
    private static final Map<String, ChatColor> stringMap;

    static {
        intMap = new HashMap<Integer, ChatColor>();
        charMap = new HashMap<Character, ChatColor>();
        stringMap = new HashMap<String, ChatColor>();
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor color = chatColorArray[n2];
            intMap.put(color.intCode, color);
            charMap.put(Character.valueOf(color.code), color);
            stringMap.put(color.name().toLowerCase(), color);
            ++n2;
        }
    }

    private ChatColor(char code, int intCode) {
        this.code = code;
        this.intCode = intCode;
        this.toString = new String(new char[]{'\u00a7', code});
    }

    public char getChar() {
        return this.code;
    }

    public String toString() {
        return this.toString;
    }

    public static ChatColor matchColor(char code) {
        return charMap.get(Character.valueOf(code));
    }

    public static ChatColor matchColor(int code) {
        return intMap.get(code);
    }

    public static ChatColor matchColor(String name) {
        return stringMap.get(name.toLowerCase());
    }
}

