/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.stuff;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.economy.BufferedPayment;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ActionBar {
    private int cleanVersion = -1;
    private String version = "";
    private Object packet;
    private Method getHandle;
    private Method sendPacket;
    private Field playerConnection;
    private Class<?> nmsChatSerializer;
    private Class<?> nmsIChatBaseComponent;
    private Class<?> packetType;

    public int getVersion() {
        if (this.cleanVersion == -1) {
            this.getInfo();
        }
        return this.cleanVersion;
    }

    private void getInfo() {
        try {
            block15: {
                String[] v = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
                this.version = v[v.length - 1];
                try {
                    this.cleanVersion = Integer.parseInt(this.version.replace("v", "").replace("V", "").replace("_", "").replace("r", "").replace("R", ""));
                    this.cleanVersion *= 10;
                }
                catch (NumberFormatException e) {
                    if (this.version.contains("v1_4")) {
                        this.cleanVersion = 1400;
                    }
                    if (this.version.contains("v1_5")) {
                        this.cleanVersion = 1500;
                    }
                    if (this.version.contains("v1_6")) {
                        this.cleanVersion = 1600;
                    }
                    if (this.version.contains("v1_7")) {
                        this.cleanVersion = 1700;
                    }
                    if (this.version.contains("v1_8_R1")) {
                        this.cleanVersion = 1810;
                    }
                    if (this.version.contains("v1_8_R2")) {
                        this.cleanVersion = 1820;
                    }
                    if (this.version.contains("v1_8_R3")) {
                        this.cleanVersion = 1830;
                    }
                    if (this.version.contains("v1_9_R1")) {
                        this.cleanVersion = 1910;
                    }
                    if (this.version.contains("v1_9_R2")) {
                        this.cleanVersion = 1920;
                    }
                    if (this.version.contains("v1_10_R1")) {
                        this.cleanVersion = 11010;
                    }
                    if (!this.version.contains("v1_11_R1")) break block15;
                    this.cleanVersion = 11110;
                }
            }
            if (this.cleanVersion < 1400) {
                this.cleanVersion *= 10;
            }
            this.packetType = Class.forName(this.getPacketPlayOutChat());
            Class<?> typeCraftPlayer = Class.forName(this.getCraftPlayerClasspath());
            Class<?> typeNMSPlayer = Class.forName(this.getNMSPlayerClasspath());
            Class<?> typePlayerConnection = Class.forName(this.getPlayerConnectionClasspath());
            this.nmsChatSerializer = Class.forName(this.getChatSerializerClasspath());
            this.nmsIChatBaseComponent = Class.forName(this.getIChatBaseComponentClasspath());
            this.getHandle = typeCraftPlayer.getMethod("getHandle", new Class[0]);
            this.playerConnection = typeNMSPlayer.getField("playerConnection");
            this.sendPacket = typePlayerConnection.getMethod("sendPacket", Class.forName(this.getPacketClasspath()));
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error {0}", ex);
        }
    }

    public void ShowActionBar(BufferedPayment payment) {
        if (this.cleanVersion == -1) {
            this.getInfo();
        }
        if (this.cleanVersion == -1) {
            return;
        }
        String playername = payment.getOfflinePlayer().getName();
        if (!Jobs.getActionbarToggleList().containsKey(playername) && Jobs.getGCManager().ActionBarsMessageByDefault) {
            Jobs.getActionbarToggleList().put(playername, true);
        }
        if (playername == null) {
            return;
        }
        if (!Jobs.getActionbarToggleList().containsKey(playername)) {
            return;
        }
        Boolean show = Jobs.getActionbarToggleList().get(playername);
        Player abp = Bukkit.getPlayer((UUID)payment.getOfflinePlayer().getUniqueId());
        if (abp != null && show.booleanValue()) {
            String Message = Jobs.getLanguage().getMessage("command.toggle.output.paid.main");
            if (payment.getAmount() != 0.0) {
                Message = String.valueOf(Message) + " " + Jobs.getLanguage().getMessage("command.toggle.output.paid.money", "[amount]", String.format("%.2f", payment.getAmount()));
            }
            if (payment.getPoints() != 0.0) {
                Message = String.valueOf(Message) + " " + Jobs.getLanguage().getMessage("command.toggle.output.paid.points", "[points]", String.format("%.2f", payment.getPoints()));
            }
            if (payment.getExp() != 0.0) {
                Message = String.valueOf(Message) + " " + Jobs.getLanguage().getMessage("command.toggle.output.paid.exp", "[exp]", String.format("%.2f", payment.getExp()));
            }
            this.send((CommandSender)abp, ChatColor.GREEN + Message);
        }
    }

    public void send(CommandSender receivingPacket, String msg) {
        try {
            if (msg == null || this.nmsChatSerializer == null || msg.isEmpty()) {
                return;
            }
            if (receivingPacket == null) {
                return;
            }
            if (this.cleanVersion < 1800 || !(receivingPacket instanceof Player)) {
                receivingPacket.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
                return;
            }
            Object serialized = this.nmsChatSerializer.getMethod("a", String.class).invoke(null, "{\"text\": \"" + ChatColor.translateAlternateColorCodes((char)'&', (String)msg) + "\"}");
            this.packet = this.cleanVersion > 1800 ? this.packetType.getConstructor(this.nmsIChatBaseComponent, Byte.TYPE).newInstance(serialized, (byte)2) : this.packetType.getConstructor(this.nmsIChatBaseComponent, Integer.TYPE).newInstance(serialized, 2);
            Object player = this.getHandle.invoke((Object)receivingPacket, new Object[0]);
            Object connection = this.playerConnection.get(player);
            this.sendPacket.invoke(connection, this.packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error {0}", ex);
        }
    }

    private String getCraftPlayerClasspath() {
        return "org.bukkit.craftbukkit." + this.version + ".entity.CraftPlayer";
    }

    private String getPlayerConnectionClasspath() {
        return "net.minecraft.server." + this.version + ".PlayerConnection";
    }

    private String getNMSPlayerClasspath() {
        return "net.minecraft.server." + this.version + ".EntityPlayer";
    }

    private String getPacketClasspath() {
        return "net.minecraft.server." + this.version + ".Packet";
    }

    private String getIChatBaseComponentClasspath() {
        return "net.minecraft.server." + this.version + ".IChatBaseComponent";
    }

    private String getChatSerializerClasspath() {
        if (this.cleanVersion < 1820) {
            return "net.minecraft.server." + this.version + ".ChatSerializer";
        }
        return "net.minecraft.server." + this.version + ".IChatBaseComponent$ChatSerializer";
    }

    private String getPacketPlayOutChat() {
        return "net.minecraft.server." + this.version + ".PacketPlayOutChat";
    }
}

