/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.selection;

import com.gamingmesh.jobs.container.CuboidArea;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class SelectionManager {
    protected Map<String, Location> playerLoc1 = Collections.synchronizedMap(new HashMap());
    protected Map<String, Location> playerLoc2 = Collections.synchronizedMap(new HashMap());
    public static final int MIN_HEIGHT = 0;

    public void updateLocations(Player player, Location loc1, Location loc2) {
        if (loc1 != null && loc2 != null) {
            this.playerLoc1.put(player.getName(), loc1);
            this.playerLoc2.put(player.getName(), loc2);
        }
    }

    public void placeLoc1(Player player, Location loc) {
        if (loc != null) {
            this.playerLoc1.put(player.getName(), loc);
        }
    }

    public void placeLoc2(Player player, Location loc) {
        if (loc != null) {
            this.playerLoc2.put(player.getName(), loc);
        }
    }

    public Location getPlayerLoc1(Player player) {
        return this.getPlayerLoc1(player.getName());
    }

    public Location getPlayerLoc1(String player) {
        return this.playerLoc1.get(player);
    }

    public Location getPlayerLoc2(Player player) {
        return this.getPlayerLoc2(player.getName());
    }

    public Location getPlayerLoc2(String player) {
        return this.playerLoc2.get(player);
    }

    public CuboidArea getSelectionCuboid(Player player) {
        return this.getSelectionCuboid(player.getName());
    }

    public CuboidArea getSelectionCuboid(String player) {
        return new CuboidArea(this.getPlayerLoc1(player), this.getPlayerLoc2(player));
    }

    public boolean hasPlacedBoth(Player player) {
        return this.hasPlacedBoth(player.getName());
    }

    public boolean hasPlacedBoth(String player) {
        return this.playerLoc1.containsKey(player) && this.playerLoc2.containsKey(player);
    }

    public void clearSelection(Player player) {
        this.playerLoc1.remove(player.getName());
        this.playerLoc2.remove(player.getName());
    }

    public void selectChunk(Player player) {
        Chunk chunk = player.getWorld().getChunkAt(player.getLocation());
        int xcoord = chunk.getX() * 16;
        int zcoord = chunk.getZ() * 16;
        boolean ycoord = false;
        int xmax = xcoord + 15;
        int zmax = zcoord + 15;
        int ymax = player.getLocation().getWorld().getMaxHeight() - 1;
        this.playerLoc1.put(player.getName(), new Location(player.getWorld(), (double)xcoord, (double)ycoord, (double)zcoord));
        this.playerLoc2.put(player.getName(), new Location(player.getWorld(), (double)xmax, (double)ymax, (double)zmax));
        player.sendMessage("msg");
    }

    public boolean worldEdit(Player player) {
        player.sendMessage("msg");
        return false;
    }

    public boolean worldEditUpdate(Player player) {
        player.sendMessage("msg");
        return false;
    }

    public void selectBySize(Player player, int xsize, int ysize, int zsize) {
        Location myloc = player.getLocation();
        Location loc1 = new Location(myloc.getWorld(), (double)(myloc.getBlockX() + xsize), (double)(myloc.getBlockY() + ysize), (double)(myloc.getBlockZ() + zsize));
        Location loc2 = new Location(myloc.getWorld(), (double)(myloc.getBlockX() - xsize), (double)(myloc.getBlockY() - ysize), (double)(myloc.getBlockZ() - zsize));
        this.placeLoc1(player, loc1);
        this.placeLoc2(player, loc2);
        player.sendMessage("msg");
    }
}

