/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.economy;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.api.JobsPaymentEvent;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.economy.BufferedPayment;
import com.gamingmesh.jobs.economy.Economy;
import com.gamingmesh.jobs.economy.PaymentData;
import com.gamingmesh.jobs.stuff.ChatColor;
import com.gamingmesh.jobs.tasks.BufferedPaymentTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class BufferedEconomy {
    private Jobs plugin;
    private Economy economy;
    private LinkedBlockingQueue<BufferedPayment> payments = new LinkedBlockingQueue();
    private final Map<UUID, BufferedPayment> paymentCache = Collections.synchronizedMap(new HashMap());
    private OfflinePlayer ServerAccount = null;
    private OfflinePlayer ServerTaxesAccount = null;
    PaymentData PaymentData = new PaymentData();

    public BufferedEconomy(Jobs plugin, Economy economy) {
        this.plugin = plugin;
        this.economy = economy;
    }

    public void pay(JobsPlayer player, double amount, double points2, double exp) {
        this.pay(new BufferedPayment((OfflinePlayer)player.getPlayer(), amount, points2, exp));
    }

    public void pay(BufferedPayment payment) {
        this.payments.add(payment);
    }

    public String format(double money) {
        return this.economy.format(money);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void payAll() {
        if (this.payments.isEmpty()) {
            return;
        }
        Map<UUID, BufferedPayment> map = this.paymentCache;
        synchronized (map) {
            Double TotalAmount = 0.0;
            Double TotalPoints = 0.0;
            Double TaxesAmount = 0.0;
            Double TaxesPoints = 0.0;
            while (!this.payments.isEmpty()) {
                BufferedPayment payment = (BufferedPayment)this.payments.remove();
                TotalAmount = TotalAmount + payment.getAmount();
                TotalPoints = TotalPoints + payment.getPoints();
                if (Jobs.getGCManager().UseTaxes) {
                    TaxesAmount = TaxesAmount + payment.getAmount() * (Jobs.getGCManager().TaxesAmount / 100.0);
                    TaxesPoints = TaxesPoints + payment.getPoints() * (Jobs.getGCManager().TaxesAmount / 100.0);
                }
                if (payment.getOfflinePlayer() == null) continue;
                UUID uuid = payment.getOfflinePlayer().getUniqueId();
                if (this.paymentCache.containsKey(uuid)) {
                    BufferedPayment existing = this.paymentCache.get(uuid);
                    double money = payment.getAmount();
                    double points2 = payment.getPoints();
                    double exp = payment.getExp();
                    if (Jobs.getGCManager().TakeFromPlayersPayment && Jobs.getGCManager().UseTaxes) {
                        money -= money * (Jobs.getGCManager().TaxesAmount / 100.0);
                        points2 -= points2 * (Jobs.getGCManager().TaxesAmount / 100.0);
                    }
                    existing.setAmount(existing.getAmount() + money);
                    existing.setPoints(existing.getPoints() + points2);
                    existing.setExp(existing.getExp() + exp);
                    continue;
                }
                double money = payment.getAmount();
                double points3 = payment.getPoints();
                if (Jobs.getGCManager().TakeFromPlayersPayment && Jobs.getGCManager().UseTaxes) {
                    payment.setAmount(money - money * (Jobs.getGCManager().TaxesAmount / 100.0));
                    payment.setPoints(points3 - points3 * (Jobs.getGCManager().TaxesAmount / 100.0));
                }
                this.paymentCache.put(uuid, payment);
            }
            boolean hasMoney = false;
            String ServerAccountname = Jobs.getGCManager().ServerAcountName;
            String ServerTaxesAccountname = Jobs.getGCManager().ServertaxesAcountName;
            if (this.ServerAccount == null) {
                this.ServerAccount = Bukkit.getOfflinePlayer((String)ServerAccountname);
            }
            if (this.ServerTaxesAccount == null) {
                this.ServerTaxesAccount = Bukkit.getOfflinePlayer((String)ServerTaxesAccountname);
            }
            if (Jobs.getGCManager().UseTaxes && Jobs.getGCManager().TransferToServerAccount && this.ServerTaxesAccount != null) {
                this.economy.depositPlayer(this.ServerTaxesAccount, (double)TaxesAmount);
                if (this.ServerTaxesAccount.isOnline()) {
                    if (!Jobs.getActionbarToggleList().containsKey(ServerTaxesAccountname) && Jobs.getGCManager().ActionBarsMessageByDefault) {
                        Jobs.getActionbarToggleList().put(ServerTaxesAccountname, true);
                    }
                    if (Jobs.getActionbarToggleList().containsKey(ServerTaxesAccountname) && Jobs.getActionbarToggleList().get(ServerTaxesAccountname).booleanValue()) {
                        Jobs.getActionBar().send((CommandSender)Bukkit.getPlayer((String)ServerAccountname), Jobs.getLanguage().getMessage("message.taxes", "[amount]", (double)((int)(TotalAmount * 100.0)) / 100.0));
                    }
                }
            }
            if (Jobs.getGCManager().UseServerAccount && this.economy.hasMoney(ServerAccountname, (double)TotalAmount)) {
                hasMoney = true;
                this.economy.withdrawPlayer(ServerAccountname, (double)TotalAmount);
            }
            int i = 0;
            for (BufferedPayment payment : this.paymentCache.values()) {
                ++i;
                if (payment.getOfflinePlayer() == null) continue;
                JobsPaymentEvent JobsPaymentEvent2 = new JobsPaymentEvent(payment.getOfflinePlayer(), payment.getAmount(), payment.getPoints());
                Bukkit.getServer().getPluginManager().callEvent((Event)JobsPaymentEvent2);
                if (JobsPaymentEvent2.isCancelled()) continue;
                payment.setAmount(JobsPaymentEvent2.getAmount());
                payment.setPoints(JobsPaymentEvent2.getPoints());
                if (Jobs.getGCManager().UseServerAccount) {
                    if (!hasMoney) {
                        Jobs.getActionBar().send((CommandSender)payment.getOfflinePlayer().getPlayer(), (Object)((Object)ChatColor.RED) + Jobs.getLanguage().getMessage("economy.error.nomoney"));
                        continue;
                    }
                    if (Jobs.getGCManager().isEconomyAsync()) {
                        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)new BufferedPaymentTask(this, this.economy, payment), (long)i);
                    } else {
                        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new BufferedPaymentTask(this, this.economy, payment), (long)i);
                    }
                } else if (Jobs.getGCManager().isEconomyAsync()) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)new BufferedPaymentTask(this, this.economy, payment), (long)i);
                } else {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new BufferedPaymentTask(this, this.economy, payment), (long)i);
                }
                try {
                    Jobs.getActionBar().ShowActionBar(payment);
                    if (!payment.getOfflinePlayer().isOnline() || Jobs.getActionBar().getVersion() <= 1900) continue;
                    JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(payment.getOfflinePlayer().getUniqueId());
                    Jobs.getBBManager().ShowJobProgression(jPlayer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.paymentCache.clear();
        }
    }
}

