/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.dao;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.PlayerInfo;
import com.gamingmesh.jobs.dao.JobsConnection;
import com.gamingmesh.jobs.dao.JobsDAO;
import com.gamingmesh.jobs.stuff.UUIDUtil;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class JobsDAOSQLite
extends JobsDAO {
    public static JobsDAOSQLite initialize(Jobs plugin) {
        JobsDAOSQLite dao = new JobsDAOSQLite(plugin);
        File dir = Jobs.getFolder();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            dao.setUp();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dao;
    }

    private JobsDAOSQLite(Jobs plugin) {
        super(plugin, "org.sqlite.JDBC", "jdbc:sqlite:" + new File(Jobs.getFolder(), "jobs.sqlite.db").getPath(), null, null, "");
    }

    private static void close(ResultSet res) {
        if (res != null) {
            try {
                res.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void close(PreparedStatement prest) {
        if (prest != null) {
            try {
                prest.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected synchronized void setupConfig() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        ResultSet res = null;
        int rows = 0;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM sqlite_master WHERE name = ?;");
            prest.setString(1, String.valueOf(this.getPrefix()) + "config");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOSQLite.close(res);
            JobsDAOSQLite.close(prest);
            throw throwable;
        }
        JobsDAOSQLite.close(res);
        JobsDAOSQLite.close(prest);
        if (rows == 0) {
            PreparedStatement insert = null;
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "config` (`key` varchar(50) NOT NULL PRIMARY KEY, `value` varchar(100) NOT NULL);");
                insert = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "config` (`key`, `value`) VALUES (?, ?);");
                insert.setString(1, "version");
                insert.setString(2, "1");
                insert.execute();
            }
            catch (Throwable throwable) {
                JobsDAOSQLite.close(insert);
                throw throwable;
            }
            JobsDAOSQLite.close(insert);
        }
    }

    @Override
    protected synchronized void checkUpdate() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        this.createDefaultJobsBase();
        this.createDefaultLogBase();
        this.createDefaultArchiveBase();
        this.createDefaultPointsBase();
        this.createDefaultExploreBase();
        this.createDefaultUsersBase();
        this.createDefaultBlockProtection();
        this.createDefaultLimitBase();
    }

    @Override
    protected synchronized void checkUpdate2() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        ResultSet res = null;
        int rows = 0;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM sqlite_master WHERE name = ?;");
            prest.setString(1, String.valueOf(this.getPrefix()) + "jobs");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOSQLite.close(res);
            JobsDAOSQLite.close(prest);
            throw throwable;
        }
        JobsDAOSQLite.close(res);
        JobsDAOSQLite.close(prest);
        if (rows > 0) {
            this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs` ADD COLUMN `username` varchar(20);");
        }
    }

    @Override
    protected synchronized void checkUpdate4() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        ResultSet res = null;
        int rows = 0;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM sqlite_master WHERE name = ?;");
            prest.setString(1, String.valueOf(this.getPrefix()) + "archive");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOSQLite.close(res);
            JobsDAOSQLite.close(prest);
            throw throwable;
        }
        JobsDAOSQLite.close(res);
        JobsDAOSQLite.close(prest);
        if (rows == 0) {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` binary(16) NOT NULL, `username` varchar(20), `job` varchar(20), `experience` int, `level` int);");
        }
    }

    @Override
    protected synchronized void checkUpdate5() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        ResultSet res = null;
        int rows = 0;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM sqlite_master WHERE name = ?;");
            prest.setString(1, String.valueOf(this.getPrefix()) + "log");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOSQLite.close(res);
            JobsDAOSQLite.close(prest);
            throw throwable;
        }
        JobsDAOSQLite.close(res);
        JobsDAOSQLite.close(prest);
        if (rows == 0) {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` binary(16) NOT NULL, `username` varchar(20), `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
        }
    }

    @Override
    protected synchronized void checkUpdate6() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log_temp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` binary(16) NOT NULL, `username` varchar(20), `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executeSQL("INSERT INTO `" + this.getPrefix() + "log_temp` SELECT `id`, `player_uuid`, `username`, `time`, `action`, `itemname`, `count`, `money`, `exp` FROM `" + this.getPrefix() + "log`;");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "log`;");
        try {
            this.executeSQL("ALTER TABLE `" + this.getPrefix() + "log_temp` RENAME TO `" + this.getPrefix() + "log`;");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected synchronized void checkUpdate7() throws SQLException {
        boolean nodata;
        boolean convertLog;
        JobsConnection conn;
        block54: {
            boolean noArchivedata;
            boolean convertArchive;
            block52: {
                boolean noJobsdata;
                boolean convertJobs;
                block50: {
                    conn = this.getConnection();
                    if (conn == null) {
                        Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
                        return;
                    }
                    convertJobs = true;
                    PreparedStatement tempPst = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "jobs`;");
                    ResultSet tempRes = tempPst.executeQuery();
                    noJobsdata = true;
                    try {
                        try {
                            if (tempRes.next()) {
                                noJobsdata = false;
                                tempRes.getByte("player_uuid");
                            }
                        }
                        catch (Exception e) {
                            convertJobs = false;
                            tempRes.close();
                            tempPst.close();
                            break block50;
                        }
                    }
                    catch (Throwable throwable) {
                        tempRes.close();
                        tempPst.close();
                        throw throwable;
                    }
                    tempRes.close();
                    tempPst.close();
                }
                if (noJobsdata) {
                    this.dropDataBase("jobs");
                    try {
                        this.executeSQL("CREATE TABLE `" + this.getPrefix() + "jobs` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `job` varchar(20), `experience` int, `level` int);");
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    convertJobs = false;
                }
                if (convertJobs) {
                    Jobs.getPluginLogger().info("Converting byte uuids to string.  This could take a long time!!!");
                    try {
                        this.executeSQL("CREATE TABLE `" + this.getPrefix() + "jobs_temp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` varchar(36) NOT NULL,`username` varchar(20), `job` varchar(20), `experience` int, `level` int);");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    PreparedStatement pst1 = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "jobs`;");
                    ResultSet rs = pst1.executeQuery();
                    Statement insert = null;
                    conn.setAutoCommit(false);
                    while (rs.next()) {
                        String uuid;
                        byte[] uuidBytes = rs.getBytes("player_uuid");
                        if (uuidBytes == null || (uuid = UUIDUtil.fromBytes(uuidBytes).toString()) == null) continue;
                        insert = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "jobs_temp` (`player_uuid`, `username`, `job`, `experience`, `level`) VALUES (?, ?, ?, ?, ?);");
                        insert.setString(1, uuid);
                        insert.setString(2, rs.getString("username"));
                        insert.setString(3, rs.getString("job"));
                        insert.setInt(4, rs.getInt("experience"));
                        insert.setInt(5, rs.getInt("level"));
                        insert.addBatch();
                    }
                    if (insert != null) {
                        insert.executeBatch();
                    }
                    conn.commit();
                    conn.setAutoCommit(true);
                    rs.close();
                    pst1.close();
                    if (insert != null) {
                        insert.close();
                    }
                    this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "jobs`;");
                    try {
                        this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs_temp` RENAME TO `" + this.getPrefix() + "jobs`;");
                    }
                    catch (Exception uuidBytes) {
                        // empty catch block
                    }
                }
                convertArchive = true;
                PreparedStatement tempArchivePst = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "archive`;");
                ResultSet tempArchiveRes = tempArchivePst.executeQuery();
                noArchivedata = true;
                try {
                    try {
                        if (tempArchiveRes.next()) {
                            noArchivedata = false;
                            tempArchiveRes.getByte("player_uuid");
                        }
                    }
                    catch (Exception e) {
                        convertArchive = false;
                        tempArchiveRes.close();
                        tempArchivePst.close();
                        break block52;
                    }
                }
                catch (Throwable throwable) {
                    tempArchiveRes.close();
                    tempArchivePst.close();
                    throw throwable;
                }
                tempArchiveRes.close();
                tempArchivePst.close();
            }
            if (noArchivedata) {
                this.dropDataBase("archive");
                try {
                    this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `job` varchar(20), `experience` int, `level` int);");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                convertArchive = false;
            }
            if (convertArchive) {
                try {
                    this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive_temp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` varchar(36) NOT NULL, `username` varchar(20), `job` varchar(20), `experience` int, `level` int);");
                }
                catch (Exception e) {
                    // empty catch block
                }
                PreparedStatement pst11 = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "archive`;");
                ResultSet rs1 = pst11.executeQuery();
                Statement insert1 = null;
                conn.setAutoCommit(false);
                while (rs1.next()) {
                    String uuid = UUIDUtil.fromBytes(rs1.getBytes("player_uuid")).toString();
                    if (uuid == null) continue;
                    insert1 = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "archive_temp` (`player_uuid`, `username`, `job`, `experience`, `level`) VALUES (?, ?, ?, ?, ?);");
                    insert1.setString(1, uuid);
                    insert1.setString(2, rs1.getString("username"));
                    insert1.setString(3, rs1.getString("job"));
                    insert1.setInt(4, rs1.getInt("experience"));
                    insert1.setInt(5, rs1.getInt("level"));
                    insert1.addBatch();
                }
                if (insert1 != null) {
                    insert1.executeBatch();
                }
                conn.commit();
                conn.setAutoCommit(true);
                rs1.close();
                pst11.close();
                if (insert1 != null) {
                    insert1.close();
                }
                this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "archive`;");
                try {
                    this.executeSQL("ALTER TABLE `" + this.getPrefix() + "archive_temp` RENAME TO `" + this.getPrefix() + "archive`;");
                }
                catch (Exception uuid) {
                    // empty catch block
                }
            }
            convertLog = true;
            PreparedStatement tempLogPst = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "log`;");
            ResultSet tempLogRes = tempLogPst.executeQuery();
            nodata = true;
            try {
                try {
                    if (tempLogRes.next()) {
                        nodata = false;
                        tempLogRes.getByte("player_uuid");
                    }
                }
                catch (Exception e) {
                    convertLog = false;
                    tempLogRes.close();
                    tempLogPst.close();
                    break block54;
                }
            }
            catch (Throwable throwable) {
                tempLogRes.close();
                tempLogPst.close();
                throw throwable;
            }
            tempLogRes.close();
            tempLogPst.close();
        }
        if (nodata) {
            this.dropDataBase("log");
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
            }
            catch (SQLException e) {
                // empty catch block
            }
            convertLog = false;
        }
        if (convertLog) {
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log_temp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` varchar(36) NOT NULL, `username` varchar(20), `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
            }
            catch (Exception e) {
                // empty catch block
            }
            PreparedStatement pst111 = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "log`;");
            ResultSet rs11 = pst111.executeQuery();
            Statement insert11 = null;
            conn.setAutoCommit(false);
            while (rs11.next()) {
                String uuid = UUIDUtil.fromBytes(rs11.getBytes("player_uuid")).toString();
                if (uuid == null) continue;
                insert11 = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "log_temp` (`player_uuid`, `username`, `time`, `action`, `itemname`, `count`, `money`, `exp`) VALUES (?, ?, ?, ?, ?, ?, ?, ?);");
                insert11.setString(1, uuid);
                insert11.setString(2, rs11.getString("username"));
                insert11.setLong(3, rs11.getLong("time"));
                insert11.setString(4, rs11.getString("action"));
                insert11.setString(5, rs11.getString("itemname"));
                insert11.setInt(6, rs11.getInt("count"));
                insert11.setDouble(7, rs11.getDouble("money"));
                insert11.setDouble(8, rs11.getDouble("exp"));
                insert11.addBatch();
            }
            if (insert11 != null) {
                insert11.executeBatch();
            }
            conn.commit();
            conn.setAutoCommit(true);
            rs11.close();
            pst111.close();
            if (insert11 != null) {
                insert11.close();
            }
            this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "log`;");
            try {
                this.executeSQL("ALTER TABLE `" + this.getPrefix() + "log_temp` RENAME TO `" + this.getPrefix() + "log`;");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected synchronized void checkUpdate8() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        ResultSet res = null;
        int rows = 0;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM sqlite_master WHERE name = ?;");
            prest.setString(1, String.valueOf(this.getPrefix()) + "explore");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOSQLite.close(res);
            JobsDAOSQLite.close(prest);
            throw throwable;
        }
        JobsDAOSQLite.close(res);
        JobsDAOSQLite.close(prest);
        try {
            if (rows == 0) {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "explore` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `worldname` varchar(64), `chunkX` int, `chunkZ` int, `playerName` varchar(32));");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected synchronized void checkUpdate9() throws SQLException {
        HashMap<String, PlayerInfo> tempPlayerMap;
        JobsConnection conn;
        block73: {
            block71: {
                boolean next;
                int rows;
                block69: {
                    conn = this.getConnection();
                    if (conn == null) {
                        Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to SQLite!");
                        return;
                    }
                    PreparedStatement prestTemp = null;
                    ResultSet res1 = null;
                    rows = 0;
                    try {
                        prestTemp = conn.prepareStatement("SELECT COUNT(*) FROM sqlite_master WHERE name = ?;");
                        prestTemp.setString(1, String.valueOf(this.getPrefix()) + "users");
                        res1 = prestTemp.executeQuery();
                        if (res1.next()) {
                            rows = res1.getInt(1);
                        }
                    }
                    catch (Throwable throwable) {
                        JobsDAOSQLite.close(res1);
                        JobsDAOSQLite.close(prestTemp);
                        throw throwable;
                    }
                    JobsDAOSQLite.close(res1);
                    JobsDAOSQLite.close(prestTemp);
                    try {
                        this.executeSQL("CREATE TABLE `" + this.getPrefix() + "points` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `totalpoints` double, `currentpoints` double);");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PreparedStatement prestLogTemp = null;
                    ResultSet rsLogTemp = null;
                    next = false;
                    try {
                        try {
                            prestLogTemp = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "log`;");
                            rsLogTemp = prestLogTemp.executeQuery();
                            if (rsLogTemp.next()) {
                                next = true;
                                rsLogTemp.getInt("userid");
                                rsLogTemp.getLong("time");
                                rsLogTemp.getString("action");
                                rsLogTemp.getString("itemname");
                                rsLogTemp.getInt("count");
                                rsLogTemp.getDouble("money");
                                rsLogTemp.getDouble("exp");
                            }
                        }
                        catch (Exception exception) {
                            JobsDAOSQLite.close(rsLogTemp);
                            JobsDAOSQLite.close(prestLogTemp);
                            break block69;
                        }
                    }
                    catch (Throwable throwable) {
                        JobsDAOSQLite.close(rsLogTemp);
                        JobsDAOSQLite.close(prestLogTemp);
                        throw throwable;
                    }
                    JobsDAOSQLite.close(rsLogTemp);
                    JobsDAOSQLite.close(prestLogTemp);
                }
                if (!next) {
                    this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "log`;");
                    try {
                        this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (rows != 0) {
                    return;
                }
                HashMap<String, String> tempMap = new HashMap<String, String>();
                PreparedStatement prestJobs = null;
                ResultSet res2 = null;
                try {
                    prestJobs = conn.prepareStatement("SELECT * FROM " + this.getPrefix() + "jobs;");
                    res2 = prestJobs.executeQuery();
                    while (res2.next()) {
                        tempMap.put(res2.getString("player_uuid"), res2.getString("username"));
                    }
                }
                catch (Throwable throwable) {
                    JobsDAOSQLite.close(res2);
                    JobsDAOSQLite.close(prestJobs);
                    throw throwable;
                }
                JobsDAOSQLite.close(res2);
                JobsDAOSQLite.close(prestJobs);
                PreparedStatement prestArchive = null;
                ResultSet res3 = null;
                try {
                    prestArchive = conn.prepareStatement("SELECT * FROM " + this.getPrefix() + "archive;");
                    res3 = prestArchive.executeQuery();
                    while (res3.next()) {
                        tempMap.put(res3.getString("player_uuid"), res3.getString("username"));
                    }
                }
                catch (Throwable throwable) {
                    JobsDAOSQLite.close(res3);
                    JobsDAOSQLite.close(prestArchive);
                    throw throwable;
                }
                JobsDAOSQLite.close(res3);
                JobsDAOSQLite.close(prestArchive);
                try {
                    this.executeSQL("CREATE TABLE `" + this.getPrefix() + "users` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` varchar(36) NOT NULL, `username` varchar(20));");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PreparedStatement prestUsers = null;
                try {
                    prestUsers = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "users` (`player_uuid`, `username`) VALUES (?, ?);");
                    conn.setAutoCommit(false);
                    for (Map.Entry users : tempMap.entrySet()) {
                        prestUsers.setString(1, (String)users.getKey());
                        prestUsers.setString(2, (String)users.getValue());
                        prestUsers.addBatch();
                    }
                    prestUsers.executeBatch();
                    conn.commit();
                    conn.setAutoCommit(true);
                }
                catch (Throwable throwable) {
                    JobsDAOSQLite.close(prestUsers);
                    throw throwable;
                }
                JobsDAOSQLite.close(prestUsers);
                tempPlayerMap = new HashMap<String, PlayerInfo>();
                PreparedStatement prestUsers2 = null;
                ResultSet res4 = null;
                try {
                    prestUsers2 = conn.prepareStatement("SELECT * FROM " + this.getPrefix() + "users;");
                    res4 = prestUsers2.executeQuery();
                    while (res4.next()) {
                        tempPlayerMap.put(res4.getString("player_uuid"), new PlayerInfo(res4.getString("username"), res4.getInt("id"), UUID.fromString(res4.getString("player_uuid")), System.currentTimeMillis()));
                    }
                }
                catch (Throwable throwable) {
                    JobsDAOSQLite.close(res4);
                    JobsDAOSQLite.close(prestUsers2);
                    throw throwable;
                }
                JobsDAOSQLite.close(res4);
                JobsDAOSQLite.close(prestUsers2);
                try {
                    this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs` ADD COLUMN `userid` int;");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PreparedStatement prestJobsT = null;
                try {
                    try {
                        prestJobsT = conn.prepareStatement("UPDATE `" + this.getPrefix() + "jobs` SET `userid` = ? WHERE `player_uuid` = ?;");
                        conn.setAutoCommit(false);
                        for (Map.Entry users : tempPlayerMap.entrySet()) {
                            prestJobsT.setInt(1, ((PlayerInfo)users.getValue()).getID());
                            prestJobsT.setString(2, (String)users.getKey());
                            prestJobsT.addBatch();
                        }
                        prestJobsT.executeBatch();
                        conn.commit();
                        conn.setAutoCommit(true);
                    }
                    catch (Exception users) {
                        JobsDAOSQLite.close(prestJobsT);
                        break block71;
                    }
                }
                catch (Throwable throwable) {
                    JobsDAOSQLite.close(prestJobsT);
                    throw throwable;
                }
                JobsDAOSQLite.close(prestJobsT);
            }
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "jobs_temp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `job` varchar(20), `experience` int, `level` int);");
            }
            catch (Exception users) {
                // empty catch block
            }
            PreparedStatement pst111 = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "jobs`;");
            ResultSet rs11 = pst111.executeQuery();
            Statement insert11 = null;
            while (rs11.next()) {
                String uuid = UUIDUtil.fromBytes(rs11.getBytes("player_uuid")).toString();
                if (uuid == null) continue;
                insert11 = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "jobs_temp` (`userid`, `job`, `experience`, `level`) VALUES (?, ?, ?, ?);");
                insert11.setInt(1, rs11.getInt("userid"));
                insert11.setString(2, rs11.getString("job"));
                insert11.setInt(3, rs11.getInt("experience"));
                insert11.setInt(4, rs11.getInt("level"));
                insert11.execute();
            }
            rs11.close();
            pst111.close();
            if (insert11 != null) {
                insert11.close();
            }
            try {
                this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "jobs`;");
                this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs_temp` RENAME TO `" + this.getPrefix() + "jobs`;");
            }
            catch (Exception uuid) {
                // empty catch block
            }
            try {
                this.executeSQL("ALTER TABLE `" + this.getPrefix() + "archive` ADD COLUMN `userid` int;");
            }
            catch (Exception uuid) {
                // empty catch block
            }
            PreparedStatement prestArchiveT = null;
            try {
                prestArchiveT = conn.prepareStatement("UPDATE `" + this.getPrefix() + "archive` SET `userid` = ? WHERE `player_uuid` = ?;");
                conn.setAutoCommit(false);
                for (Map.Entry users : tempPlayerMap.entrySet()) {
                    prestArchiveT.setInt(1, ((PlayerInfo)users.getValue()).getID());
                    prestArchiveT.setString(2, (String)users.getKey());
                    prestArchiveT.addBatch();
                }
                prestArchiveT.executeBatch();
                conn.commit();
                conn.setAutoCommit(true);
            }
            catch (Throwable throwable) {
                JobsDAOSQLite.close(prestArchiveT);
                throw throwable;
            }
            JobsDAOSQLite.close(prestArchiveT);
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive_temp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `job` varchar(20), `experience` int, `level` int);");
            }
            catch (Exception users) {
                // empty catch block
            }
            Statement pstArchive = null;
            ResultSet rsArchive = null;
            Statement insertArchive = null;
            try {
                try {
                    pstArchive = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "archive`;");
                    rsArchive = pstArchive.executeQuery();
                    while (rsArchive.next()) {
                        String uuid = UUIDUtil.fromBytes(rsArchive.getBytes("player_uuid")).toString();
                        if (uuid == null) continue;
                        insertArchive = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "archive_temp` (`userid`, `job`, `experience`, `level`) VALUES (?, ?, ?, ?);");
                        insertArchive.setInt(1, rsArchive.getInt("userid"));
                        insertArchive.setString(2, rsArchive.getString("job"));
                        insertArchive.setInt(3, rsArchive.getInt("experience"));
                        insertArchive.setInt(4, rsArchive.getInt("level"));
                        insertArchive.execute();
                    }
                }
                catch (Exception uuid) {
                    if (rsArchive != null) {
                        rsArchive.close();
                    }
                    if (insertArchive != null) {
                        insertArchive.close();
                    }
                    if (pstArchive != null) {
                        pstArchive.close();
                    }
                    break block73;
                }
            }
            catch (Throwable throwable) {
                if (rsArchive != null) {
                    rsArchive.close();
                }
                if (insertArchive != null) {
                    insertArchive.close();
                }
                if (pstArchive != null) {
                    pstArchive.close();
                }
                throw throwable;
            }
            if (rsArchive != null) {
                rsArchive.close();
            }
            if (insertArchive != null) {
                insertArchive.close();
            }
            if (pstArchive != null) {
                pstArchive.close();
            }
        }
        this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "archive`;");
        try {
            this.executeSQL("ALTER TABLE `" + this.getPrefix() + "archive_temp` RENAME TO `" + this.getPrefix() + "archive`;");
        }
        catch (Exception uuid) {
            // empty catch block
        }
        PreparedStatement prestPreLog = null;
        try {
            this.executeSQL("ALTER TABLE `" + this.getPrefix() + "log` ADD COLUMN `userid` int;");
            prestPreLog = conn.prepareStatement("UPDATE `" + this.getPrefix() + "log` SET `userid` = ? WHERE `player_uuid` = ?;");
            conn.setAutoCommit(false);
            for (Map.Entry users : tempPlayerMap.entrySet()) {
                prestPreLog.setInt(1, ((PlayerInfo)users.getValue()).getID());
                prestPreLog.setString(2, (String)users.getKey());
                prestPreLog.addBatch();
            }
            prestPreLog.executeBatch();
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (Throwable throwable) {
            JobsDAOSQLite.close(prestPreLog);
            throw throwable;
        }
        JobsDAOSQLite.close(prestPreLog);
    }

    @Override
    protected synchronized void checkUpdate10() {
        this.createDefaultBlockProtection();
    }

    @Override
    protected synchronized void checkUpdate11() {
        block8: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to SQLITE!");
                return;
            }
            try {
                this.executeSQL("ALTER TABLE `" + this.getPrefix() + "users` ADD COLUMN `seen` bigint;");
            }
            catch (Exception e) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("UPDATE `" + this.getPrefix() + "users` SET `seen` = ?;");
                    prest.setLong(1, System.currentTimeMillis());
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAOSQLite.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAOSQLite.close(prest);
                throw throwable;
            }
            JobsDAOSQLite.close(prest);
        }
    }

    private boolean createDefaultExploreBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "explore` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `worldname` varchar(64), `chunkX` int, `chunkZ` int, `playerName` varchar(32));");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultPointsBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "points` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `totalpoints` double, `currentpoints` double);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultUsersBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "users` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `player_uuid` varchar(36) NOT NULL, `username` varchar(20), `seen` bigint);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean createDefaultLogBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean createDefaultArchiveBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `job` varchar(20), `experience` int, `level` int);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultJobsBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "jobs` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `job` varchar(20), `experience` int, `level` int);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultBlockProtection() {
        try {
            this.executeSQL("CREATE TABLE IF NOT EXISTS `" + this.getPrefix() + "blocks` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `world` varchar(36) NOT NULL, `x` int, `y` int, `z` int, `recorded` bigint, `resets` bigint);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultLimitBase() {
        try {
            this.executeSQL("CREATE TABLE IF NOT EXISTS `" + this.getPrefix() + "limits` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `userid` int, `type` varchar(36), `collected` double, `started` bigint);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean dropDataBase(String name) {
        try {
            this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + name + "`;");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }
}

