/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.container;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.ActionInfo;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.container.BoostMultiplier;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.DisplayMethod;
import com.gamingmesh.jobs.container.JobCommands;
import com.gamingmesh.jobs.container.JobConditions;
import com.gamingmesh.jobs.container.JobInfo;
import com.gamingmesh.jobs.container.JobItems;
import com.gamingmesh.jobs.container.JobLimitedItems;
import com.gamingmesh.jobs.container.JobPermission;
import com.gamingmesh.jobs.resources.jfep.Parser;
import com.gamingmesh.jobs.stuff.ChatColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class Job {
    private EnumMap<ActionType, List<JobInfo>> jobInfo = new EnumMap(ActionType.class);
    private List<JobPermission> jobPermissions;
    private List<JobCommands> jobCommands;
    private List<JobConditions> jobConditions;
    private List<JobItems> jobItems;
    private List<JobLimitedItems> jobLimitedItems;
    private String jobName = "N/A";
    private String jobShortName;
    private String description;
    private ChatColor jobColour;
    private Parser maxExpEquation;
    private DisplayMethod displayMethod;
    private int maxLevel;
    private int vipmaxLevel = 0;
    private Integer maxSlots;
    private List<String> CmdOnJoin = new ArrayList<String>();
    private List<String> CmdOnLeave = new ArrayList<String>();
    private ItemStack GUIitem;
    private int totalPlayers = -1;
    private Double bonus = null;
    private BoostMultiplier boost = new BoostMultiplier();
    private String bossbar;

    public Job(String jobName, String jobShortName, String description, ChatColor jobColour, Parser maxExpEquation, DisplayMethod displayMethod, int maxLevel, int vipmaxLevel, Integer maxSlots, List<JobPermission> jobPermissions, List<JobCommands> jobCommands, List<JobConditions> jobConditions, List<JobItems> jobItems, List<JobLimitedItems> jobLimitedItems, List<String> CmdOnJoin, List<String> CmdOnLeave, ItemStack GUIitem, String bossbar) {
        this.jobName = jobName;
        this.jobShortName = jobShortName;
        this.description = description;
        this.jobColour = jobColour;
        this.maxExpEquation = maxExpEquation;
        this.displayMethod = displayMethod;
        this.maxLevel = maxLevel;
        this.vipmaxLevel = vipmaxLevel;
        this.maxSlots = maxSlots;
        this.jobPermissions = jobPermissions;
        this.jobCommands = jobCommands;
        this.jobConditions = jobConditions;
        this.jobItems = jobItems;
        this.jobLimitedItems = jobLimitedItems;
        this.CmdOnJoin = CmdOnJoin;
        this.CmdOnLeave = CmdOnLeave;
        this.GUIitem = GUIitem;
        this.bossbar = bossbar;
    }

    public void addBoost(CurrencyType type, double Point) {
        this.boost.add(type, Point - 1.0);
    }

    public void setBoost(BoostMultiplier BM) {
        this.boost = BM;
    }

    public BoostMultiplier getBoost() {
        return this.boost;
    }

    public boolean isSame(Job job) {
        if (job == null) {
            return false;
        }
        return this.getName().equalsIgnoreCase(job.getName());
    }

    public int getTotalPlayers() {
        if (this.totalPlayers == -1) {
            this.totalPlayers = Jobs.getJobsDAO().getTotalPlayerAmountByJobName(this.jobName);
            this.updateBonus();
        }
        return this.totalPlayers;
    }

    public void updateTotalPlayers() {
        this.totalPlayers = Jobs.getJobsDAO().getTotalPlayerAmountByJobName(this.jobName);
        this.updateBonus();
    }

    public void updateBonus() {
        if (!Jobs.getGCManager().useDynamicPayment) {
            return;
        }
        Parser eq = Jobs.getGCManager().DynamicPaymentEquation;
        eq.setVariable("totalworkers", Jobs.getJobsDAO().getTotalPlayers());
        eq.setVariable("totaljobs", Jobs.getJobs().size());
        eq.setVariable("jobstotalplayers", this.getTotalPlayers());
        double now = eq.getValue();
        if (now > Jobs.getGCManager().DynamicPaymentMaxBonus) {
            now = Jobs.getGCManager().DynamicPaymentMaxBonus;
        }
        if (now < Jobs.getGCManager().DynamicPaymentMaxPenalty * -1.0) {
            now = Jobs.getGCManager().DynamicPaymentMaxPenalty * -1.0;
        }
        this.bonus = now / 100.0;
    }

    public double getBonus() {
        if (this.bonus == null) {
            this.updateBonus();
        }
        return this.bonus == null ? 0.0 : this.bonus;
    }

    public List<String> getCmdOnJoin() {
        return this.CmdOnJoin;
    }

    public List<String> getCmdOnLeave() {
        return this.CmdOnLeave;
    }

    public ItemStack getGuiItem() {
        return this.GUIitem;
    }

    public void setJobInfo(ActionType type, List<JobInfo> info2) {
        this.jobInfo.put(type, info2);
    }

    public List<JobInfo> getJobInfo(ActionType type) {
        return Collections.unmodifiableList(this.jobInfo.get((Object)type));
    }

    public EnumMap<ActionType, List<JobInfo>> getJobInfoList() {
        return this.jobInfo;
    }

    public JobInfo getJobInfo(ActionInfo action, int level) {
        for (JobInfo info2 : this.getJobInfo(action.getType())) {
            if (!info2.getName().equalsIgnoreCase(action.getName()) && !info2.getName().equalsIgnoreCase(action.getNameWithSub())) continue;
            if (!info2.isInLevelRange(level)) break;
            return info2;
        }
        return null;
    }

    public String getName() {
        return this.jobName;
    }

    public String getShortName() {
        return this.jobShortName;
    }

    public String getDescription() {
        return this.description;
    }

    public ChatColor getChatColor() {
        return this.jobColour;
    }

    public Parser getMaxExpEquation() {
        return this.maxExpEquation;
    }

    public double getMaxExp(Map<String, Double> param) {
        for (Map.Entry<String, Double> temp : param.entrySet()) {
            this.maxExpEquation.setVariable(temp.getKey(), temp.getValue());
        }
        return this.maxExpEquation.getValue();
    }

    public DisplayMethod getDisplayMethod() {
        return this.displayMethod;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getVipMaxLevel() {
        return this.vipmaxLevel;
    }

    public Integer getMaxSlots() {
        return this.maxSlots;
    }

    public List<JobPermission> getPermissions() {
        return Collections.unmodifiableList(this.jobPermissions);
    }

    public List<JobCommands> getCommands() {
        return Collections.unmodifiableList(this.jobCommands);
    }

    public List<JobConditions> getConditions() {
        return Collections.unmodifiableList(this.jobConditions);
    }

    public List<JobItems> getItems() {
        return Collections.unmodifiableList(this.jobItems);
    }

    public List<JobLimitedItems> getLimitedItems() {
        return Collections.unmodifiableList(this.jobLimitedItems);
    }

    public String getBossbar() {
        return this.bossbar;
    }

    public void setBossbar(String bossbar) {
        this.bossbar = bossbar;
    }
}

