/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.BoostMultiplier;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.Schedule;
import com.gamingmesh.jobs.stuff.ChatColor;
import com.gamingmesh.jobs.stuff.TimeManage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ScheduleManager {
    private Jobs plugin;
    private int autoTimerBukkitId = -1;
    private Runnable autoTimer = new Runnable(){

        @Override
        public void run() {
            try {
                ScheduleManager.this.scheduler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public ScheduleManager(Jobs plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.autoTimerBukkitId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, this.autoTimer, 20L, 600L);
    }

    public void cancel() {
        if (this.autoTimerBukkitId != -1) {
            Bukkit.getScheduler().cancelTask(this.autoTimerBukkitId);
        }
    }

    public int getDateByInt() {
        return TimeManage.timeInInt();
    }

    private boolean scheduler() {
        if (Jobs.getGCManager().BoostSchedule.isEmpty() || !Jobs.getGCManager().useGlobalBoostScheduler) {
            return false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Date date = new Date();
        String currenttime = dateFormat.format(date);
        int Current = Integer.valueOf(currenttime.replace(":", ""));
        String CurrentDayName = ScheduleManager.GetWeekDay();
        for (Schedule one : Jobs.getGCManager().BoostSchedule) {
            int From = one.GetFrom();
            int Until = one.GetUntil();
            List<String> days = one.GetDays();
            if (one.isStarted() && one.getBroadcastInfoOn() < System.currentTimeMillis() && one.GetBroadcastInterval() > 0) {
                one.setBroadcastInfoOn(System.currentTimeMillis() + (long)(one.GetBroadcastInterval() * 60 * 1000));
                for (String oneMsg : one.GetMessageToBroadcast()) {
                    Bukkit.broadcastMessage((String)oneMsg);
                }
            }
            if ((one.isNextDay() && (Current >= From && Current < Until || Current >= one.GetNextFrom() && Current < one.GetNextUntil()) && !one.isStarted() || !one.isNextDay() && Current >= From && Current < Until) && (days.contains(CurrentDayName) || days.contains("all")) && !one.isStarted()) {
                if (one.isBroadcastOnStart()) {
                    if (one.GetMessageOnStart().size() == 0) {
                        Bukkit.broadcastMessage((String)Jobs.getLanguage().getMessage("message.boostStarted"));
                    } else {
                        for (String oneMsg : one.GetMessageOnStart()) {
                            Bukkit.broadcastMessage((String)oneMsg);
                        }
                    }
                }
                for (Job onejob : one.GetJobs()) {
                    onejob.setBoost(one.getBoost());
                }
                one.setBroadcastInfoOn(System.currentTimeMillis() + (long)(one.GetBroadcastInterval() * 60 * 1000));
                one.setStarted(true);
                one.setStoped(false);
                break;
            }
            if ((!one.isNextDay() || Current <= one.GetNextUntil() || Current >= one.GetFrom() || one.isStoped()) && (one.isNextDay() || Current <= Until || !days.contains(CurrentDayName) && !days.contains("all")) || one.isStoped()) continue;
            if (one.isBroadcastOnStop()) {
                if (one.GetMessageOnStop().size() == 0) {
                    Bukkit.broadcastMessage((String)Jobs.getLanguage().getMessage("message.boostStoped"));
                } else {
                    for (String oneMsg : one.GetMessageOnStop()) {
                        Bukkit.broadcastMessage((String)oneMsg);
                    }
                }
            }
            for (Job onejob : one.GetJobs()) {
                onejob.setBoost(new BoostMultiplier());
            }
            one.setStoped(true);
            one.setStarted(false);
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ScheduleManager.this.scheduler();
            }
        }, 600L);
        return true;
    }

    public static String GetWeekDay() {
        Calendar c = Calendar.getInstance();
        int dayOfWeek = c.get(7);
        switch (dayOfWeek) {
            case 2: {
                return "monday";
            }
            case 3: {
                return "tuesday";
            }
            case 4: {
                return "wednesday";
            }
            case 5: {
                return "thursday";
            }
            case 6: {
                return "friday";
            }
            case 7: {
                return "saturday";
            }
            case 1: {
                return "sunday";
            }
        }
        return "all";
    }

    public void load() {
        File f = new File(this.plugin.getDataFolder(), "schedule.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        conf.options().copyDefaults(true);
        if (!conf.contains("Boost")) {
            return;
        }
        ArrayList sections = new ArrayList(conf.getConfigurationSection("Boost").getKeys(false));
        for (String OneSection : sections) {
            ConfigurationSection path = conf.getConfigurationSection("Boost." + OneSection);
            if (!path.contains("Enabled") || !conf.getConfigurationSection("Boost." + OneSection).getBoolean("Enabled")) continue;
            Schedule sched = new Schedule();
            sched.setName(OneSection);
            if (!path.contains("From") || !path.getString("From").contains(":") || !path.contains("Until") || !path.getString("Until").contains(":") || !path.contains("Days") || !path.isList("Days") || !path.contains("Jobs") || !path.isList("Jobs")) continue;
            sched.setDays(path.getStringList("Days"));
            sched.setJobs(path.getStringList("Jobs"));
            sched.setFrom(Integer.valueOf(path.getString("From").replace(":", "")));
            sched.setUntil(Integer.valueOf(path.getString("Until").replace(":", "")));
            if (path.contains("MessageOnStart") && path.isList("MessageOnStart")) {
                sched.setMessageOnStart(path.getStringList("MessageOnStart"), path.getString("From"), path.getString("Until"));
            }
            if (path.contains("BroadcastOnStart")) {
                sched.setBroadcastOnStart(path.getBoolean("BroadcastOnStart"));
            }
            if (path.contains("MessageOnStop") && path.isList("MessageOnStop")) {
                sched.setMessageOnStop(path.getStringList("MessageOnStop"), path.getString("From"), path.getString("Until"));
            }
            if (path.contains("BroadcastOnStop")) {
                sched.setBroadcastOnStop(path.getBoolean("BroadcastOnStop"));
            }
            if (path.contains("BroadcastInterval")) {
                sched.setBroadcastInterval(path.getInt("BroadcastInterval"));
            }
            if (path.contains("BroadcastMessage") && path.isList("BroadcastMessage")) {
                sched.setMessageToBroadcast(path.getStringList("BroadcastMessage"), path.getString("From"), path.getString("Until"));
            }
            if (path.contains("Exp") && path.isDouble("Exp")) {
                sched.setBoost(CurrencyType.EXP, path.getDouble("Exp", 0.0));
            }
            if (path.contains("Money") && path.isDouble("Money")) {
                sched.setBoost(CurrencyType.MONEY, path.getDouble("Money", 0.0));
            }
            if (path.contains("Points") && path.isDouble("Points")) {
                sched.setBoost(CurrencyType.POINTS, path.getDouble("Points", 0.0));
            }
            Jobs.getGCManager().BoostSchedule.add(sched);
        }
        Bukkit.getConsoleSender().sendMessage((Object)((Object)ChatColor.YELLOW) + "[Jobs] Loaded " + Jobs.getGCManager().BoostSchedule.size() + " schedulers!");
    }
}

