/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.config.CommentedYamlConfiguration;
import com.gamingmesh.jobs.container.CurrencyLimit;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.LocaleReader;
import com.gamingmesh.jobs.container.Schedule;
import com.gamingmesh.jobs.dao.JobsDAOMySQL;
import com.gamingmesh.jobs.dao.JobsDAOSQLite;
import com.gamingmesh.jobs.resources.jfep.Parser;
import com.gamingmesh.jobs.stuff.ChatColor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GeneralConfigManager {
    private Jobs plugin;
    public List<Integer> BroadcastingLevelUpLevels = new ArrayList<Integer>();
    protected Locale locale;
    protected int savePeriod;
    protected boolean economyAsync;
    protected boolean isBroadcastingSkillups;
    protected boolean isBroadcastingLevelups;
    protected boolean payInCreative;
    protected boolean payExploringWhenFlying;
    protected boolean addXpPlayer;
    protected boolean hideJobsWithoutPermission;
    protected int maxJobs;
    protected boolean payNearSpawner;
    protected boolean modifyChat;
    public String modifyChatPrefix;
    public String modifyChatSuffix;
    public String modifyChatSeparator;
    protected int economyBatchDelay;
    protected boolean saveOnDisconnect;
    protected boolean MultiServerCompatability;
    public boolean LocalOfflinePlayersData;
    public boolean MythicMobsEnabled;
    public boolean LoggingUse;
    public boolean PaymentMethodsMoney;
    public boolean PaymentMethodsPoints;
    public boolean PaymentMethodsExp;
    public int getSelectionTooldID;
    public HashMap<CurrencyType, CurrencyLimit> currencyLimitUse = new HashMap();
    public boolean PayForRenaming;
    public boolean PayForEachCraft;
    public boolean SignsEnabled;
    public boolean SignsColorizeJobName;
    public boolean ShowToplistInScoreboard;
    public boolean useGlobalTimer;
    public boolean useCoreProtect;
    public boolean BlockPlaceUse;
    public boolean EnableAnounceMessage;
    public boolean useSilkTouchProtection;
    public boolean UseCustomNames;
    public boolean UseJobsBrowse;
    public boolean PreventSlimeSplit;
    public boolean PreventMagmaCubeSplit;
    public int globalblocktimer;
    public int CowMilkingTimer;
    public int CoreProtectInterval;
    public int BlockPlaceInterval;
    public int InfoUpdateInterval;
    public Double TreeFellerMultiplier;
    public Double gigaDrillMultiplier;
    public Double superBreakerMultiplier;
    public String localeString = "EN";
    public boolean useBlockProtection;
    public int BlockProtectionDays;
    public boolean useMinimumOveralPayment;
    public boolean useMinimumOveralPoints;
    public boolean useBreederFinder = false;
    private boolean useTnTFinder = false;
    public boolean CancelCowMilking;
    public boolean fixAtMaxLevel;
    public boolean ToggleActionBar;
    public boolean TitleChangeChat;
    public boolean TitleChangeActionBar;
    public boolean LevelChangeChat;
    public boolean LevelChangeActionBar;
    public boolean SoundLevelupUse;
    public boolean SoundTitleChangeUse;
    public boolean UseServerAccount;
    public boolean EmptyServerAcountChat;
    public boolean EmptyServerAcountActionBar;
    public boolean ActionBarsMessageByDefault;
    public boolean ShowTotalWorkers;
    public boolean ShowPenaltyBonus;
    public boolean useDynamicPayment;
    public boolean useGlobalBoostScheduler;
    public boolean JobsGUIOpenOnBrowse;
    public boolean JobsGUIShowChatBrowse;
    public boolean JobsGUISwitcheButtons;
    public boolean JobsGUIOpenOnJoin;
    public ItemStack guiBackButton;
    public ItemStack guiFiller;
    public Integer levelLossPercentage;
    public Integer SoundLevelupVolume;
    public Integer SoundLevelupPitch;
    public Integer SoundTitleChangeVolume;
    public Integer SoundTitleChangePitch;
    public Integer ToplistInScoreboardInterval;
    public double MinimumOveralPaymentLimit;
    public double MinimumOveralPointsLimit;
    public boolean MonsterDamageUse = false;
    public double MonsterDamagePercentage;
    public double DynamicPaymentMaxPenalty;
    public double DynamicPaymentMaxBonus;
    public double TaxesAmount;
    public String SoundLevelupSound;
    public String SoundTitleChangeSound;
    public String ServerAcountName;
    public String ServertaxesAcountName;
    public ArrayList<String> keys;
    public String storageMethod;
    public boolean hideJobsInfoWithoutPermission;
    public boolean UseTaxes;
    public boolean TransferToServerAccount;
    public boolean TakeFromPlayersPayment;
    public int AutoJobJoinDelay;
    public boolean AutoJobJoinUse;
    public boolean BossBarEnabled;
    public boolean BossBarShowOnEachAction;
    public int BossBarTimer;
    public boolean BossBarsMessageByDefault;
    public Parser DynamicPaymentEquation;
    public boolean DisabledWorldsUse;
    public List<String> DisabledWorldsList = new ArrayList<String>();
    public List<Schedule> BoostSchedule = new ArrayList<Schedule>();
    public HashMap<String, List<String>> commandArgs = new HashMap();
    public boolean DBCleaningJobsUse;
    public int DBCleaningJobsLvl;
    public boolean DBCleaningUsersUse;
    public int DBCleaningUsersDays;

    public HashMap<String, List<String>> getCommandArgs() {
        return this.commandArgs;
    }

    public CurrencyLimit getLimit(CurrencyType type) {
        return this.currencyLimitUse.get((Object)type);
    }

    public GeneralConfigManager(Jobs plugin) {
        this.plugin = plugin;
    }

    public void setBreederFinder(boolean state) {
        this.useBreederFinder = state;
    }

    public boolean isUseBreederFinder() {
        return this.useBreederFinder;
    }

    public void setTntFinder(boolean state) {
        this.useTnTFinder = state;
    }

    public boolean isUseTntFinder() {
        return this.useTnTFinder;
    }

    public synchronized int getSavePeriod() {
        return this.savePeriod;
    }

    public synchronized boolean isEconomyAsync() {
        return this.economyAsync;
    }

    public synchronized boolean isBroadcastingSkillups() {
        return this.isBroadcastingSkillups;
    }

    public synchronized boolean isBroadcastingLevelups() {
        return this.isBroadcastingLevelups;
    }

    public synchronized boolean payInCreative() {
        return this.payInCreative;
    }

    public synchronized boolean payExploringWhenFlying() {
        return this.payExploringWhenFlying;
    }

    public synchronized boolean addXpPlayer() {
        return this.addXpPlayer;
    }

    public synchronized boolean getHideJobsWithoutPermission() {
        return this.hideJobsWithoutPermission;
    }

    public synchronized int getMaxJobs() {
        return this.maxJobs;
    }

    public synchronized boolean payNearSpawner() {
        return this.payNearSpawner;
    }

    public synchronized boolean getModifyChat() {
        return this.modifyChat;
    }

    public String getModifyChatPrefix() {
        return this.modifyChatPrefix;
    }

    public String getModifyChatSuffix() {
        return this.modifyChatSuffix;
    }

    public String getModifyChatSeparator() {
        return this.modifyChatSeparator;
    }

    public synchronized int getEconomyBatchDelay() {
        return this.economyBatchDelay;
    }

    public synchronized boolean saveOnDisconnect() {
        return this.saveOnDisconnect;
    }

    public synchronized boolean MultiServerCompatability() {
        return this.MultiServerCompatability;
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public boolean canPerformActionInWorld(Player player) {
        if (player == null) {
            return true;
        }
        return this.canPerformActionInWorld(player.getWorld());
    }

    public boolean canPerformActionInWorld(World world) {
        if (world == null) {
            return true;
        }
        if (!this.DisabledWorldsUse) {
            return true;
        }
        return this.canPerformActionInWorld(world.getName());
    }

    public boolean canPerformActionInWorld(String world) {
        if (world == null) {
            return true;
        }
        if (!this.DisabledWorldsUse) {
            return true;
        }
        if (this.DisabledWorldsList.isEmpty()) {
            return true;
        }
        return !this.DisabledWorldsList.contains(world);
    }

    public synchronized void reload() {
        this.loadGeneralSettings();
        Jobs.getJobsDAO().cleanJobs();
        Jobs.getJobsDAO().cleanUsers();
        Jobs.setLanguageManager(this.plugin);
        Jobs.getLanguageManager().load();
        Jobs.setTitleManager(this.plugin);
        Jobs.gettitleManager().load();
        Jobs.setRestrictedAreaManager(this.plugin);
        Jobs.getRestrictedAreaManager().load();
        Jobs.setRestrictedBlockManager(this.plugin);
        Jobs.getRestrictedBlockManager().load();
        Jobs.setNameTranslatorManager(this.plugin);
        Jobs.getNameTranslatorManager().load();
        Jobs.setSignUtil(this.plugin);
        Jobs.getSignUtil().LoadSigns();
        Jobs.setScheduleManager(this.plugin);
        Jobs.setShopManager(this.plugin);
        Jobs.getShopManager().load();
    }

    private synchronized void loadGeneralSettings() {
        File f = new File(this.plugin.getDataFolder(), "generalConfig.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        CommentedYamlConfiguration write = new CommentedYamlConfiguration();
        LocaleReader c = new LocaleReader(conf, write);
        StringBuilder header = new StringBuilder();
        header.append("General configuration.");
        header.append(System.getProperty("line.separator"));
        header.append("  The general configuration for the jobs plugin mostly includes how often the plugin");
        header.append(System.getProperty("line.separator"));
        header.append("saves user data (when the user is in the game), the storage method, whether");
        header.append(System.getProperty("line.separator"));
        header.append("to broadcast a message to the server when a user goes up a skill level.");
        header.append(System.getProperty("line.separator"));
        header.append("  It also allows admins to set the maximum number of jobs a player can have at");
        header.append(System.getProperty("line.separator"));
        header.append("any one time.");
        header.append(System.getProperty("line.separator"));
        c.getC().options().copyDefaults(true);
        c.getW().options().header(header.toString());
        c.getW().addComment("locale-language", "Default language.", "Example: en, ru", "File in locale folder with same name should exist. Example: messages_ru.yml");
        this.localeString = c.get("locale-language", "en");
        try {
            int i = this.localeString.indexOf(95);
            this.locale = i == -1 ? new Locale(this.localeString) : new Locale(this.localeString.substring(0, i), this.localeString.substring(i + 1));
        }
        catch (IllegalArgumentException e) {
            this.locale = Locale.getDefault();
            Jobs.getPluginLogger().warning("Invalid locale \"" + this.localeString + "\" defaulting to " + this.locale.getLanguage());
        }
        c.getW().addComment("storage-method", "storage method, can be MySQL, sqlite");
        this.storageMethod = c.get("storage-method", "sqlite");
        if (this.storageMethod.equalsIgnoreCase("mysql")) {
            this.startMysql();
        } else if (this.storageMethod.equalsIgnoreCase("sqlite")) {
            this.startSqlite();
        } else {
            Jobs.getPluginLogger().warning("Invalid storage method!  Changing method to sqlite!");
            c.getC().set("storage-method", (Object)"sqlite");
            this.startSqlite();
        }
        c.getW().addComment("mysql-username", "Requires Mysql.");
        c.get("mysql-username", "root");
        c.get("mysql-password", "");
        c.get("mysql-hostname", "localhost:3306");
        c.get("mysql-database", "minecraft");
        c.get("mysql-table-prefix", "jobs_");
        c.getW().addComment("save-period", "How often in minutes you want it to save.  This must be a non-zero number");
        c.get("save-period", 10);
        if (c.getC().getInt("save-period") <= 0) {
            Jobs.getPluginLogger().severe("Save period must be greater than 0!  Defaulting to 10 minutes!");
            c.getC().set("save-period", (Object)10);
        }
        this.savePeriod = c.getC().getInt("save-period");
        c.getW().addComment("save-on-disconnect", "Should player data be saved on disconnect?", "Player data is always periodically auto-saved and autosaved during a clean shutdown.", "Only enable this if you have a multi-server setup, or have a really good reason for enabling this.", "Turning this on will decrease database performance.");
        this.saveOnDisconnect = c.get("save-on-disconnect", false);
        c.getW().addComment("selectionTool", "Tool used when selecting bounds for restricted area");
        this.getSelectionTooldID = c.get("selectionTool", 294);
        if (Material.getMaterial((int)Jobs.getGCManager().getSelectionTooldID) == null) {
            this.getSelectionTooldID = 294;
        }
        c.getW().addComment("MultiServerCompatability", "Enable if you are using one data base for multiple servers across bungee network", "This will force to load players data every time he is logging in to have most up to date data instead of having preloaded data", "This will enable automaticaly save-on-disconnect feature");
        this.MultiServerCompatability = c.get("MultiServerCompatability", false);
        if (this.MultiServerCompatability) {
            this.saveOnDisconnect = true;
        }
        c.getW().addComment("Optimizations.DBCleaning.Jobs.Use", "Warning!!! before enabling this feature, please make data base backup, just in case there will be some issues with data base cleaning", "When set to true, jobs data base will be cleaned on each startup to avoid having not used jobs", "keep in mind that this will only clean actual jobs, but not recorded players");
        this.DBCleaningJobsUse = c.get("Optimizations.DBCleaning.Jobs.Use", false);
        c.getW().addComment("Optimizations.DBCleaning.Jobs.Level", "Any one who has jobs level equal or less then set, hies job will be removed from data base");
        this.DBCleaningJobsLvl = c.get("Optimizations.DBCleaning.Jobs.Level", 1);
        c.getW().addComment("Optimizations.DBCleaning.Users.Use", "Warning!!! before enabling this feature, please make data base backup, just in case there will be some issues with data base cleaning", "When set to true, data base will be cleaned on each startup from user data to avoid having old player data");
        this.DBCleaningUsersUse = c.get("Optimizations.DBCleaning.Users.Use", false);
        c.getW().addComment("Optimizations.DBCleaning.Users.Days", "Any one who not playied for defined amount of days, will be removed from data base");
        this.DBCleaningUsersDays = c.get("Optimizations.DBCleaning.Users.Days", 60);
        c.getW().addComment("Optimizations.AutoJobJoin.Use", "Use or not auto join jobs feature", "If you are not using auto join feature, keep it disabled");
        this.AutoJobJoinUse = c.get("Optimizations.AutoJobJoin.Use", false);
        c.getW().addComment("Optimizations.AutoJobJoin.Delay", "Delay in seconds to perform auto join job if used after player joins server", "If you using offline server, try to keep it slightly more than your login plugin gives time to enter password", "For player to auto join job add permission node jobs.autojoin.[jobname]", "Op players are ignored");
        this.AutoJobJoinDelay = c.get("Optimizations.AutoJobJoin.Delay", 15);
        c.getW().addComment("Optimizations.UseLocalOfflinePlayersData", "With this set to true, offline player data will be taken from local player data files", "This will eliminate small lag spikes when request is being send to mojangs servers for offline players data", "Theroticali this should work without issues, but if you havving some, just disable", "But then you can feal some small (100-200ms) lag spikes while performings some jobs commands");
        this.LocalOfflinePlayersData = c.get("Optimizations.UseLocalOfflinePlayersData", true);
        c.getW().addComment("Optimizations.DisabledWorlds.Use", "By setting this to true, Jobs plugin will be disabled in given worlds", "Only commands can be performed from disabled worlds with jobs.disabledworld.commands permission node");
        this.DisabledWorldsUse = c.get("Optimizations.DisabledWorlds.Use", false);
        this.DisabledWorldsList = c.getStringList("Optimizations.DisabledWorlds.List", Arrays.asList(((World)Bukkit.getWorlds().get(0)).getName()));
        c.getW().addComment("Logging.Use", "With this set to true all players jobs actions will be logged to database for easy to see statistics", "This is still in development and in feature it will expand");
        this.LoggingUse = c.get("Logging.Use", false);
        c.getW().addComment("broadcast.on-skill-up.use", "Do all players get a message when somone goes up a skill level?");
        this.isBroadcastingSkillups = c.get("broadcast.on-skill-up.use", false);
        c.getW().addComment("broadcast.on-level-up.use", "Do all players get a message when somone goes up a level?");
        this.isBroadcastingLevelups = c.get("broadcast.on-level-up.use", false);
        c.getW().addComment("broadcast.on-level-up.levels", "For what levels you want to broadcast message? Keep it at 0 if you want for all of them");
        this.BroadcastingLevelUpLevels = c.getIntList("broadcast.on-level-up.levels", Arrays.asList(0));
        c.getW().addComment("max-jobs", "Maximum number of jobs a player can join.", "Use 0 for no maximum");
        this.maxJobs = c.get("max-jobs", 3);
        c.getW().addComment("hide-jobs-without-permission", "Hide jobs from player if they lack the permission to join the job");
        this.hideJobsWithoutPermission = c.get("hide-jobs-without-permission", false);
        c.getW().addComment("hide-jobsinfo-without-permission", "Hide jobs info from player if they lack the permission to join the job");
        this.hideJobsInfoWithoutPermission = c.get("hide-jobsinfo-without-permission", false);
        c.getW().addComment("enable-pay-near-spawner", "Option to allow payment to be made when killing mobs from a spawner");
        this.payNearSpawner = c.get("enable-pay-near-spawner", false);
        c.getW().addComment("enable-pay-creative", "Option to allow payment to be made in creative mode");
        this.payInCreative = c.get("enable-pay-creative", false);
        c.getW().addComment("enable-pay-for-exploring-when-flying", "Option to allow payment to be made for exploring when player flyies");
        this.payExploringWhenFlying = c.get("enable-pay-for-exploring-when-flying", false);
        c.getW().addComment("add-xp-player", "Adds the Jobs xp recieved to the player's Minecraft XP bar");
        this.addXpPlayer = c.get("add-xp-player", false);
        c.getW().addComment("modify-chat", "Modifys chat to add chat titles.  If you're using a chat manager, you may add the tag {jobs} to your chat format and disable this.");
        this.modifyChat = c.get("modify-chat", true);
        this.modifyChatPrefix = c.get("modify-chat-prefix", "&c[", true);
        this.modifyChatSuffix = c.get("modify-chat-suffix", "&c]", true);
        this.modifyChatSeparator = c.get("modify-chat-separator", " ", true);
        c.getW().addComment("UseCustomNames", "Do you want to use custom item/block/mob/enchant/color names", "With this set to true names like Stone:1 will be translated to Granite", "Name list is in TranslatableWords.yml file");
        this.UseCustomNames = c.get("UseCustomNames", true);
        c.getW().addComment("economy-batch-delay", "Changes how often, in seconds, players are paid out.  Default is 5 seconds.", "Setting this too low may cause tick lag.  Increase this to improve economy performance (at the cost of delays in payment)");
        this.economyBatchDelay = c.get("economy-batch-delay", 5);
        c.getW().addComment("economy-async", "Enable async economy calls.", "Disable this if you have issues with payments or your plugin is not thread safe.");
        this.economyAsync = c.get("economy-async", true);
        c.getW().addComment("Economy.PaymentMethods", "By disabling one of thies, players no longer will get particular payment.", "Usefull for removing particular payment method without editing whole jobConfig file");
        this.PaymentMethodsMoney = c.get("Economy.PaymentMethods.Money", true);
        this.PaymentMethodsPoints = c.get("Economy.PaymentMethods.Points", true);
        this.PaymentMethodsExp = c.get("Economy.PaymentMethods.Exp", true);
        c.getW().addComment("Economy.MinimumOveralPayment.use", "Determines minimum payment. In example if player uses McMMO treefeller and earns only 20%, but at same time he gets 25% penalty from dynamic payment. He can 'get' negative amount of money", "This will limit it to particular percentage", "Works only when original payment is above 0");
        this.useMinimumOveralPayment = c.get("Economy.MinimumOveralPayment.use", true);
        this.MinimumOveralPaymentLimit = c.get("Economy.MinimumOveralPayment.limit", 0.1);
        c.getW().addComment("Economy.MinimumOveralPoints.use", "Determines minimum payment. In example if player uses McMMO treefeller and earns only 20%, but at same time he gets 25% penalty from dynamic payment. He can 'get' negative amount of money", "This will limit it to particular percentage", "Works only when original payment is above 0");
        this.useMinimumOveralPoints = c.get("Economy.MinimumOveralPoints.use", true);
        this.MinimumOveralPointsLimit = c.get("Economy.MinimumOveralPoints.limit", 0.1);
        c.getW().addComment("Economy.DynamicPayment.use", "Do you want to use dinamic payment dependent on how many players already working for jobs", "This can help automaticaly lift up payments for not so popular jobs and lower for most popular ones");
        this.useDynamicPayment = c.get("Economy.DynamicPayment.use", false);
        String maxExpEquationInput = c.get("Economy.DynamicPayment.equation", "((totalworkers / totaljobs) - jobstotalplayers)/10.0");
        try {
            this.DynamicPaymentEquation = new Parser(maxExpEquationInput);
            this.DynamicPaymentEquation.setVariable("totalworkers", 100.0);
            this.DynamicPaymentEquation.setVariable("totaljobs", 10.0);
            this.DynamicPaymentEquation.setVariable("jobstotalplayers", 10.0);
            this.DynamicPaymentEquation.getValue();
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage((Object)((Object)ChatColor.RED) + "Dynamic payment equation has an invalid property. Disabling feature!");
            this.useDynamicPayment = false;
        }
        this.DynamicPaymentMaxPenalty = c.get("Economy.DynamicPayment.MaxPenalty", 25.0);
        this.DynamicPaymentMaxBonus = c.get("Economy.DynamicPayment.MaxBonus", 100.0);
        c.getW().addComment("Economy.UseServerAcount", "Server economy acount", "With this enabled, players will get money from defined user (server account)", "If this acount dont have enough money to pay for players for, player will get message");
        this.UseServerAccount = c.get("Economy.UseServerAcount", false);
        c.getW().addComment("Economy.AcountName", "Username should be with Correct capitalization");
        this.ServerAcountName = c.get("Economy.AcountName", "Server");
        c.getW().addComment("Economy.Taxes.use", "Do you want to use taxes feature for jobs payment");
        this.UseTaxes = c.get("Economy.Taxes.use", false);
        c.getW().addComment("Economy.Taxes.AccountName", "Username should be with Correct capitalization, it can be same as settup in server account before");
        this.ServertaxesAcountName = c.get("Economy.Taxes.AccountName", "Server");
        c.getW().addComment("Economy.Taxes.Amount", "Amount in percentage");
        this.TaxesAmount = c.get("Economy.Taxes.Amount", 15.0);
        c.getW().addComment("Economy.Taxes.TransferToServerAccount", "Do you want to transfer taxes to server account");
        this.TransferToServerAccount = c.get("Economy.Taxes.TransferToServerAccount", true);
        c.getW().addComment("Economy.Taxes.TakeFromPlayersPayment", "With this true, taxes will be taken from players payment and he will get less money than its shown in jobs info", "When its false player will get full payment and server account will get taxes amount to hes account");
        this.TakeFromPlayersPayment = c.get("Economy.Taxes.TakeFromPlayersPayment", false);
        CurrencyLimit limit2 = new CurrencyLimit();
        c.getW().addComment("Economy.Limit.Money", "Money gain limit", "With this enabled, players will be limited how much they can make in defined time", "Time in seconds: 60 = 1min, 3600 = 1 hour, 86400 = 24 hours");
        limit2.setEnabled(c.get("Economy.Limit.Money.Use", false));
        ArrayList<CurrencyType> list = new ArrayList<CurrencyType>();
        c.getW().addComment("Economy.Limit.Money.StopWithExp", "Do you want to stop money gain when exp limit reached?");
        if (c.get("Economy.Limit.Money.StopWithExp", false).booleanValue()) {
            list.add(CurrencyType.EXP);
        }
        c.getW().addComment("Economy.Limit.Money.StopWithPoint", "Do you want to stop money gain when point limit reached?");
        if (c.get("Economy.Limit.Money.StopWithPoint", false).booleanValue()) {
            list.add(CurrencyType.POINTS);
        }
        limit2.setStopWith(list);
        c.getW().addComment("Economy.Limit.Money.MoneyLimit", "Equation to calculate max limit. Option to use totallevel to include players total amount levels of current jobs", "You can always use simple number to set money limit", "Default equation is: 500+500*(totallevel/100), this will add 1% from 500 for each level player have", "So player with 2 jobs with level 15 and 22 will have 685 limit");
        String MoneyLimit = c.get("Economy.Limit.Money.MoneyLimit", "500+500*(totallevel/100)");
        try {
            Parser Equation = new Parser(MoneyLimit);
            Equation.setVariable("totallevel", 1.0);
            Equation.getValue();
            limit2.setMaxEquation(Equation);
        }
        catch (Exception e) {
            Jobs.getPluginLogger().warning("MoneyLimit has an invalid value. Disabling money limit!");
            limit2.setEnabled(false);
        }
        c.getW().addComment("Economy.Limit.Money.TimeLimit", "Time in seconds: 60 = 1min, 3600 = 1 hour, 86400 = 24 hours");
        limit2.setTimeLimit(c.get("Economy.Limit.Money.TimeLimit", 3600));
        c.getW().addComment("Economy.Limit.Money.AnnouncmentDelay", "Delay between announcements about reached money limit", "Keep this from 30 to 5 min (300), as players can get annoyed of constant message displaying");
        limit2.setAnnouncmentDelay(c.get("Economy.Limit.Money.AnnouncmentDelay", 30));
        this.currencyLimitUse.put(CurrencyType.MONEY, limit2);
        limit2 = new CurrencyLimit();
        list = new ArrayList();
        c.getW().addComment("Economy.Limit.Point", "Point gain limit", "With this enabled, players will be limited how much they can make in defined time");
        limit2.setEnabled(c.get("Economy.Limit.Point.Use", false));
        c.getW().addComment("Economy.Limit.Point.StopWithExp", "Do you want to stop Point gain when exp limit reached?");
        if (c.get("Economy.Limit.Point.StopWithExp", false).booleanValue()) {
            list.add(CurrencyType.EXP);
        }
        c.getW().addComment("Economy.Limit.Point.StopWithMoney", "Do you want to stop Point gain when money limit reached?");
        if (c.get("Economy.Limit.Point.StopWithMoney", false).booleanValue()) {
            list.add(CurrencyType.MONEY);
        }
        limit2.setStopWith(list);
        c.getW().addComment("Economy.Limit.Point.Limit", "Equation to calculate max limit. Option to use totallevel to include players total amount levels of current jobs", "You can always use simple number to set limit", "Default equation is: 500+500*(totallevel/100), this will add 1% from 500 for each level player have", "So player with 2 jobs with level 15 and 22 will have 685 limit");
        String PointLimit = c.get("Economy.Limit.Point.Limit", "500+500*(totallevel/100)");
        try {
            Parser Equation = new Parser(PointLimit);
            Equation.setVariable("totallevel", 1.0);
            Equation.getValue();
            limit2.setMaxEquation(Equation);
        }
        catch (Exception e) {
            Jobs.getPluginLogger().warning("PointLimit has an invalid value. Disabling money limit!");
            limit2.setEnabled(false);
        }
        c.getW().addComment("Economy.Limit.Point.TimeLimit", "Time in seconds: 60 = 1min, 3600 = 1 hour, 86400 = 24 hours");
        limit2.setTimeLimit(c.get("Economy.Limit.Point.TimeLimit", 3600));
        c.getW().addComment("Economy.Limit.Point.AnnouncmentDelay", "Delay between announcements about reached limit", "Keep this from 30 to 5 min (300), as players can get annoyed of constant message displaying");
        limit2.setAnnouncmentDelay(c.get("Economy.Limit.Point.AnnouncmentDelay", 30));
        this.currencyLimitUse.put(CurrencyType.POINTS, limit2);
        limit2 = new CurrencyLimit();
        list = new ArrayList();
        c.getW().addComment("Economy.Limit.Exp", "Exp gain limit", "With this enabled, players will be limited how much they can get in defined time", "Time in seconds: 60 = 1min, 3600 = 1 hour, 86400 = 24 hours");
        limit2.setEnabled(c.get("Economy.Limit.Exp.Use", false));
        c.getW().addComment("Economy.Limit.Exp.StopWithMoney", "Do you want to stop exp gain when money limit reached?");
        if (c.get("Economy.Limit.Exp.StopWithMoney", false).booleanValue()) {
            list.add(CurrencyType.MONEY);
        }
        c.getW().addComment("Economy.Limit.Exp.StopWithPoint", "Do you want to stop exp gain when point limit reached?");
        if (c.get("Economy.Limit.Exp.StopWithPoint", false).booleanValue()) {
            list.add(CurrencyType.POINTS);
        }
        limit2.setStopWith(list);
        c.getW().addComment("Economy.Limit.Exp.Limit", "Equation to calculate max money limit. Option to use totallevel to include players total amount of current jobs", "You can always use simple number to set exp limit", "Default equation is: 5000+5000*(totallevel/100), this will add 1% from 5000 for each level player have", "So player with 2 jobs with level 15 and 22 will have 6850 limit");
        String expLimit = c.get("Economy.Limit.Exp.Limit", "5000+5000*(totallevel/100)");
        try {
            Parser Equation = new Parser(expLimit);
            Equation.setVariable("totallevel", 1.0);
            Equation.getValue();
            limit2.setMaxEquation(Equation);
        }
        catch (Exception e) {
            Jobs.getPluginLogger().warning("ExpLimit has an invalid value. Disabling money limit!");
            limit2.setEnabled(false);
        }
        c.getW().addComment("Economy.Limit.Exp.TimeLimit", "Time in seconds: 60 = 1min, 3600 = 1 hour, 86400 = 24 hours");
        limit2.setTimeLimit(c.get("Economy.Limit.Exp.TimeLimit", 3600));
        c.getW().addComment("Economy.Limit.Exp.AnnouncmentDelay", "Delay between announcements about reached Exp limit", "Keep this from 30 to 5 min (300), as players can get annoyed of constant message displaying");
        limit2.setAnnouncmentDelay(c.get("Economy.Limit.Exp.AnnouncmentDelay", 30));
        this.currencyLimitUse.put(CurrencyType.EXP, limit2);
        c.getW().addComment("Economy.Repair.PayForRenaming", "Do you want to give money for only renaming items in anvil", "Players will get full pay as they would for remairing two items when they only renaming one", "This is not big issue, but if you want to disable it, you can");
        this.PayForRenaming = c.get("Economy.Repair.PayForRenaming", true);
        c.getW().addComment("Economy.Crafting.PayForEachCraft", "With this true, player will get money for all crafted items instead of each crafting action (like with old payment mechanic)", "By default its false, as you can make ALOT of money if prices kept from old payment mechanics");
        this.PayForEachCraft = c.get("Economy.Crafting.PayForEachCraft", false);
        c.getW().addComment("Economy.MilkingCow.CancelMilking", "With this true, when timer is still going, cow milking event will be canceled", "With this false, player will get bucket of milk, but still no payment");
        this.CancelCowMilking = c.get("Economy.MilkingCow.CancelMilking", false);
        c.getW().addComment("Economy.MilkingCow.Timer", "How ofter player can milk cows in seconds. Keep in mind that by default player can milk cow indefinetly and as often as he wants", "Set to 0 if you want to disable timer");
        this.CowMilkingTimer = c.get("Economy.MilkingCow.Timer", 30) * 1000;
        c.getW().addComment("ExploitProtections.General.PlaceAndBreakProtection", "Enable blocks protection, like ore, from exploiting by placing and destroying same block again and again.", "Modify restrictedBlocks.yml for blocks you want to protect");
        this.useBlockProtection = c.get("ExploitProtections.General.PlaceAndBreakProtection", true);
        c.getW().addComment("ExploitProtections.General.KeepDataFor", "For how long in days to keep block protection data in data base", "This will clean block data which ones have -1 as cooldown value", "Data base cleannup will be performed on each server startup");
        this.BlockProtectionDays = c.get("ExploitProtections.General.KeepDataFor", 14);
        c.getW().addComment("ExploitProtections.General.GlobalBlockTimer", "All blocks will be protected X sec after player places it on ground.");
        this.useGlobalTimer = c.get("ExploitProtections.General.GlobalBlockTimer.use", true);
        this.globalblocktimer = c.get("ExploitProtections.General.GlobalBlockTimer.timer", 3);
        c.getW().addComment("ExploitProtections.General.SilkTouchProtection", "Enable silk touch protection.", "With this enabled players wont get paid for breaked blocks from restrictedblocks list with silk touch tool.");
        this.useSilkTouchProtection = c.get("ExploitProtections.General.SilkTouchProtection", false);
        c.getW().addComment("ExploitProtections.General.MonsterDamage.Use", "This section controls how much damage player should do to monster for player to get paid", "This prevents from killing monsters in one hit when they suffer in example fall damage");
        this.MonsterDamageUse = c.get("ExploitProtections.General.MonsterDamage.Use", false);
        this.MonsterDamagePercentage = c.get("ExploitProtections.General.MonsterDamage.Percentage", 60);
        c.getW().addComment("ExploitProtections.McMMO", "McMMO abilities");
        c.getW().addComment("ExploitProtections.McMMO.TreeFellerMultiplier", "Players will get part of money from cutting trees with treefeller ability enabled.", "0.2 means 20% of original price");
        this.TreeFellerMultiplier = c.get("ExploitProtections.McMMO.TreeFellerMultiplier", 0.2);
        c.getW().addComment("ExploitProtections.McMMO.gigaDrillMultiplier", "Players will get part of money from braking blocks with gigaDrill ability enabled.", "0.2 means 20% of original price");
        this.gigaDrillMultiplier = c.get("ExploitProtections.McMMO.gigaDrillMultiplier", 0.2);
        c.getW().addComment("ExploitProtections.McMMO.superBreakerMultiplier", "Players will get part of money from braking blocks with super breaker ability enabled.", "0.2 means 20% of original price");
        this.superBreakerMultiplier = c.get("ExploitProtections.McMMO.superBreakerMultiplier", 0.2);
        c.getW().addComment("ExploitProtections.MythicMobs", "MythicMobs plugin support", "Disable if you having issues with it or using old version");
        this.MythicMobsEnabled = c.get("ExploitProtections.MythicMobs.enabled", true);
        c.getW().addComment("ExploitProtections.Spawner.PreventSlimeSplit", "Prevent slime spliting when they are from spawner", "Protects agains exploiting as new splited slimes is treated as naturaly spawned and not from spawner");
        this.PreventSlimeSplit = c.get("ExploitProtections.Spawner.PreventSlimeSplit", true);
        c.getW().addComment("ExploitProtections.Spawner.PreventMagmaCubeSplit", "Prevent magmacube spliting when they are from spawner");
        this.PreventMagmaCubeSplit = c.get("ExploitProtections.Spawner.PreventMagmaCubeSplit", true);
        c.getW().addComment("use-breeder-finder", "Breeder finder.", "If you are not using breeding payment, you can disable this to save little resources. Really little.");
        this.useBreederFinder = c.get("use-breeder-finder", true);
        c.getW().addComment("old-job", "Old job save", "Players can leave job and return later with some level loss during that", "You can fix players level if hes job level is at max level");
        this.levelLossPercentage = c.get("old-job.level-loss-percentage", 30);
        this.fixAtMaxLevel = c.get("old-job.fix-at-max-level", true);
        c.getW().addComment("ActionBars.Messages.EnabledByDefault", "When this set to true player will see action bar messages by default");
        this.ActionBarsMessageByDefault = c.get("ActionBars.Messages.EnabledByDefault", true);
        c.getW().addComment("BossBar.Enabled", "Enables BossBar feature", "Works only from 1.9 mc version");
        this.BossBarEnabled = c.get("BossBar.Enabled", true);
        if (Jobs.getActionBar().getVersion() < 1900) {
            this.BossBarEnabled = false;
            Bukkit.getConsoleSender().sendMessage((Object)((Object)ChatColor.RED) + "[Jobs] Your server version don't support BossBar. This feature will be disabled");
        }
        c.getW().addComment("BossBar.Messages.EnabledByDefault", "When this set to true player will see Bossbar messages by default");
        this.BossBarsMessageByDefault = c.get("BossBar.Messages.EnabledByDefault", true);
        c.getW().addComment("BossBar.ShowOnEachAction", "If enabled boss bar will update after each action", "If disabled, BossBar will update only on each payment. This can save some server resources");
        this.BossBarShowOnEachAction = c.get("BossBar.ShowOnEachAction", false);
        c.getW().addComment("BossBar.Timer", "How long in sec to show BossBar for player", "If you have disabled ShowOnEachAction, then keep this number higher than payment interval for better experience");
        this.BossBarTimer = c.get("BossBar.Timer", this.economyBatchDelay + 1);
        c.getW().addComment("ShowActionBars", "You can enable/disable message shown for players in action bar");
        this.TitleChangeActionBar = c.get("ShowActionBars.OnTitleChange", true);
        this.LevelChangeActionBar = c.get("ShowActionBars.OnLevelChange", true);
        this.EmptyServerAcountActionBar = c.get("ShowActionBars.OnEmptyServerAcount", true);
        c.getW().addComment("ShowChatMessage", "Chat messages", "You can enable/disable message shown for players in chat");
        this.TitleChangeChat = c.get("ShowChatMessage.OnTitleChange", true);
        this.LevelChangeChat = c.get("ShowChatMessage.OnLevelChange", true);
        this.EmptyServerAcountChat = c.get("ShowChatMessage.OnEmptyServerAcount", true);
        c.getW().addComment("Sounds", "Sounds", "Extra sounds on some events", "All sounds can be found in https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html");
        this.SoundLevelupUse = c.get("Sounds.LevelUp.use", true);
        this.SoundLevelupSound = c.get("Sounds.LevelUp.sound", "ENTITY_PLAYER_LEVELUP");
        this.SoundLevelupVolume = c.get("Sounds.LevelUp.volume", 1);
        this.SoundLevelupPitch = c.get("Sounds.LevelUp.pitch", 3);
        this.SoundTitleChangeUse = c.get("Sounds.TitleChange.use", true);
        this.SoundTitleChangeSound = c.get("Sounds.TitleChange.sound", "ENTITY_PLAYER_LEVELUP");
        this.SoundTitleChangeVolume = c.get("Sounds.TitleChange.volume", 1);
        this.SoundTitleChangePitch = c.get("Sounds.TitleChange.pitch", 3);
        c.getW().addComment("Signs", "You can disable this to save SMALL amount of server resources");
        this.SignsEnabled = c.get("Signs.Enable", true);
        this.SignsColorizeJobName = c.get("Signs.Colors.ColorizeJobName", true);
        c.getW().addComment("Signs.InfoUpdateInterval", "This is interval in sec in which signs will be updated. This is not continues update, signs are updated only on levelup, job leave, job join or similar action.");
        c.getW().addComment("Signs.InfoUpdateInterval", "This is update for same job signs, to avoid huge lag if you have bunch of same type signs. Keep it from 1 to as many sec you want");
        this.InfoUpdateInterval = c.get("Signs.InfoUpdateInterval", 5);
        c.getW().addComment("Scoreboard.ShowToplist", "This will enables to show top list in scoreboard instead of chat");
        this.ShowToplistInScoreboard = c.get("Scoreboard.ShowToplist", true);
        c.getW().addComment("Scoreboard.interval", "For how long to show scoreboard");
        this.ToplistInScoreboardInterval = c.get("Scoreboard.interval", 10);
        c.getW().addComment("JobsBrowse.ShowTotalWorkers", "Do you want to show total amount of workers for job in jobs browse window");
        this.ShowTotalWorkers = c.get("JobsBrowse.ShowTotalWorkers", true);
        c.getW().addComment("JobsBrowse.ShowPenaltyBonus", "Do you want to show penalty and bonus in jobs browse window. Only works if this feature is enabled");
        this.ShowPenaltyBonus = c.get("JobsBrowse.ShowPenaltyBonus", true);
        c.getW().addComment("JobsGUI.OpenOnBrowse", "Do you want to show GUI when performing /jobs browse command");
        this.JobsGUIOpenOnBrowse = c.get("JobsGUI.OpenOnBrowse", true);
        c.getW().addComment("JobsGUI.ShowChatBrowse", "Do you want to show chat information when performing /jobs browse command");
        this.JobsGUIShowChatBrowse = c.get("JobsGUI.ShowChatBrowse", true);
        c.getW().addComment("JobsGUI.SwitcheButtons", "With true left mouse button will join job and right will show more info", "With false left mouse button will show more info, rigth will join job", "Dont forget to adjust locale file");
        this.JobsGUISwitcheButtons = c.get("JobsGUI.SwitcheButtons", false);
        c.getW().addComment("JobsBrowse.ShowPenaltyBonus", "Do you want to show GUI when performing /jobs join command");
        this.JobsGUIOpenOnJoin = c.get("JobsGUI.OpenOnJoin", true);
        Material tmat = Material.getMaterial((String)c.get("JobsGUI.BackButton.Material", "JACK_O_LANTERN"));
        this.guiBackButton = new ItemStack(tmat == null ? Material.JACK_O_LANTERN : tmat, 1, (short)((byte)c.get("JobsGUI.BackButton.Data", 0)));
        tmat = Material.getMaterial((String)c.get("JobsGUI.Filler.Material", "STAINED_GLASS_PANE"));
        this.guiFiller = new ItemStack(tmat == null ? Material.STAINED_GLASS_PANE : tmat, 1, (short)((byte)c.get("JobsGUI.Filler.Data", 15)));
        c.getW().addComment("Schedule.Boost.Enable", "Do you want to enable scheduler for global boost");
        this.useGlobalBoostScheduler = c.get("Schedule.Boost.Enable", false);
        try {
            c.getW().save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void startMysql() {
        String username;
        File f = new File(this.plugin.getDataFolder(), "generalConfig.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        String legacyUrl = config.getString("mysql-url");
        if (legacyUrl != null) {
            String[] parts;
            String jdbcString = "jdbc:mysql://";
            if (legacyUrl.toLowerCase().startsWith(jdbcString) && (parts = (legacyUrl = legacyUrl.substring(jdbcString.length())).split("/")).length >= 2) {
                config.set("mysql-hostname", (Object)parts[0]);
                config.set("mysql-database", (Object)parts[1]);
            }
        }
        if ((username = config.getString("mysql-username")) == null) {
            Jobs.getPluginLogger().severe("mysql-username property invalid or missing");
        }
        String password = config.getString("mysql-password");
        String hostname = config.getString("mysql-hostname");
        String database = config.getString("mysql-database");
        String prefix = config.getString("mysql-table-prefix");
        if (this.plugin.isEnabled()) {
            Jobs.setDAO(JobsDAOMySQL.initialize(this.plugin, hostname, database, username, password, prefix));
        }
    }

    public synchronized void startSqlite() {
        Jobs.setDAO(JobsDAOSQLite.initialize(this.plugin));
    }

    public int getSelectionTooldID() {
        return this.getSelectionTooldID;
    }
}

