/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.ExploreChunk;
import com.gamingmesh.jobs.container.ExploreRegion;
import com.gamingmesh.jobs.container.ExploreRespond;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;

public class ExploreManager {
    private HashMap<String, ExploreRegion> worlds = new HashMap();
    private boolean exploreEnabled = false;
    private int playerAmount = 1;

    public int getPlayerAmount() {
        return this.playerAmount;
    }

    public void setPlayerAmount(int amount) {
        if (this.playerAmount < amount) {
            this.playerAmount = amount;
        }
    }

    public boolean isExploreEnabled() {
        return this.exploreEnabled;
    }

    public void setExploreEnabled() {
        if (!this.exploreEnabled) {
            this.exploreEnabled = true;
        }
    }

    public void load() {
        if (!this.exploreEnabled) {
            return;
        }
        Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[Jobs] Loading explorer data");
        Jobs.getJobsDAO().loadExplore();
        Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[Jobs] Loaded explorer data");
    }

    public HashMap<String, ExploreRegion> getWorlds() {
        return this.worlds;
    }

    public ExploreRespond ChunkRespond(Player player, Chunk chunk, boolean isNew) {
        return this.ChunkRespond(player.getName(), chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), isNew);
    }

    public ExploreRespond ChunkRespond(String player, String worldName, int x, int z, boolean isNew) {
        int ChunkX = x;
        int ChunkZ = z;
        int RegionX = (int)Math.floor((double)ChunkX / 32.0);
        int RegionZ = (int)Math.floor((double)ChunkZ / 32.0);
        if (!this.worlds.containsKey(worldName)) {
            ExploreChunk eChunk = new ExploreChunk(player, ChunkX, ChunkZ);
            if (!isNew) {
                eChunk.setOldChunk();
            }
            ExploreRegion eRegion = new ExploreRegion(RegionX, RegionZ);
            eRegion.addChunk(eChunk);
            this.worlds.put(worldName, eRegion);
            return new ExploreRespond(eChunk.getCount(), true);
        }
        ExploreRegion eRegion = this.worlds.get(worldName);
        ExploreChunk eChunk = eRegion.getChunk(String.valueOf(ChunkX) + ":" + ChunkZ);
        if (eChunk == null) {
            eChunk = new ExploreChunk(player, ChunkX, ChunkZ);
            if (!isNew) {
                eChunk.setOldChunk();
            }
            eRegion.addChunk(eChunk);
            return new ExploreRespond(eChunk.getCount(), true);
        }
        eChunk.setOldChunk();
        return eChunk.addPlayer(player);
    }

    public void addChunk(String player, String worldName, int x, int z) {
        ExploreRegion eRegion;
        ExploreChunk eChunk;
        int ChunkX = x;
        int ChunkZ = z;
        int RegionX = (int)Math.floor((double)ChunkX / 32.0);
        int RegionZ = (int)Math.floor((double)ChunkZ / 32.0);
        if (!this.worlds.containsKey(worldName)) {
            ExploreChunk eChunk2 = new ExploreChunk(player, ChunkX, ChunkZ);
            eChunk2.setOldChunk();
            ExploreRegion eRegion2 = new ExploreRegion(RegionX, RegionZ);
            eRegion2.addChunk(eChunk2);
            this.worlds.put(worldName, eRegion2);
        }
        if ((eChunk = (eRegion = this.worlds.get(worldName)).getChunk(String.valueOf(ChunkX) + ":" + ChunkZ)) == null) {
            eChunk = new ExploreChunk(player, ChunkX, ChunkZ);
            eChunk.setOldChunk();
            eRegion.addChunk(eChunk);
        } else {
            eChunk.setOldChunk();
        }
    }
}

