/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.commands.list;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.commands.Cmd;
import com.gamingmesh.jobs.commands.JobCommand;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.container.PlayerPoints;
import org.bukkit.command.CommandSender;

public class editpoints
implements Cmd {
    @Override
    @JobCommand(value=475)
    public boolean perform(Jobs plugin, CommandSender sender, String[] args) {
        if (args.length != 3) {
            Jobs.getCommandManager().sendUsage(sender, "editpoints");
            return true;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(args[1]);
        if (jPlayer == null) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.noinfoByPlayer", "%playername%", args[1]));
            return true;
        }
        double amount = 0.0;
        try {
            amount = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.notNumber"));
            return true;
        }
        PlayerPoints pointInfo = Jobs.getPlayerManager().getPointsData().getPlayerPointsInfo(jPlayer.getPlayerUUID());
        if (pointInfo == null) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.noinfoByPlayer", "%playername%", jPlayer.getUserName()));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "take": {
                pointInfo.takePoints(amount);
                sender.sendMessage(Jobs.getLanguage().getMessage("command.editpoints.output.take", "%playername%", jPlayer.getUserName(), "%amount%", amount, "%total%", (double)((int)(pointInfo.getCurrentPoints() * 100.0)) / 100.0));
                break;
            }
            case "add": {
                pointInfo.addPoints(amount);
                sender.sendMessage(Jobs.getLanguage().getMessage("command.editpoints.output.add", "%playername%", jPlayer.getUserName(), "%amount%", amount, "%total%", (double)((int)(pointInfo.getCurrentPoints() * 100.0)) / 100.0));
                break;
            }
            case "set": {
                pointInfo.setPoints(amount);
                sender.sendMessage(Jobs.getLanguage().getMessage("command.editpoints.output.set", "%playername%", jPlayer.getUserName(), "%amount%", amount));
            }
        }
        return true;
    }
}

