/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.Signs;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.Signs.Sign;
import com.gamingmesh.jobs.Signs.SignInfo;
import com.gamingmesh.jobs.config.CommentedYamlConfiguration;
import com.gamingmesh.jobs.container.TopList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SignUtil {
    public SignInfo Signs = new SignInfo();
    private Jobs plugin;

    public SignUtil(Jobs plugin) {
        this.plugin = plugin;
    }

    public SignInfo getSigns() {
        return this.Signs;
    }

    public void LoadSigns() {
        this.Signs.GetAllSigns().clear();
        File file = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration f = YamlConfiguration.loadConfiguration((File)file);
        if (!f.isConfigurationSection("Signs")) {
            return;
        }
        ConfigurationSection ConfCategory = f.getConfigurationSection("Signs");
        ArrayList categoriesList = new ArrayList(ConfCategory.getKeys(false));
        if (categoriesList.size() == 0) {
            return;
        }
        for (String category : categoriesList) {
            ConfigurationSection NameSection = ConfCategory.getConfigurationSection(category);
            Sign newTemp = new Sign();
            newTemp.setCategory(Integer.valueOf(category));
            newTemp.setWorld(NameSection.getString("World"));
            newTemp.setX(NameSection.getDouble("X"));
            newTemp.setY(NameSection.getDouble("Y"));
            newTemp.setZ(NameSection.getDouble("Z"));
            newTemp.setNumber(NameSection.getInt("Number"));
            newTemp.setJobName(NameSection.getString("JobName"));
            newTemp.setSpecial(NameSection.getBoolean("Special"));
            this.Signs.addSign(newTemp);
        }
    }

    public void saveSigns() {
        File f = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        CommentedYamlConfiguration writer = new CommentedYamlConfiguration();
        conf.options().copyDefaults(true);
        writer.addComment("Signs", "DO NOT EDIT THIS FILE BY HAND!");
        if (!conf.isConfigurationSection("Signs")) {
            conf.createSection("Signs");
        }
        for (Sign one : this.Signs.GetAllSigns()) {
            String path = "Signs." + String.valueOf(one.GetCategory());
            writer.set(String.valueOf(path) + ".World", one.GetWorld());
            writer.set(String.valueOf(path) + ".X", one.GetX());
            writer.set(String.valueOf(path) + ".Y", one.GetY());
            writer.set(String.valueOf(path) + ".Z", one.GetZ());
            writer.set(String.valueOf(path) + ".Number", one.GetNumber());
            writer.set(String.valueOf(path) + ".JobName", one.GetJobName());
            writer.set(String.valueOf(path) + ".Special", one.isSpecial());
        }
        try {
            writer.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean SignUpdate(String JobName) {
        ArrayList<Sign> Copy = new ArrayList<Sign>(this.Signs.GetAllSigns().size());
        for (Sign foo : this.Signs.GetAllSigns()) {
            Copy.add(foo);
        }
        int timelapse = 1;
        for (Sign one : Copy) {
            World world;
            String SignJobName = one.GetJobName();
            if (!JobName.equalsIgnoreCase(SignJobName)) continue;
            String SignsWorld = one.GetWorld();
            double SignsX = one.GetX();
            double SignsY = one.GetY();
            double SignsZ = one.GetZ();
            int number = one.GetNumber() - 1;
            List<Object> PlayerList = new ArrayList();
            PlayerList = !JobName.equalsIgnoreCase("gtoplist") ? Jobs.getJobsDAO().toplist(SignJobName, number) : Jobs.getJobsDAO().getGlobalTopList(number);
            if (PlayerList.size() == 0 || (world = Bukkit.getWorld((String)SignsWorld)) == null) continue;
            Location nloc = new Location(world, SignsX, SignsY, SignsZ);
            Block block = nloc.getBlock();
            if (!(block.getState() instanceof org.bukkit.block.Sign)) {
                this.Signs.GetAllSigns().remove(one);
                this.saveSigns();
                continue;
            }
            org.bukkit.block.Sign sign = (org.bukkit.block.Sign)block.getState();
            if (!one.isSpecial()) {
                int i = 0;
                while (i < 4) {
                    if (i >= PlayerList.size()) break;
                    String PlayerName = ((TopList)PlayerList.get(i)).getPlayerName();
                    if (PlayerName != null && PlayerName.length() > 8) {
                        String PlayerNameStrip = PlayerName.split("(?<=\\G.{7})")[0];
                        PlayerName = String.valueOf(PlayerNameStrip) + "~";
                    }
                    if (PlayerName == null) {
                        PlayerName = "Unknown";
                    }
                    String line = Jobs.getLanguage().getMessage("signs.List");
                    line = line.replace("[number]", String.valueOf(i + number + 1));
                    line = line.replace("[player]", PlayerName);
                    line = line.replace("[level]", String.valueOf(((TopList)PlayerList.get(i)).getLevel()));
                    sign.setLine(i, line);
                    ++i;
                }
                sign.update();
                this.UpdateHead(sign, ((TopList)PlayerList.get(0)).getPlayerName(), timelapse);
            } else {
                String PlayerName = ((TopList)PlayerList.get(0)).getPlayerName();
                if (PlayerName.length() > 8) {
                    String PlayerNameStrip = PlayerName.split("(?<=\\G.{7})")[0];
                    PlayerName = String.valueOf(PlayerNameStrip) + "~";
                }
                String line1 = Jobs.getLanguage().getMessage("signs.SpecialList." + one.GetNumber() + ".1");
                line1 = line1.replace("[number]", String.valueOf(one.GetNumber() + number + 1));
                line1 = line1.replace("[player]", PlayerName);
                line1 = line1.replace("[level]", String.valueOf(((TopList)PlayerList.get(0)).getLevel()));
                sign.setLine(0, line1);
                line1 = Jobs.getLanguage().getMessage("signs.SpecialList." + one.GetNumber() + ".2");
                line1 = line1.replace("[number]", String.valueOf(one.GetNumber() + number + 1));
                line1 = line1.replace("[player]", PlayerName);
                line1 = line1.replace("[level]", String.valueOf(((TopList)PlayerList.get(0)).getLevel()));
                sign.setLine(1, line1);
                line1 = Jobs.getLanguage().getMessage("signs.SpecialList." + one.GetNumber() + ".3");
                line1 = line1.replace("[number]", String.valueOf(one.GetNumber() + number + 1));
                line1 = line1.replace("[player]", PlayerName);
                line1 = line1.replace("[level]", String.valueOf(((TopList)PlayerList.get(0)).getLevel()));
                sign.setLine(2, line1);
                line1 = Jobs.getLanguage().getMessage("signs.SpecialList." + one.GetNumber() + ".4");
                line1 = line1.replace("[number]", String.valueOf(one.GetNumber() + number + 1));
                line1 = line1.replace("[player]", PlayerName);
                line1 = line1.replace("[level]", String.valueOf(((TopList)PlayerList.get(0)).getLevel()));
                sign.setLine(3, line1);
                sign.update();
                this.UpdateHead(sign, ((TopList)PlayerList.get(0)).getPlayerName(), timelapse);
            }
            ++timelapse;
        }
        return true;
    }

    public void UpdateHead(final org.bukkit.block.Sign sign, final String Playername, int timelapse) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                org.bukkit.material.Sign signMat = (org.bukkit.material.Sign)sign.getData();
                BlockFace directionFacing = signMat.getFacing();
                Location loc = sign.getLocation().clone();
                loc.add(0.0, 1.0, 0.0);
                if (Playername == null) {
                    return;
                }
                Block block = loc.getBlock();
                if (block == null || !(block.getState() instanceof Skull)) {
                    loc.add((double)directionFacing.getOppositeFace().getModX(), 0.0, (double)directionFacing.getOppositeFace().getModZ());
                }
                if ((block = loc.getBlock()) == null || !(block.getState() instanceof Skull)) {
                    return;
                }
                Skull skull = (Skull)block.getState();
                if (skull == null) {
                    return;
                }
                skull.setOwner(Playername);
                skull.update();
            }
        }, (long)(timelapse * Jobs.getGCManager().InfoUpdateInterval) * 20L);
    }
}

