/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="Get all permissions of group")
@Description(value={"Gets all perms in a PermissionsEx group"})
@Examples(value={"To be added"})
@Since(value="0.4.0")
public class ExprPermission
extends SimpleExpression<String> {
    private Expression<String> groupName;
    private Expression<World> world;

    static {
        Skript.registerExpression(ExprPermission.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[pex] group %string% permission[s] [in %-world%]"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.groupName = arg0[0];
        this.world = arg0[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[pex] group %string% permission[s] [in world %world%]";
    }

    @Nullable
    protected String[] get(Event arg0) {
        PermissionGroup g = PermissionsEx.getPermissionManager().getGroup((String)this.groupName.getSingle(arg0));
        if (g == null) {
            return null;
        }
        List perms = g.getOwnPermissions(this.world != null ? ((World)this.world.getSingle(arg0)).getName() : null);
        return perms.toArray(new String[perms.size()]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String world = this.world != null ? ((World)this.world.getSingle(e)).getName() : null;
        PermissionGroup g = PermissionsEx.getPermissionManager().getGroup((String)this.groupName.getSingle(e));
        if (g != null) {
            if (mode == Changer.ChangeMode.ADD) {
                String permission = (String)delta[0];
                g.addPermission(permission, world);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                String permission = (String)delta[0];
                g.removePermission(permission, world);
            } else if (mode == Changer.ChangeMode.DELETE) {
                List permissions = g.getOwnPermissions(world);
                int i = permissions.size() - 1;
                while (i >= 0) {
                    g.removePermission((String)permissions.get(i), world);
                    --i;
                }
            }
        }
    }
}

