package com.pie.tlatoani.ProtocolLib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.Logging;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

import java.util.Collections;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;

import static com.comphenix.protocol.PacketType.Play.Server.PLAYER_INFO;

/**
 * Created by Tlatoani on 8/14/17.
 */
public class PacketUtil {

    public static PacketContainer playerInfoPacket(
            String displayName,
            Integer latency,
            GameMode gameMode,
            String name,
            UUID uuid,
            Skin skin,
            EnumWrappers.PlayerInfoAction action
    ) {
        PacketContainer result = new PacketContainer(PLAYER_INFO);
        WrappedGameProfile profile = new WrappedGameProfile(uuid, name);
        if (action == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
            if (skin == null) {
                skin = Tablist.DEFAULT_SKIN_TEXTURE;
            }
            profile.getProperties().put(Skin.MULTIMAP_KEY, skin.toWrappedSignedProperty());
        }
        PlayerInfoData playerInfoData = new PlayerInfoData(
                profile,
                Optional.ofNullable(latency).map(PacketUtil::getPossibleLatency).orElse(0),
                Optional.ofNullable(gameMode).map(EnumWrappers.NativeGameMode::fromBukkit).orElse(EnumWrappers.NativeGameMode.NOT_SET),
                WrappedChatComponent.fromText(Optional.ofNullable(displayName).orElse(""))
        );
        result.getPlayerInfoDataLists().writeSafely(0, Collections.singletonList(playerInfoData));
        result.getPlayerInfoAction().writeSafely(0, action);
        return result;
    }

    public static PacketContainer playerInfoPacket(Player player, EnumWrappers.PlayerInfoAction action) {
        PacketContainer result = new PacketContainer(PLAYER_INFO);
        PlayerInfoData playerInfoData = new PlayerInfoData(
                WrappedGameProfile.fromPlayer(player),
                5,
                EnumWrappers.NativeGameMode.fromBukkit(player.getGameMode()),
                WrappedChatComponent.fromText(player.getPlayerListName())
        );
        result.getPlayerInfoDataLists().writeSafely(0, Collections.singletonList(playerInfoData));
        result.getPlayerInfoAction().writeSafely(0, action);
        return result;
    }

    public static PacketContainer scorePacket(String scoreName, String objectiveName, Integer score, EnumWrappers.ScoreboardAction action) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
        packet.getStrings().writeSafely(0, scoreName);
        packet.getStrings().writeSafely(1, objectiveName);
        packet.getIntegers().writeSafely(0, Optional.ofNullable(score).orElse(0));
        packet.getScoreboardActions().writeSafely(0, action);
        return packet;
    }

    public static WrappedChatComponent stringsToChatComponent(String[] strings) {
        if (strings.length == 0) {
            return WrappedChatComponent.fromText("");
        }
        StringJoiner joiner = new StringJoiner(", {\"text\":\"\n\"}, ", "{\"extra\":[", "],\"text\":\"\"}");
        for (String string : strings) {
            joiner.add(WrappedChatComponent.fromText(string).getJson());
        }
        Logging.debug(PacketUtil.class, "Final JSON: " + joiner.toString());
        return WrappedChatComponent.fromJson(joiner.toString());
    }

    public static int getPossibleLatency(int bars) {
        switch (bars) {
            case 0: return -1;
            case 1: return 1024;
            case 2: return 768;
            case 3: return 512;
            case 4: return 256;
            case 5: return 0;
            default: throw new IllegalArgumentException("Illegal amount of bars: " + bars + ", required 0 <= bars <= 5");
        }
    }
}
