/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WebSocket;

import ch.njol.skript.lang.TriggerItem;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.WebSocket.Events.WebSocketCloseEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketErrorEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketHandshakeEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketMessageEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketOpenEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketServerStartEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketServerStopEvent;
import com.pie.tlatoani.WebSocket.WebSocketServerFunctionality;
import java.net.InetSocketAddress;
import mundosk_libraries.java_websocket.WebSocket;
import mundosk_libraries.java_websocket.drafts.Draft;
import mundosk_libraries.java_websocket.exceptions.InvalidDataException;
import mundosk_libraries.java_websocket.handshake.ClientHandshake;
import mundosk_libraries.java_websocket.handshake.ServerHandshakeBuilder;
import mundosk_libraries.java_websocket.server.WebSocketServer;
import org.bukkit.event.Event;

public class SkriptWebSocketServer
extends WebSocketServer {
    public final WebSocketServerFunctionality functionality;

    public SkriptWebSocketServer(WebSocketServerFunctionality functionality, int port) {
        super(new InetSocketAddress(port));
        this.functionality = functionality;
        Logging.debug((Object)this, functionality.toString());
    }

    @Override
    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        this.functionality.onOpen.ifPresent(triggerItem -> TriggerItem.walk((TriggerItem)triggerItem, (Event)new WebSocketOpenEvent.Server(this, conn, handshake)));
    }

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        ServerHandshakeBuilder response = super.onWebsocketHandshakeReceivedAsServer(conn, draft, request);
        WebSocketHandshakeEvent.Server event = new WebSocketHandshakeEvent.Server(this, conn, request, response);
        this.functionality.onHandshake.ifPresent(triggerItem -> TriggerItem.walk((TriggerItem)triggerItem, (Event)event));
        if (!event.allowed) {
            throw new InvalidDataException(1003);
        }
        return response;
    }

    @Override
    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        this.functionality.onClose.ifPresent(triggerItem -> TriggerItem.walk((TriggerItem)triggerItem, (Event)new WebSocketCloseEvent.Server(this, conn, code, reason, remote)));
    }

    @Override
    public void onMessage(WebSocket conn, String message) {
        this.functionality.onMessage.ifPresent(triggerItem -> TriggerItem.walk((TriggerItem)triggerItem, (Event)new WebSocketMessageEvent.Server(this, conn, message)));
    }

    @Override
    public void onError(WebSocket conn, Exception ex) {
        conn.getReadyState();
        this.functionality.onError.ifPresent(triggerItem -> TriggerItem.walk((TriggerItem)triggerItem, (Event)new WebSocketErrorEvent.Server(this, conn, ex)));
    }

    @Override
    public void onStart() {
        this.functionality.onStart.ifPresent(triggerItem -> TriggerItem.walk((TriggerItem)triggerItem, (Event)new WebSocketServerStartEvent(this)));
    }

    @Override
    public void stop(int timeout) throws InterruptedException {
        super.stop(timeout);
        this.functionality.onStop.ifPresent(triggerItem -> TriggerItem.walk((TriggerItem)triggerItem, (Event)new WebSocketServerStopEvent(this)));
    }
}

