/*
 * Decompiled with CFR 0.152.
 */
package com.leaf;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import com.leaf.gui.GUIManager;
import com.leaf.gui.SkriptGUIEvent;
import com.leaf.util.EnumClassInfo;
import com.leaf.util.ReflectionUtils;
import com.leaf.utils.yaml.YAMLProcessor;
import de.slikey.effectlib.util.ParticleEffect;
import java.util.HashMap;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Leaf
extends JavaPlugin {
    public static Leaf plugin;
    private static GUIManager gui;
    private static RowSetFactory rowSetFactory;
    public static final HashMap<String, YAMLProcessor> YAML_STORE;

    public Leaf() {
        if (plugin != null) {
            throw new IllegalStateException("LeafSK can't have two instances.");
        }
        plugin = this;
    }

    public void onEnable() {
        Boolean hasSkript = this.hasPlugin("Skript");
        if (!hasSkript.booleanValue() || !Skript.isAcceptRegistrations()) {
            if (!hasSkript.booleanValue()) {
                Leaf.log("Error 404 - Skript not found.", Level.SEVERE);
            } else {
                Leaf.log("LeafSK can't be loaded when the server is already loaded.", Level.SEVERE);
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        SkriptAddon leaf = Skript.registerAddon((JavaPlugin)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        try {
            EnumClassInfo.create(Sound.class, "sound").register();
            rowSetFactory = RowSetProvider.newFactory();
            leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"db", "effects", "expressions", "yaml", "conditions", "particles"});
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"papi"});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Classes.registerClass((ClassInfo)new ClassInfo(ParticleEffect.class, "effectlibparticle").parser((Parser)new Parser<ParticleEffect>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public ParticleEffect parse(String value, ParseContext cont) {
                try {
                    return ParticleEffect.valueOf(value.replace(" ", "_").trim().toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    return null;
                }
            }

            public String toString(ParticleEffect eff, int in) {
                return eff.name().replace("_", " ").toLowerCase();
            }

            public String toVariableNameString(ParticleEffect eff) {
                return eff.name().replace("_", " ").toLowerCase();
            }
        }));
    }

    public void onDisable() {
        SkriptGUIEvent.getInstance().unregisterAll();
        if (gui != null) {
            gui.clearAll();
        }
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public static Leaf getInstance() {
        return plugin;
    }

    public boolean hasPlugin(String str) {
        return plugin.getServer().getPluginManager().isPluginEnabled(str);
    }

    public void info(String msg, Object ... values) {
        Leaf.log(String.format(msg, values), Level.INFO);
    }

    public static GUIManager getGUIManager() {
        if (gui == null) {
            gui = new GUIManager(Leaf.getInstance());
        }
        return gui;
    }

    public static void log(String msg) {
        Leaf.log(msg, Level.INFO);
    }

    public static void log(String msg, Level lvl) {
        plugin.getLogger().log(lvl, msg);
    }

    public static void log(Level lvl, String ... msgs) {
        for (String msg : msgs) {
            Leaf.log(msg, lvl);
        }
    }

    public static boolean isSpigot() {
        return ReflectionUtils.hasMethod(Player.class, "spigot", new Class[0]);
    }

    public static RowSetFactory getRowSetFactory() {
        return rowSetFactory;
    }

    public static String cc(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    static {
        YAML_STORE = new HashMap();
    }
}

