/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import com.leaf.utils.yaml.AsyncEffectOld;
import com.leaf.utils.yaml.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public class EffDeleteYamlFromDirectory
extends AsyncEffectOld {
    private Expression<String> file;
    private int mark;

    public File[] filter(String name) {
        File dir = null;
        if (this.mark == 1) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.isDirectory()) {
            Leaf.log("[Delete Yaml] " + name + " is not a directory!");
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    protected void execute(@Nullable Event event) {
        for (String name : (String[])this.file.getAll(event)) {
            for (File yamlFile : this.filter(StringUtil.checkSeparator(name))) {
                yamlFile.delete();
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "delete all yaml from director(y|ies) " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.mark = parse.mark;
        return true;
    }

    static {
        Skript.registerEffect(EffDeleteYamlFromDirectory.class, (String[])new String[]{"delete all [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings%"});
    }
}

