/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import com.leaf.utils.yaml.StringUtil;
import com.leaf.utils.yaml.YAMLFormat;
import com.leaf.utils.yaml.YAMLProcessor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public class EffLoadYamlDirectory
extends Effect {
    private Expression<String> file;
    private int mark;
    private int matchedPattern;

    public File[] filter(String name) {
        File dir = null;
        if (this.mark == 1) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.isDirectory()) {
            Leaf.log("[Load Yaml] " + name + " is not a directory!");
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(@Nullable Event event) {
        for (String name : (String[])this.file.getAll(event)) {
            for (File yamlFile : this.filter(StringUtil.checkSeparator(name))) {
                YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
                try {
                    yaml.load();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.matchedPattern == 1) {
                        Leaf.YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
                    } else {
                        Leaf.YAML_STORE.put(StringUtil.checkLastSeparator(name) + yamlFile.getName(), yaml);
                    }
                }
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "[re]load all yaml from director(y|ies) " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerEffect(EffLoadYamlDirectory.class, (String[])new String[]{"[re]load all [y[a]ml] from [(1non[(-| )]relative)] director(y|ies) %strings%", "[re]load all [y[a]ml] from [(1non[(-| )]relative)] director(y|ies) %strings% using [the] filename as [the] id"});
    }
}

