/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import com.leaf.utils.yaml.StringUtil;
import com.leaf.utils.yaml.YAMLFormat;
import com.leaf.utils.yaml.YAMLProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public class EffLoadYaml
extends Effect {
    private Expression<String> file;
    private Expression<String> id;
    private int mark;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(@Nullable Event event) {
        String name = StringUtil.checkSeparator((String)this.file.getSingle(event));
        File yamlFile = null;
        if (this.mark == 1) {
            yamlFile = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            yamlFile = new File(server + File.separator + name);
        }
        if (!yamlFile.exists()) {
            try {
                if (!yamlFile.exists()) {
                    String filePath = yamlFile.getPath();
                    int index = filePath.lastIndexOf(File.separator);
                    File folder = new File(filePath.substring(0, index));
                    if (index >= 0 && !folder.exists()) {
                        folder.mkdirs();
                    }
                    yamlFile.createNewFile();
                }
            }
            catch (IOException error) {
                Leaf.log("[Load Yaml] " + error.getMessage() + " (" + name + ")");
                return;
            }
        }
        YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
        try {
            yaml.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.id != null) {
                Leaf.YAML_STORE.put((String)this.id.getSingle(event), yaml);
            } else {
                Leaf.YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "[re]load yaml " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.id = exprs[1];
        this.mark = parse.mark;
        return true;
    }

    static {
        Skript.registerEffect(EffLoadYaml.class, (String[])new String[]{"[re]load [(1\u00a6non[(-| )]relative)] [y[a]ml] %string% [as %-string%]"});
    }
}

