/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.gui;

import com.leaf.Leaf;
import com.leaf.gui.GUI;
import com.leaf.gui.GUIActionEvent;
import com.leaf.gui.GUIListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIManager {
    private Leaf tuske;
    private Map<Inventory, HashMap<Integer, GUI[]>> invs = new HashMap<Inventory, HashMap<Integer, GUI[]>>();
    private Map<Inventory, Integer> lastSlots = new HashMap<Inventory, Integer>();

    public GUIManager(Leaf tuske) {
        this.tuske = tuske;
    }

    public boolean isGUI(Inventory inv, int slot) {
        return this.invs.containsKey(inv) && this.invs.get(inv).containsKey(slot);
    }

    public boolean hasGUI(Inventory inv) {
        return this.invs.containsKey(inv);
    }

    public GUI getGUI(Inventory inv, int slot, ClickType ct) {
        return this.isGUI(inv, slot) ? this.getGUI(this.invs.get(inv).get(slot), ct) : null;
    }

    public void newGUI(Inventory inv, int slot, ItemStack item, GUI gui) {
        this.addToListener(inv, slot, item, gui);
    }

    private GUI getGUI(GUI[] guis, ClickType ct) {
        int index = this.getIndex(ct);
        return guis[index] != null ? guis[index] : guis[0];
    }

    private void addToListener(Inventory inv, int slot, ItemStack item, GUI gui) {
        GUI[] guis2 = null;
        HashMap<Integer, GUI[]> guislot2 = this.invs.getOrDefault(inv, new HashMap());
        if (slot == -1) {
            Integer s = this.lastSlots.get(inv);
            slot = s != null ? s + 1 : 0;
        } else if (slot == -2) {
            slot = 0;
            for (int x = 0; x < inv.getSize(); ++x) {
                if (guislot2.containsKey(x)) continue;
                slot = x;
                break;
            }
        }
        if (slot >= inv.getSize()) {
            return;
        }
        boolean firstSlot = this.invs.containsKey(inv);
        if (firstSlot && guislot2.containsKey(slot)) {
            ((GUI[])guislot2.get((Object)Integer.valueOf((int)slot)))[this.getIndex((ClickType)gui.getClickType())] = gui;
        } else {
            if (!firstSlot) {
                this.registerListener(inv);
            }
            guis2 = new GUI[ClickType.values().length - 2];
            guis2[this.getIndex((ClickType)gui.getClickType())] = gui;
            guislot2.put(slot, guis2);
        }
        this.invs.put(inv, guislot2);
        this.lastSlots.put(inv, slot);
        inv.setItem(slot, item);
    }

    public void remove(Inventory inv, int slot) {
        inv.setItem(slot, new ItemStack(Material.AIR));
        HashMap<Integer, GUI[]> map = this.invs.get(inv);
        map.remove(slot);
        if (map.size() > 0) {
            this.invs.put(inv, map);
        } else {
            this.invs.remove(inv);
            this.lastSlots.remove(inv);
        }
    }

    public void removeAll(Inventory inv) {
        Map map = this.invs.get(inv);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                inv.setItem(slot, new ItemStack(Material.AIR));
            }
            this.invs.remove(inv);
            this.lastSlots.remove(inv);
        }
    }

    public void clearAll() {
        for (Inventory inv : this.invs.keySet()) {
            for (Integer slot : this.invs.get(inv).keySet()) {
                inv.setItem(slot.intValue(), new ItemStack(Material.AIR));
            }
        }
        this.invs.clear();
        this.lastSlots.clear();
    }

    public boolean isAllowedType(ClickType ct) {
        if (ct != null) {
            switch (ct) {
                case UNKNOWN: 
                case WINDOW_BORDER_RIGHT: 
                case WINDOW_BORDER_LEFT: 
                case CREATIVE: {
                    return false;
                }
            }
        }
        return true;
    }

    private int getIndex(ClickType ct) {
        if (ct == null) {
            return 0;
        }
        int index = ct.ordinal() + 1;
        if (index > 6) {
            index -= 2;
        }
        return index;
    }

    private void registerListener(final Inventory inv) {
        new GUIListener(inv){

            @Override
            public void onClick(InventoryClickEvent e, int slot) {
                if (GUIManager.this.isGUI(inv, slot)) {
                    e.setCancelled(true);
                    GUI gui = GUIManager.this.getGUI(inv, e.getSlot(), e.getClick());
                    if (gui != null && e.getInventory().getItem(e.getSlot()) != null && gui.runOnlyWith(e.getCursor())) {
                        if (gui.toCallEvent()) {
                            GUIActionEvent guie = new GUIActionEvent(e);
                            Bukkit.getPluginManager().callEvent((Event)guie);
                            e.setCancelled(!guie.isCancelled());
                        } else if (gui.toClose()) {
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)GUIManager.this.tuske, () -> {
                                if (gui.getInventory() != null) {
                                    e.getWhoClicked().openInventory(gui.getInventory());
                                } else {
                                    e.getWhoClicked().closeInventory();
                                }
                                if (gui.toRun()) {
                                    gui.run((Event)e);
                                }
                            }, 0L);
                        } else if (gui.toRun()) {
                            gui.run((Event)e);
                        }
                    }
                }
            }

            @Override
            public void onClose(InventoryCloseEvent e) {
                Bukkit.getScheduler().runTaskLater((Plugin)GUIManager.this.tuske, () -> {
                    GUIManager.this.removeAll(e.getInventory());
                    ((Player)e.getPlayer()).updateInventory();
                }, 0L);
            }

            @Override
            public void onDrag(InventoryDragEvent e, int slot) {
                if (GUIManager.this.isGUI(e.getInventory(), slot)) {
                    e.setCancelled(true);
                }
            }
        }.start();
    }
}

