/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.utils.yaml;

import ch.njol.skript.registrations.Classes;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class YAMLNode {
    protected Map<String, Object> root;
    protected List<String> allKeys;
    private boolean writeDefaults;

    public YAMLNode(Map<String, Object> root, boolean writeDefaults) {
        this.root = root;
        this.allKeys = new ArrayList<String>();
        this.writeDefaults = writeDefaults;
    }

    public Map<String, Object> getMap() {
        return this.root;
    }

    public List<String> getAllKeys() {
        return this.allKeys;
    }

    public void clear() {
        this.root.clear();
    }

    @Deprecated
    private Object deserialize(String path, Object o) {
        if (o.toString().contains("__skriptclass__")) {
            YAMLNode n = this.getNode(path + ".__skriptclass__");
            if (n == null) {
                return null;
            }
            for (Object o2 : ((Map)o).values()) {
                Iterator iterator = ((Map)o2).entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry o3 = iterator.next();
                if (((String)o3.getKey()).equals("vector")) {
                    n = this.getNode(path + ".__skriptclass__." + (String)o3.getKey());
                    if (n == null) {
                        return null;
                    }
                    Double x = n.getDouble("x");
                    Double y = n.getDouble("y");
                    Double z = n.getDouble("z");
                    if (x == null || y == null || z == null) {
                        return null;
                    }
                    return new Vector(x.doubleValue(), y.doubleValue(), z.doubleValue());
                }
                if (((String)o3.getKey()).equals("location")) {
                    n = this.getNode(path + ".__skriptclass__." + (String)o3.getKey());
                    if (n == null) {
                        return null;
                    }
                    String w = n.getString("world");
                    Double x = n.getDouble("x");
                    Double y = n.getDouble("y");
                    Double z = n.getDouble("z");
                    Double yaw = n.getDouble("yaw");
                    Double pitch = n.getDouble("pitch");
                    if (w == null | x == null || y == null || z == null || yaw == null || pitch == null) {
                        return null;
                    }
                    return new Location(Bukkit.getServer().getWorld(w), x.doubleValue(), y.doubleValue(), z.doubleValue(), (float)yaw.doubleValue(), (float)pitch.doubleValue());
                }
                return Classes.deserialize((String)((String)o3.getKey()), (byte[])Base64.getDecoder().decode((String)o3.getValue()));
            }
        }
        return o;
    }

    public Object getProperty(String path) {
        if (!path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                return null;
            }
            return this.deserialize(path, val);
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i = 0; i < parts.length; ++i) {
            Object o = node.get(parts[i]);
            if (o == null) {
                return null;
            }
            if (i == parts.length - 1) {
                return this.deserialize(path, o);
            }
            try {
                node = (Map)o;
                continue;
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }

    public void setProperty(String path, Object value) {
        if (!path.contains(".")) {
            this.root.put(path, value);
            if (!this.allKeys.contains(path)) {
                this.allKeys.add(path);
            }
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        if (!this.allKeys.contains(parts[0])) {
            this.allKeys.add(parts[0]);
        }
        if (!this.allKeys.contains(path)) {
            this.allKeys.add(path);
        }
        for (int i = 0; i < parts.length; ++i) {
            LinkedHashMap o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.put((String)parts[i], (Object)value);
                return;
            }
            if (o == null || !(o instanceof Map)) {
                o = new LinkedHashMap();
                node.put(parts[i], o);
            }
            node = o;
        }
    }

    public YAMLNode addNode(String path) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        YAMLNode node = new YAMLNode(map, this.writeDefaults);
        this.setProperty(path, map);
        return node;
    }

    public String getString(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)o.toString());
    }

    public String getString(String path, String def) {
        String o = this.getString(path);
        if (o == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o;
    }

    public Integer getInt(String path) {
        Integer o = YAMLNode.castInt(this.getProperty(path));
        if (o == null) {
            return null;
        }
        return o;
    }

    public int getInt(String path, int def) {
        Integer o = YAMLNode.castInt(this.getProperty(path));
        if (o == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o;
    }

    public Double getDouble(String path) {
        Double o = YAMLNode.castDouble(this.getProperty(path));
        if (o == null) {
            return null;
        }
        return o;
    }

    public double getDouble(String path, double def) {
        Double o = YAMLNode.castDouble(this.getProperty(path));
        if (o == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o;
    }

    public Boolean getBoolean(String path) {
        Boolean o = YAMLNode.castBoolean(this.getProperty(path));
        if (o == null) {
            return null;
        }
        return o;
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean o = YAMLNode.castBoolean(this.getProperty(path));
        if (o == null) {
            if (this.writeDefaults) {
                this.setProperty(path, def);
            }
            return def;
        }
        return o;
    }

    public List<String> getKeys(String path) {
        if (path == null || path.equals("")) {
            return new ArrayList<String>(this.root.keySet());
        }
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return new ArrayList<String>(((Map)o).keySet());
        }
        return null;
    }

    public Map<String, Object> getMap(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    public List<Object> getList(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    public List<String> getStringList(String path, List<String> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            if (this.writeDefaults && def != null) {
                this.setProperty(path, def);
            }
            return def != null ? def : new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public List<Integer> getIntList(String path, List<Integer> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            if (this.writeDefaults && def != null) {
                this.setProperty(path, def);
            }
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = YAMLNode.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Double> getDoubleList(String path, List<Double> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            if (this.writeDefaults && def != null) {
                this.setProperty(path, def);
            }
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o : raw) {
            Double i = YAMLNode.castDouble(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            if (this.writeDefaults && def != null) {
                this.setProperty(path, def);
            }
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o : raw) {
            Boolean tetsu = YAMLNode.castBoolean(o);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    public List<YAMLNode> getNodeList(String path, List<YAMLNode> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            if (this.writeDefaults && def != null) {
                this.setProperty(path, def);
            }
            return def != null ? def : new ArrayList();
        }
        ArrayList<YAMLNode> list = new ArrayList<YAMLNode>();
        for (Object o : raw) {
            if (!(o instanceof Map)) continue;
            list.add(new YAMLNode((Map)o, this.writeDefaults));
        }
        return list;
    }

    @Nullable
    public YAMLNode getNode(String path) {
        if (!path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                return null;
            }
            if (val instanceof Map) {
                return new YAMLNode((Map)val, this.writeDefaults);
            }
            return null;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i = 0; i < parts.length; ++i) {
            Object o = node.get(parts[i]);
            if (o == null) {
                return null;
            }
            if (i == parts.length - 1) {
                if (o instanceof Map) {
                    return new YAMLNode((Map)o, this.writeDefaults);
                }
                return null;
            }
            try {
                node = (Map)o;
                continue;
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }

    public Map<String, YAMLNode> getNodes(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            LinkedHashMap<String, YAMLNode> nodes = new LinkedHashMap<String, YAMLNode>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                if (entry.getValue() instanceof Map) {
                    nodes.put((String)entry.getKey(), new YAMLNode((Map)entry.getValue(), this.writeDefaults));
                    continue;
                }
                nodes.put((String)entry.getKey(), (YAMLNode)null);
            }
            return nodes;
        }
        return null;
    }

    @Nullable
    public static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return null;
    }

    @Nullable
    private static Double castDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return null;
    }

    @Nullable
    private static Boolean castBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    public void removeProperty(String path) {
        if (this.allKeys.contains(path)) {
            this.allKeys.remove(path);
        }
        for (int i = this.allKeys.size() - 1; i >= 0; --i) {
            if (!this.allKeys.get(i).contains(path + ".")) continue;
            this.allKeys.remove(i);
        }
        if (!path.contains(".")) {
            this.root.remove(path);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i = 0; i < parts.length; ++i) {
            Object o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.remove(parts[i]);
                return;
            }
            node = (Map)o;
        }
    }

    public boolean writeDefaults() {
        return this.writeDefaults;
    }

    public void setWriteDefaults(boolean writeDefaults) {
        this.writeDefaults = writeDefaults;
    }
}

