/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.beamer.protocol.beam;

import com.google.common.base.Preconditions;
import me.limeglass.beamer.Beamer;
import me.limeglass.beamer.protocol.IPacketFactory;
import me.limeglass.beamer.protocol.WrappedBeamPacket;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class LocationTargetBeam {
    private final WrappedBeamPacket packetSquidSpawn;
    private final WrappedBeamPacket packetSquidMove;
    private final WrappedBeamPacket packetGuardianSpawn;
    private final WrappedBeamPacket packetGuardianMove;
    private final WrappedBeamPacket packetRemoveEntities;

    public LocationTargetBeam(Location startingPosition, Location endingPosition) {
        Preconditions.checkNotNull((Object)startingPosition, (Object)"startingPosition cannot be null");
        Preconditions.checkNotNull((Object)endingPosition, (Object)"endingPosition cannot be null");
        Preconditions.checkState((boolean)startingPosition.getWorld().equals(endingPosition.getWorld()), (Object)"startingPosition and endingPosition must be in the same world");
        IPacketFactory factory = Beamer.getInstance().getPacketFactory();
        this.packetSquidSpawn = factory.createPacketSquidSpawn(startingPosition);
        this.packetSquidMove = factory.createPacketEntityMove(this.packetSquidSpawn);
        this.packetGuardianSpawn = factory.createPacketGuardianSpawn(endingPosition, this.packetSquidSpawn);
        this.packetGuardianMove = factory.createPacketEntityMove(this.packetGuardianSpawn);
        this.packetRemoveEntities = factory.createPacketRemoveEntities(this.packetSquidSpawn, this.packetGuardianSpawn);
    }

    public void start(Player player) {
        this.packetSquidSpawn.send(player);
        this.packetGuardianSpawn.send(player);
    }

    public void setStartingPosition(Player player, Location location) {
        IPacketFactory factory = Beamer.getInstance().getPacketFactory();
        factory.modifyPacketEntitySpawn(this.packetSquidSpawn, location);
        factory.modifyPacketEntityMove(this.packetSquidMove, location).send(player);
    }

    public void setEndingPosition(Player player, Location location) {
        IPacketFactory factory = Beamer.getInstance().getPacketFactory();
        factory.modifyPacketEntitySpawn(this.packetGuardianSpawn, location);
        factory.modifyPacketEntityMove(this.packetGuardianMove, location).send(player);
    }

    public void cleanup(Player player) {
        this.packetRemoveEntities.send(player);
    }
}

