/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.beamer.protocol.beam;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import me.limeglass.beamer.Beamer;
import me.limeglass.beamer.protocol.beam.LocationTargetBeam;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Beam {
    protected final Set<Player> viewers = new HashSet<Player>();
    protected final Set<Player> playing = new HashSet<Player>();
    protected final LocationTargetBeam beam;
    protected Location starting;
    protected Location ending;
    protected final UUID worldUUID;
    protected final double radius;
    protected final long delay;
    protected BukkitTask task;
    protected boolean active;

    public Beam(Location startingPosition, Location endingPosition) {
        this(startingPosition, endingPosition, 100.0, 5L);
    }

    public Beam(Location starting, Location ending, double radius, long delay) {
        Preconditions.checkState((boolean)starting.getWorld().equals(ending.getWorld()), (Object)"starting position and ending position must be in the same world");
        Preconditions.checkArgument((delay >= 1L ? 1 : 0) != 0, (Object)"update delay must be a natural number");
        Preconditions.checkArgument((radius > 0.0 ? 1 : 0) != 0, (Object)"viewing radius must be positive");
        Preconditions.checkNotNull((Object)starting, (Object)"starting position may not be null");
        Preconditions.checkNotNull((Object)ending, (Object)"ending position may not be null");
        this.beam = new LocationTargetBeam(starting, ending);
        this.worldUUID = starting.getWorld().getUID();
        this.radius = radius * radius;
        this.starting = starting;
        this.ending = ending;
        this.delay = delay;
    }

    public double getRadius() {
        return this.radius;
    }

    public long getUpdateDelay() {
        return this.delay;
    }

    public Set<Player> getViewers() {
        return this.viewers;
    }

    public Set<Player> getPlaying() {
        return this.playing;
    }

    public Location getStartingPosition() {
        return this.starting;
    }

    public boolean hasViewers(Player ... players) {
        for (Player player : players) {
            if (this.viewers.contains(player)) continue;
            return false;
        }
        return true;
    }

    public boolean isPlaying(Player player) {
        return this.playing.contains(player);
    }

    public void addViewers(Player ... players) {
        this.viewers.addAll(Sets.newHashSet((Object[])players));
    }

    public void setStartingPosition(Location location) {
        Preconditions.checkArgument((boolean)location.getWorld().getUID().equals(this.worldUUID), (Object)"location must be in the same world as this beam");
        Iterator<Player> iterator = this.viewers.iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            if (!(player.isOnline() && player.getWorld().getUID().equals(this.worldUUID) && this.isClose(player.getLocation()))) {
                iterator.remove();
                continue;
            }
            this.beam.setStartingPosition(player, location);
        }
        this.starting = location;
    }

    public Location getEndingPosition() {
        return this.ending;
    }

    public void setEndingPosition(Location location) {
        Preconditions.checkArgument((boolean)location.getWorld().getUID().equals(this.worldUUID), (Object)"location must be in the same world as this beam");
        Iterator<Player> iterator = this.viewers.iterator();
        while (iterator.hasNext()) {
            Player player = iterator.next();
            if (!(player.isOnline() && player.getWorld().getUID().equals(this.worldUUID) && this.isClose(player.getLocation()))) {
                iterator.remove();
                continue;
            }
            this.beam.setEndingPosition(player, location);
        }
        this.ending = location;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void start() {
        Preconditions.checkState((!this.active ? 1 : 0) != 0, (Object)"The beam must be disabled in order to start it");
        this.active = true;
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)Beamer.getInstance(), new Runnable(){

            @Override
            public void run() {
                Beam.this.update();
            }
        }, 0L, this.delay);
    }

    public void stop() {
        Preconditions.checkState((boolean)this.active, (Object)"The beam must be enabled in order to stop it");
        this.active = false;
        for (Player player : this.viewers) {
            if (!player.getWorld().getUID().equals(this.worldUUID) || !this.isClose(player.getLocation())) continue;
            this.beam.cleanup(player);
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.viewers.clear();
        this.playing.clear();
        this.task = null;
    }

    public void update() {
        if (!this.active) {
            this.task.cancel();
            return;
        }
        for (Player player : this.viewers) {
            if (!player.getWorld().getUID().equals(this.worldUUID)) {
                this.viewers.remove(player);
                this.beam.cleanup(player);
                return;
            }
            if (this.isClose(player.getLocation())) {
                if (this.playing.contains(player)) continue;
                this.playing.add(player);
                this.beam.start(player);
                continue;
            }
            if (!this.playing.contains(player)) continue;
            this.playing.remove(player);
            this.beam.cleanup(player);
        }
    }

    protected boolean isClose(Location location) {
        return this.starting.distanceSquared(location) <= this.radius || this.ending.distanceSquared(location) <= this.radius;
    }
}

