/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.beamer.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ReflectionUtil {
    public static String getVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3] + ".";
    }

    public static Class<?> getNMSClass(String classString) throws ClassNotFoundException {
        String name = "net.minecraft.server." + ReflectionUtil.getVersion() + classString;
        Class<?> nmsClass = Class.forName(name);
        return nmsClass;
    }

    public static Class<?> getOBCClass(String classString) {
        String name = "org.bukkit.craftbukkit." + ReflectionUtil.getVersion() + classString;
        Class<?> obcClass = null;
        try {
            obcClass = Class.forName(name);
        }
        catch (ClassNotFoundException error) {
            error.printStackTrace();
            return null;
        }
        return obcClass;
    }

    public static Set<Class<?>> getClasses(JarFile jar, String ... packages) {
        HashSet classes = new HashSet();
        try {
            Enumeration<JarEntry> jarEntry = jar.entries();
            while (jarEntry.hasMoreElements()) {
                String name = jarEntry.nextElement().getName().replace("/", ".");
                if (!name.endsWith(".class")) continue;
                String className = name.substring(0, name.length() - 6);
                className = className.replace('/', '.');
                for (String packageName : packages) {
                    if (!name.startsWith(packageName) || !name.endsWith(".class")) continue;
                    classes.add(Class.forName(className));
                }
            }
            jar.close();
        }
        catch (IOException | ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return classes;
    }

    public static Set<Class<?>> getClasses(JavaPlugin instance, String ... packages) {
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            File file = (File)method.invoke((Object)instance, new Object[0]);
            JarFile jar = new JarFile(file);
            return ReflectionUtil.getClasses(jar, packages);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getConnection(Player player) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object nmsPlayer = ReflectionUtil.getHandle(player);
        Field connectionField = nmsPlayer.getClass().getField("playerConnection");
        return connectionField.get(nmsPlayer);
    }

    public static <T> Set<Class<? extends T>> getSubTypesOf(JavaPlugin instance, Class<T> of, String ... packages) {
        return ReflectionUtil.getClasses(instance, packages).parallelStream().filter(clazz -> clazz.isAssignableFrom(of)).map(clazz -> clazz).collect(Collectors.toSet());
    }

    public static <T> boolean setField(Class<T> from, Object obj, String field, Object newValue) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            f.set(obj, newValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T> T getField(String field, Class<?> from, Object obj) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getHandle(Object obj) {
        if (obj != null) {
            try {
                Method getHandle = obj.getClass().getMethod("getHandle", new Class[0]);
                getHandle.setAccessible(true);
                return getHandle.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void sendPacket(Object object, Player ... players) throws NoSuchMethodException {
        try {
            for (Player player : players) {
                Method method = ReflectionUtil.getConnection(player).getClass().getMethod("sendPacket", ReflectionUtil.getNMSClass("Packet"));
                method.invoke(ReflectionUtil.getConnection(player), object);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Object getNMSBlock(Block block) {
        try {
            Method method = ReflectionUtil.getOBCClass("util.CraftMagicNumbers").getDeclaredMethod("getBlock", Block.class);
            method.setAccessible(true);
            return method.invoke(ReflectionUtil.getOBCClass("util.CraftMagicNumbers"), block);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

