/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Callback;
import ch.njol.util.NonNullPair;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Utils {
    public static final Random random = new Random();
    private static final String[][] plurals = new String[][]{{"fe", "ves"}, {"axe", "axes"}, {"x", "xes"}, {"ay", "ays"}, {"ey", "eys"}, {"iy", "iys"}, {"oy", "oys"}, {"uy", "uys"}, {"kie", "kies"}, {"zombie", "zombies"}, {"y", "ies"}, {"h", "hes"}, {"man", "men"}, {"us", "i"}, {"hoe", "hoes"}, {"toe", "toes"}, {"o", "oes"}, {"alias", "aliases"}, {"gas", "gases"}, {"child", "children"}, {"sheep", "sheep"}, {"", "s"}};
    static final ChatColor[] styles = new ChatColor[]{ChatColor.BOLD, ChatColor.ITALIC, ChatColor.STRIKETHROUGH, ChatColor.UNDERLINE, ChatColor.MAGIC, ChatColor.RESET};
    static final Map<String, String> chat = new HashMap<String, String>();
    static final Map<String, String> englishChat = new HashMap<String, String>();
    private static final Pattern stylePattern;

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                boolean english = englishChat.isEmpty();
                chat.clear();
                ChatColor[] chatColorArray = styles;
                int n = styles.length;
                int n2 = 0;
                while (n2 < n) {
                    ChatColor style = chatColorArray[n2];
                    String[] stringArray = Language.getList("chat styles." + style.name());
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        chat.put(s.toLowerCase(), style.toString());
                        if (english) {
                            englishChat.put(s.toLowerCase(), style.toString());
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        stylePattern = Pattern.compile("<([^<>]+)>");
    }

    private Utils() {
    }

    public static String join(Object[] objects) {
        assert (objects != null);
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Classes.toString(objects[i]));
            ++i;
        }
        return b.toString();
    }

    public static String join(Iterable<?> objects) {
        assert (objects != null);
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Object o : objects) {
            if (!first) {
                b.append(", ");
            } else {
                first = false;
            }
            b.append(Classes.toString(o));
        }
        return b.toString();
    }

    public static <T> boolean isEither(@Nullable T compared, T ... types) {
        return CollectionUtils.contains(types, compared);
    }

    @Nullable
    public static <T extends Entity> T getTarget(LivingEntity entity, @Nullable EntityData<T> type) {
        if (entity instanceof Creature) {
            return (T)(((Creature)entity).getTarget() == null || type != null && !type.isInstance((Entity)((Creature)entity).getTarget()) ? null : ((Creature)entity).getTarget());
        }
        Entity target = null;
        double targetDistanceSquared = 0.0;
        double radiusSquared = 1.0;
        Vector l = entity.getEyeLocation().toVector();
        Vector n = entity.getLocation().getDirection().normalize();
        double cos45 = Math.cos(0.7853981633974483);
        for (Entity other : type == null ? entity.getWorld().getEntities() : entity.getWorld().getEntitiesByClass(type.getType())) {
            if (other == null || other == entity || type != null && !type.isInstance(other) || target != null && !(targetDistanceSquared > other.getLocation().distanceSquared(entity.getLocation()))) continue;
            Vector t = other.getLocation().add(0.0, 1.0, 0.0).toVector().subtract(l);
            if (!(n.clone().crossProduct(t).lengthSquared() < 1.0) || !(t.normalize().dot(n) >= cos45)) continue;
            target = other;
            targetDistanceSquared = target.getLocation().distanceSquared(entity.getLocation());
        }
        return (T)target;
    }

    public static Pair<String, Integer> getAmount(String s) {
        if (s.matches("\\d+ of .+")) {
            return new Pair<String, Integer>(s.split(" ", 3)[2], Utils.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], Utils.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], 1);
        }
        return new Pair<String, Integer>(s, -1);
    }

    public static NonNullPair<String, Boolean> getEnglishPlural(String s) {
        assert (s != null);
        if (s.isEmpty()) {
            return new NonNullPair<String, Boolean>("", Boolean.FALSE);
        }
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[1])) {
                return new NonNullPair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0], Boolean.TRUE);
            }
            if (s.endsWith(p[1].toUpperCase())) {
                return new NonNullPair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0].toUpperCase(), Boolean.TRUE);
            }
            ++n2;
        }
        return new NonNullPair<String, Boolean>(s, Boolean.FALSE);
    }

    public static String toEnglishPlural(String s) {
        assert (s != null && s.length() != 0);
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[0])) {
                return String.valueOf(s.substring(0, s.length() - p[0].length())) + p[1];
            }
            ++n2;
        }
        assert (false);
        return String.valueOf(s) + "s";
    }

    public static String toEnglishPlural(String s, boolean p) {
        if (p) {
            return Utils.toEnglishPlural(s);
        }
        return s;
    }

    public static String a(String s) {
        return Utils.a(s, false);
    }

    public static String A(String s) {
        return Utils.a(s, true);
    }

    public static String a(String s, boolean capA) {
        assert (s != null && s.length() != 0);
        if ("aeiouAEIOU".indexOf(s.charAt(0)) != -1) {
            if (capA) {
                return "An " + s;
            }
            return "an " + s;
        }
        if (capA) {
            return "A " + s;
        }
        return "a " + s;
    }

    public static double getBlockHeight(int type, byte data) {
        switch (type) {
            case 26: {
                return 0.5625;
            }
            case 44: 
            case 126: {
                return (data & 8) == 0 ? 0.5 : 1.0;
            }
            case 78: {
                return data == 0 ? 1.0 : (double)(data % 8) * 2.0 / 16.0;
            }
            case 85: 
            case 107: 
            case 113: 
            case 139: {
                return 1.5;
            }
            case 88: {
                return 0.875;
            }
            case 92: {
                return 0.4375;
            }
            case 93: 
            case 94: 
            case 149: 
            case 150: {
                return 0.125;
            }
            case 96: {
                return (data & 4) == 0 ? ((data & 8) == 0 ? 0.1875 : 1.0) : 0.0;
            }
            case 116: {
                return 0.75;
            }
            case 117: {
                return 0.875;
            }
            case 118: {
                return 0.3125;
            }
            case 120: {
                return (data & 4) == 0 ? 0.8125 : 1.0;
            }
            case 127: {
                return 0.75;
            }
            case 140: {
                return 0.375;
            }
            case 144: {
                return 0.5;
            }
            case 151: {
                return 0.375;
            }
            case 154: {
                return 0.625;
            }
        }
        return 1.0;
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(String channel, String ... data) {
        return Utils.sendPluginMessage(channel, (ByteArrayDataInput r) -> true, data);
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(Player player, String channel, String ... data) {
        return Utils.sendPluginMessage(player, channel, (ByteArrayDataInput r) -> true, data);
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(String channel, Predicate<ByteArrayDataInput> messageVerifier, String ... data) {
        Player firstPlayer = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        return Utils.sendPluginMessage(firstPlayer, channel, messageVerifier, data);
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(Player player, String channel, Predicate<ByteArrayDataInput> messageVerifier, String ... data) {
        CompletableFuture<ByteArrayDataInput> completableFuture = new CompletableFuture<ByteArrayDataInput>();
        if (player == null) {
            completableFuture.completeExceptionally(new IllegalStateException("Can't send plugin messages from a null player"));
            return completableFuture;
        }
        Skript skript = Skript.getInstance();
        Messenger messenger = Bukkit.getMessenger();
        messenger.registerOutgoingPluginChannel((Plugin)skript, channel);
        PluginMessageListener listener = (sendingChannel, sendingPlayer, message) -> {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])message);
            if (channel.equals(sendingChannel) && sendingPlayer == player && !completableFuture.isDone() && !completableFuture.isCancelled() && messageVerifier.test(input)) {
                completableFuture.complete(input);
            }
        };
        messenger.registerIncomingPluginChannel((Plugin)skript, channel, listener);
        completableFuture.whenComplete((r, ex) -> messenger.unregisterIncomingPluginChannel((Plugin)skript, channel, listener));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)skript, () -> {
            if (!completableFuture.isDone()) {
                completableFuture.cancel(true);
            }
        }, 1200L);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        Stream.of(data).forEach(arg_0 -> ((ByteArrayDataOutput)out).writeUTF(arg_0));
        player.sendPluginMessage((Plugin)Skript.getInstance(), channel, out.toByteArray());
        return completableFuture;
    }

    @Nullable
    public static String getChatStyle(String s) {
        SkriptColor color = SkriptColor.fromName(s);
        if (color != null) {
            return color.getFormattedChat();
        }
        return chat.get(s);
    }

    public static String replaceChatStyles(String message) {
        if (message.isEmpty()) {
            return message;
        }
        String m = StringUtils.replaceAll((CharSequence)message.replace("<<none>>", ""), stylePattern, new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                SkriptColor color = SkriptColor.fromName(m.group(1));
                if (color != null) {
                    return color.getFormattedChat();
                }
                String f = chat.get(m.group(1).toLowerCase());
                if (f != null) {
                    return f;
                }
                return m.group();
            }
        });
        assert (m != null);
        m = ChatColor.translateAlternateColorCodes((char)'&', (String)m);
        return m;
    }

    public static String replaceEnglishChatStyles(String message) {
        if (message.isEmpty()) {
            return message;
        }
        String m = StringUtils.replaceAll((CharSequence)message, stylePattern, new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                SkriptColor color = SkriptColor.fromName(m.group(1));
                if (color != null) {
                    return color.getFormattedChat();
                }
                String f = englishChat.get(m.group(1).toLowerCase());
                if (f != null) {
                    return f;
                }
                return m.group();
            }
        });
        assert (m != null);
        m = ChatColor.translateAlternateColorCodes((char)'&', (String)m);
        return m;
    }

    public static int random(int start, int end) {
        if (end <= start) {
            throw new IllegalArgumentException("end (" + end + ") must be > start (" + start + ")");
        }
        return start + random.nextInt(end - start);
    }

    public static Class<?> getSuperType(Class<?> ... cs) {
        assert (cs.length > 0);
        Class<?> r = cs[0];
        assert (r != null);
        Class<?>[] classArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Class<?> c = classArray[n2];
                assert (c != null && !c.isArray() && !c.isPrimitive()) : c;
                if (c.isAssignableFrom(r)) {
                    r = c;
                } else if (!r.isAssignableFrom(c)) {
                    Class<?> s = c;
                    while ((s = s.getSuperclass()) != null) {
                        if (s == Object.class || !s.isAssignableFrom(r)) continue;
                        r = s;
                        break block10;
                    }
                    Class<?>[] classArray2 = c.getInterfaces();
                    int n3 = classArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> i = classArray2[n4];
                        s = Utils.getSuperType(i, r);
                        if (s != Object.class) {
                            r = s;
                            break block10;
                        }
                        ++n4;
                    }
                    return Object.class;
                }
            }
            ++n2;
        }
        return r.equals(Cloneable.class) ? Object.class : r;
    }

    public static int parseInt(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }

    public static long parseLong(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    public static Class<?> classForName(String name) {
        try {
            Class<?> c = Class.forName(name);
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found!");
        }
    }
}

