/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.tests.runner;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.tests.runner.TestMode;
import ch.njol.skript.tests.runner.TestTracker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Assert")
@Description(value={"Assert that condition is true. Test fails when it is not."})
@Examples(value={""})
@Since(value="2.5")
public class EffAssert
extends Effect {
    private Condition condition;
    private Expression<String> errorMsg;

    static {
        if (TestMode.ENABLED) {
            Skript.registerEffect(EffAssert.class, "assert <.+> with %string%");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        String cond = parseResult.regexes.get(0).group();
        this.condition = Condition.parse(cond, "Can't understand this condition: " + cond);
        this.errorMsg = exprs[0];
        return this.condition != null;
    }

    @Override
    protected void execute(Event e) {
    }

    @Override
    @Nullable
    public TriggerItem walk(Event e) {
        if (!this.condition.check(e)) {
            String msg = this.errorMsg.getSingle(e);
            TestTracker.testFailed(msg != null ? msg : "assertation failed");
            return null;
        }
        return this.getNext();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "assert " + this.condition.toString(e, debug);
    }
}

