/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.Signature;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Function<T> {
    public static boolean executeWithNulls = SkriptConfig.executeFunctionsWithMissingParams.value();
    final Signature<T> sign;

    public Function(Signature<T> sign) {
        this.sign = sign;
    }

    public Signature<T> getSignature() {
        return this.sign;
    }

    public String getName() {
        return this.sign.getName();
    }

    public Parameter<?>[] getParameters() {
        return this.sign.getParameters();
    }

    public Parameter<?> getParameter(int index) {
        return this.getParameters()[index];
    }

    public boolean isSingle() {
        return this.sign.isSingle();
    }

    @Nullable
    public ClassInfo<T> getReturnType() {
        return this.sign.getReturnType();
    }

    @Nullable
    public final T[] execute(Object[][] params) {
        Object[][] ps;
        Parameter<?>[] parameters;
        if (params.length > 0 && params[0].length == 0) {
            return null;
        }
        FunctionEvent e = new FunctionEvent(this);
        if (Functions.callFunctionEvents) {
            Bukkit.getPluginManager().callEvent(e);
        }
        if (params.length > (parameters = this.sign.getParameters()).length) {
            assert (false) : params.length;
            return null;
        }
        Object[][] objectArray = ps = params.length < parameters.length ? (Object[][])Arrays.copyOf(params, parameters.length) : params;
        assert (ps != null);
        int i = 0;
        while (i < parameters.length) {
            Parameter<?> p = parameters[i];
            Object[] val = ps[i];
            if (val == null) {
                assert (p.def != null);
                val = p.def.getArray(e);
            }
            if (!(executeWithNulls || val != null && val.length != 0)) {
                return null;
            }
            ps[i] = val;
            ++i;
        }
        Object[] r = this.execute(e, ps);
        assert (!(this.sign.getReturnType() == null ? r != null : r != null && (r.length > 1 && this.sign.isSingle() || CollectionUtils.contains(r, null) || !this.sign.getReturnType().getC().isAssignableFrom(r.getClass().getComponentType())))) : this + "; " + Arrays.toString(r);
        return r == null || r.length > 0 ? r : null;
    }

    @Nullable
    public abstract T[] execute(FunctionEvent<?> var1, Object[][] var2);

    public abstract boolean resetReturnValue();

    public String toString() {
        return "function " + this.sign.getName();
    }
}

