/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ExpressionList<T>
implements Expression<T> {
    protected final Expression<? extends T>[] expressions;
    protected boolean and;
    private final boolean single;
    private final Class<T> returnType;
    @Nullable
    private ExpressionList<?> source;
    private int time = 0;

    public ExpressionList(Expression<? extends T>[] expressions, Class<T> returnType, boolean and) {
        this(expressions, returnType, and, null);
    }

    protected ExpressionList(Expression<? extends T>[] expressions, Class<T> returnType, boolean and, @Nullable ExpressionList<?> source) {
        assert (expressions != null);
        this.expressions = expressions;
        this.returnType = returnType;
        this.and = and;
        if (and) {
            this.single = false;
        } else {
            boolean single = true;
            Expression<? extends T>[] expressionArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression<T> e = expressionArray[n2];
                if (!e.isSingle()) {
                    single = false;
                    break;
                }
                ++n2;
            }
            this.single = single;
        }
        this.source = source;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public T getSingle(Event e) {
        if (!this.single) {
            throw new UnsupportedOperationException();
        }
        int[] nArray = CollectionUtils.permutation(this.expressions.length);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            T t = this.expressions[i].getSingle(e);
            if (t != null) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public T[] getArray(Event e) {
        if (this.and) {
            return this.getAll(e);
        }
        int[] nArray = CollectionUtils.permutation(this.expressions.length);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            T[] t = this.expressions[i].getArray(e);
            if (t.length > 0) {
                return t;
            }
            ++n2;
        }
        Object[] r = (Object[])Array.newInstance(this.returnType, 0);
        assert (r != null);
        return r;
    }

    @Override
    public T[] getAll(Event e) {
        ArrayList<T> r = new ArrayList<T>();
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<T> expr = expressionArray[n2];
            r.addAll(Arrays.asList(expr.getAll(e)));
            ++n2;
        }
        return r.toArray((Object[])Array.newInstance(this.returnType, r.size()));
    }

    @Override
    @Nullable
    public Iterator<? extends T> iterator(final Event e) {
        if (!this.and) {
            int[] nArray = CollectionUtils.permutation(this.expressions.length);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                Iterator<T> t = this.expressions[i].iterator(e);
                if (t != null && t.hasNext()) {
                    return t;
                }
                ++n2;
            }
            return null;
        }
        return new Iterator<T>(){
            private int i = 0;
            @Nullable
            private Iterator<? extends T> current = null;

            @Override
            public boolean hasNext() {
                Iterator c = this.current;
                while (!(this.i >= ExpressionList.this.expressions.length || c != null && c.hasNext())) {
                    c = ExpressionList.this.expressions[this.i++].iterator(e);
                    this.current = c;
                }
                return c != null && c.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator c = this.current;
                if (c == null) {
                    throw new NoSuchElementException();
                }
                Object t = c.next();
                if (!$assertionsDisabled && t == null) {
                    throw new AssertionError(this.current);
                }
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isSingle() {
        return this.single;
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return negated ^ this.check(e, c);
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<? super T> expr = expressionArray[n2];
            Boolean b = expr.check(e, c);
            if (this.and && !b.booleanValue()) {
                return false;
            }
            if (!this.and && b.booleanValue()) {
                return true;
            }
            ++n2;
        }
        return this.and;
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        Expression[] exprs = new Expression[this.expressions.length];
        int i = 0;
        while (i < exprs.length) {
            exprs[i] = this.expressions[i].getConvertedExpression(to);
            if (exprs[i] == null) {
                return null;
            }
            ++i;
        }
        return new ExpressionList(exprs, Utils.getSuperType(to), this.and, this);
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean getAnd() {
        return this.and;
    }

    public boolean setAnd(boolean and) {
        boolean r = and;
        this.and = and;
        return r;
    }

    public void invertAnd() {
        this.and = !this.and;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class<?>[] l = this.expressions[0].acceptChange(mode);
        if (l == null) {
            return null;
        }
        ArrayList r = new ArrayList(Arrays.asList(l));
        int i = 1;
        while (i < this.expressions.length) {
            l = this.expressions[i].acceptChange(mode);
            if (l == null) {
                return null;
            }
            r.retainAll(Arrays.asList(l));
            if (r.isEmpty()) {
                return null;
            }
            ++i;
        }
        return r.toArray(new Class[r.size()]);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (delta == null || delta.length < this.expressions.length) {
            Expression<? extends T>[] expressionArray = this.expressions;
            int n = this.expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression<T> expr = expressionArray[n2];
                expr.change(e, delta, mode);
                ++n2;
            }
        } else {
            int i = 0;
            while (i < this.expressions.length) {
                Expression<T> expr = this.expressions[i];
                expr.change(e, new Object[]{delta[i]}, mode);
                ++i;
            }
        }
    }

    @Override
    public boolean setTime(int time) {
        boolean ok = false;
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<T> e = expressionArray[n2];
            ok |= e.setTime(time);
            ++n2;
        }
        if (ok) {
            this.time = time;
        }
        return ok;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isLoopOf(String s) {
        Expression<? extends T>[] expressionArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<T> e = expressionArray[n2];
            if (e.isLoopOf(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Expression<?> getSource() {
        ExpressionList<?> s = this.source;
        return s == null ? this : s;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        StringBuilder b = new StringBuilder("(");
        int i = 0;
        while (i < this.expressions.length) {
            if (i != 0) {
                if (i == this.expressions.length - 1) {
                    b.append(this.and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(this.expressions[i].toString(e, debug));
            ++i;
        }
        b.append(")");
        if (debug) {
            b.append("[").append(this.returnType).append("]");
        }
        return "" + b;
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    public Expression<? extends T>[] getExpressions() {
        return this.expressions;
    }

    @Override
    public Expression<T> simplify() {
        boolean isLiteralList = true;
        boolean isSimpleList = true;
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i] = this.expressions[i].simplify();
            isLiteralList &= this.expressions[i] instanceof Literal;
            isSimpleList &= this.expressions[i].isSingle();
            ++i;
        }
        if (isLiteralList && isSimpleList) {
            Object[] values = (Object[])Array.newInstance(this.returnType, this.expressions.length);
            int i2 = 0;
            while (i2 < values.length) {
                values[i2] = ((Literal)this.expressions[i2]).getSingle();
                ++i2;
            }
            return new SimpleLiteral<Object>(values, this.returnType, this.and);
        }
        if (isLiteralList) {
            Literal[] ls = (Literal[])Arrays.copyOf(this.expressions, this.expressions.length, Literal[].class);
            assert (ls != null);
            return new LiteralList<T>(ls, this.returnType, this.and);
        }
        return this;
    }
}

