/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Checker;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public interface Expression<T>
extends SyntaxElement,
Debuggable {
    @Nullable
    public T getSingle(Event var1);

    public T[] getArray(Event var1);

    public T[] getAll(Event var1);

    default public Stream<? extends T> stream(Event e) {
        Iterator<T> iter = this.iterator(e);
        if (iter == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 0), false);
    }

    public boolean isSingle();

    public boolean check(Event var1, Checker<? super T> var2, boolean var3);

    public boolean check(Event var1, Checker<? super T> var2);

    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... var1);

    public Class<? extends T> getReturnType();

    public boolean getAnd();

    public boolean setTime(int var1);

    public int getTime();

    public boolean isDefault();

    @Nullable
    public Iterator<? extends T> iterator(Event var1);

    public boolean isLoopOf(String var1);

    public Expression<?> getSource();

    public Expression<? extends T> simplify();

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode var1);

    public void change(Event var1, @Nullable Object[] var2, Changer.ChangeMode var3);

    @Nullable
    default public Object[] beforeChange(Expression<?> changed, @Nullable Object[] delta) {
        if (delta == null || delta.length == 0) {
            return null;
        }
        Object[] newDelta = null;
        if (changed instanceof Variable) {
            int i = 0;
            while (i < delta.length) {
                Object value = delta[i];
                if (value instanceof Slot) {
                    ItemStack item = ((Slot)value).getItem();
                    if (item != null) {
                        item = item.clone();
                    }
                    if (newDelta == null) {
                        newDelta = new Object[delta.length];
                        System.arraycopy(delta, 0, newDelta, 0, delta.length);
                    }
                    newDelta[i] = item;
                } else if (value instanceof ItemType) {
                    if (newDelta == null) {
                        newDelta = new Object[delta.length];
                        System.arraycopy(delta, 0, newDelta, 0, delta.length);
                    }
                    newDelta[i] = ((ItemType)value).clone();
                } else if (value instanceof ItemStack) {
                    if (newDelta == null) {
                        newDelta = new Object[delta.length];
                        System.arraycopy(delta, 0, newDelta, 0, delta.length);
                    }
                    newDelta[i] = ((ItemStack)value).clone();
                }
                ++i;
            }
        }
        return newDelta == null ? delta : newDelta;
    }
}

