/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Length")
@Description(value={"Gets or sets the length of a vector."})
@Examples(value={"send \"%standard length of vector 1, 2, 3%\"", "set {_v} to vector 1, 2, 3", "set standard length of {_v} to 2", "send \"%standard length of {_v}%\""})
@Since(value="2.2-dev28")
public class ExprVectorLength
extends SimplePropertyExpression<Vector, Number> {
    static {
        ExprVectorLength.register(ExprVectorLength.class, Number.class, "(vector|standard|normal) length[s]", "vectors");
    }

    @Override
    public Double convert(Vector vector) {
        return vector.length();
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        Vector v = (Vector)this.getExpr().getSingle(e);
        if (v == null) {
            return;
        }
        double n = ((Number)delta[0]).doubleValue();
        switch (mode) {
            case ADD: {
                if (n < 0.0 && v.lengthSquared() < n * n) {
                    v.zero();
                } else {
                    double l = n + v.length();
                    v.normalize().multiply(l);
                }
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case REMOVE: {
                n = -n;
            }
            case SET: {
                if (n < 0.0) {
                    v.zero();
                } else {
                    v.normalize().multiply(n);
                }
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
            }
        }
    }

    @Override
    protected String getPropertyName() {
        return "vector length";
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }
}

