/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Create from XYZ")
@Description(value={"Creates a vector from x, y and z values."})
@Examples(value={"set {_v} to vector 0, 1, 0"})
@Since(value="2.2-dev28")
public class ExprVectorFromXYZ
extends SimpleExpression<Vector> {
    private Expression<Number> x;
    private Expression<Number> y;
    private Expression<Number> z;

    static {
        Skript.registerExpression(ExprVectorFromXYZ.class, Vector.class, ExpressionType.SIMPLE, "[a] [new] vector [(from|at|to)] %number%,[ ]%number%(,[ ]| and )%number%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.x = exprs[0];
        this.y = exprs[1];
        this.z = exprs[2];
        return true;
    }

    protected Vector[] get(Event e) {
        Number x = this.x.getSingle(e);
        Number y = this.y.getSingle(e);
        Number z = this.z.getSingle(e);
        if (x == null || y == null || z == null) {
            return null;
        }
        return CollectionUtils.array(new Vector(x.doubleValue(), y.doubleValue(), z.doubleValue()));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "vector from x " + this.x.toString(e, debug) + ", y " + this.y.toString(e, debug) + ", z " + this.z.toString(e, debug);
    }
}

