/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Dot Product")
@Description(value={"Gets the dot product between two vectors."})
@Examples(value={"set {_v} to {_v2} dot {_v3}"})
@Since(value="2.2-dev28")
public class ExprVectorDotProduct
extends SimpleExpression<Number> {
    private Expression<Vector> first;
    private Expression<Vector> second;

    static {
        Skript.registerExpression(ExprVectorDotProduct.class, Number.class, ExpressionType.SIMPLE, "%vector% dot %vector%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        return true;
    }

    protected Double[] get(Event e) {
        Vector v1 = this.first.getSingle(e);
        Vector v2 = this.second.getSingle(e);
        if (v1 == null || v2 == null) {
            return null;
        }
        return CollectionUtils.array(v1.getX() * v2.getX() + v1.getY() * v2.getY() + v1.getZ() * v2.getZ());
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.first.toString(e, debug)) + " dot " + this.second.toString(e, debug);
    }
}

