/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="No Damage Ticks")
@Description(value={"The number of ticks that an entity is invulnerable to damage for."})
@Examples(value={"on damage:", "\tset victim's invulnerability ticks to 20 #Victim will not take damage for the next second"})
@Since(value="2.5")
public class ExprNoDamageTicks
extends SimplePropertyExpression<LivingEntity, Number> {
    static {
        ExprNoDamageTicks.register(ExprNoDamageTicks.class, Number.class, "(invulnerability|no damage) tick[s]", "livingentities");
    }

    @Override
    public Number convert(LivingEntity e) {
        return e.getNoDamageTicks();
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int d = delta == null ? 0 : ((Number)delta[0]).intValue();
        LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity le = livingEntityArray[n2];
            switch (mode) {
                case ADD: {
                    int r1 = le.getNoDamageTicks() + d;
                    if (r1 < 0) {
                        r1 = 0;
                    }
                    le.setNoDamageTicks(r1);
                    break;
                }
                case SET: {
                    le.setNoDamageTicks(d);
                    break;
                }
                case DELETE: 
                case RESET: {
                    le.setNoDamageTicks(0);
                    break;
                }
                case REMOVE: {
                    int r2 = le.getNoDamageTicks() - d;
                    if (r2 < 0) {
                        r2 = 0;
                    }
                    le.setNoDamageTicks(r2);
                    break;
                }
                case REMOVE_ALL: {
                    assert (false);
                    break;
                }
            }
            ++n2;
        }
    }

    @Override
    protected String getPropertyName() {
        return "no damage ticks";
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }
}

