/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Name / Display Name")
@Description(value={"Represents the Minecraft account, display or tab list name of a player, or the custom name of an item, entity or inventory.", "", "<ul>", "\t<li><strong>Players</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name:</strong> The Minecraft account name of the player. Can't be changed, but 'display name' can be changed.</li>", "\t\t\t<li><strong>Display Name:</strong> The name of the player that is displayed in messages. This name can be changed freely and can include colour codes, and is shared among all plugins (e.g. chat plugins will use the display name).</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Entities</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name:</strong> The custom name of the entity. Can be changed. But for living entities, the players will have to target the entity to see its name tag. For non-living entities, the name will not be visible at all. To prevent this, use 'display name'.</li>", "\t\t\t<li><strong>Display Name:</strong> The custom name of the entity. Can be changed, which will also enable <em>custom name visibility</em> of the entity so name tag of the entity will be visible always.</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Items</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name and Display Name:</strong> The <em>custom</em> name of the item (not the Minecraft locale name). Can be changed.</li>", "\t\t</ul>", "\t</li>", "\t<li><strong>Inventories</strong>", "\t\t<ul>", "\t\t\t<li><strong>Name and Display Name:</strong> The name/title of the inventory. Changing name of an inventory means opening the same inventory with the same contents but with a different name to its current viewers.</li>", "\t\t</ul>", "\t</li>", "</ul>"})
@Examples(value={"on join:", "\tplayer has permission \"name.red\"", "\tset the player's display name to \"<red>[admin] <gold>%name of player%\"", "\tset the player's tab list name to \"<green>%player's name%\"", "set the name of the player's tool to \"Legendary Sword of Awesomeness\""})
@Since(value="before 2.1, 2.2-dev20 (inventory name), 2.4 (non-living entity support, changeable inventory name)")
public class ExprName
extends SimplePropertyExpression<Object, String> {
    @Nullable
    static final MethodHandle TITLE_METHOD;
    private static final int ITEM = 1;
    private static final int ENTITY = 2;
    private static final int PLAYER = 4;
    private static final int INVENTORY = 8;
    static final String[] types;
    private NameType type;
    private int changeType = 0;

    static {
        MethodHandle _METHOD = null;
        try {
            _METHOD = MethodHandles.lookup().findVirtual(Inventory.class, "getTitle", MethodType.methodType(String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        TITLE_METHOD = _METHOD;
        types = new String[]{"itemstacks/slots", "entities", "players", "inventories"};
        NameType[] nameTypeArray = NameType.values();
        int n = nameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NameType n3 = nameTypeArray[n2];
            ExprName.register(ExprName.class, String.class, n3.pattern, n3.getFrom());
            ++n2;
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = NameType.values()[parseResult.mark];
        if (exprs[0] instanceof Variable) {
            this.setExpr(exprs[0].getConvertedExpression(Object.class));
        } else {
            this.setExpr(exprs[0]);
        }
        return true;
    }

    @Override
    @Nullable
    public String convert(Object o) {
        return this.type.get(o instanceof Slot ? ((Slot)o).getItem() : o);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE && (this.type.acceptChange & 0xFFFFFFFB) != 0 || mode == Changer.ChangeMode.RESET) {
            return new Class[0];
        }
        if (mode != Changer.ChangeMode.SET) {
            return null;
        }
        if ((this.type.acceptChange & 4) != 0 && Player.class.isAssignableFrom(this.getExpr().getReturnType())) {
            this.changeType = 4;
        } else if ((this.type.acceptChange & 8) != 0 && Inventory.class.isAssignableFrom(this.getExpr().getReturnType())) {
            this.changeType = 8;
        } else if ((this.type.acceptChange & 1) != 0 && (this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, ItemStack.class, ItemType.class) || Slot.class.isAssignableFrom(this.getExpr().getReturnType()))) {
            this.changeType = 1;
        } else if ((this.type.acceptChange & 2) != 0 && Entity.class.isAssignableFrom(this.getExpr().getReturnType())) {
            if (this.type == NameType.NAME && Player.class.isAssignableFrom(this.getExpr().getReturnType())) {
                Skript.error("Can't change the Minecraft name of a player. Change the 'display name' or 'tab list name' instead.");
                return null;
            }
            this.changeType = 2;
        }
        return this.changeType == 0 ? null : CollectionUtils.array(String.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String name;
        String string = name = delta == null ? null : (String)delta[0];
        if (this.changeType == 1) {
            if (Slot.class.isAssignableFrom(this.getExpr().getReturnType())) {
                Slot[] slotArray = (Slot[])this.getExpr().getArray(e);
                int n = slotArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot s = slotArray[n2];
                    ItemStack i = s.getItem();
                    this.type.set(i, name);
                    s.setItem(i);
                    ++n2;
                }
            } else {
                Object i = this.getExpr().getSingle(e);
                if (i instanceof ItemType) {
                    this.type.set(i, name);
                    this.getExpr().change(e, new ItemType[]{(ItemType)i}, Changer.ChangeMode.SET);
                    return;
                }
                if (!(i instanceof ItemStack) && !(i instanceof Slot)) {
                    return;
                }
                ItemStack is = i instanceof Slot ? ((Slot)i).getItem() : (ItemStack)i;
                this.type.set(is, name);
                if (i instanceof Slot) {
                    ((Slot)i).setItem(is);
                } else if (Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, ItemStack.class)) {
                    this.getExpr().change(e, new Object[]{i}, Changer.ChangeMode.SET);
                } else {
                    this.getExpr().change(e, new ItemType[]{new ItemType((ItemStack)i)}, Changer.ChangeMode.SET);
                }
            }
        } else {
            F[] FArray = this.getExpr().getArray(e);
            int n = FArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object o = FArray[n3];
                if (o instanceof Entity || o instanceof Inventory) {
                    this.type.set(o, name);
                }
                ++n3;
            }
        }
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return this.type.name;
    }

    private static abstract class NameType
    extends Enum<NameType> {
        public static final /* enum */ NameType NAME = new NameType("name", "name[s]", 15, 11){

            @Override
            void set(@Nullable Object o, @Nullable String name) {
                if (o == null) {
                    return;
                }
                if (o instanceof Entity) {
                    ((Entity)o).setCustomName(name);
                    if (o instanceof LivingEntity) {
                        ((LivingEntity)o).setRemoveWhenFarAway(name == null);
                    }
                } else if (o instanceof ItemType) {
                    ItemMeta m = ((ItemType)o).getItemMeta();
                    m.setDisplayName(name);
                    ((ItemType)o).setItemMeta(m);
                } else if (o instanceof ItemStack) {
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    if (m != null) {
                        m.setDisplayName(name);
                        ((ItemStack)o).setItemMeta(m);
                    }
                } else if (o instanceof Inventory) {
                    Inventory inventory = (Inventory)o;
                    ArrayList viewers = new ArrayList(inventory.getViewers());
                    if (viewers.isEmpty()) {
                        return;
                    }
                    InventoryType invType = inventory.getType();
                    if (!invType.isCreatable()) {
                        return;
                    }
                    Inventory copy = invType == InventoryType.CHEST ? (name == null ? Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize()) : Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize(), (String)name)) : (name == null ? Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)invType) : Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)invType, (String)name));
                    copy.setContents(inventory.getContents());
                    viewers.forEach(human -> {
                        InventoryView inventoryView = human.openInventory(copy);
                    });
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            String get(@Nullable Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getName();
                }
                if (o instanceof Entity) {
                    return ((Entity)o).getCustomName();
                }
                if (o instanceof ItemType) {
                    ItemMeta m = ((ItemType)o).getItemMeta();
                    return !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (o instanceof ItemStack) {
                    if (!((ItemStack)o).hasItemMeta()) {
                        return null;
                    }
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    return m == null || !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (o instanceof Inventory) {
                    if (TITLE_METHOD != null) {
                        try {
                            return TITLE_METHOD.invoke(o);
                        }
                        catch (IllegalAccessException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            return null;
                        }
                        catch (Throwable e) {
                            Skript.exception(e, new String[0]);
                            return null;
                        }
                    }
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        public static final /* enum */ NameType DISPLAY_NAME = new NameType("display name", "(display|nick|chat)[ ]name[s]", 15, 15){

            @Override
            void set(@Nullable Object o, @Nullable String name) {
                if (o == null) {
                    return;
                }
                if (o instanceof Player) {
                    ((Player)o).setDisplayName(name == null ? ((Player)o).getName() : String.valueOf(name) + ChatColor.RESET);
                } else if (o instanceof Entity) {
                    ((Entity)o).setCustomName(name);
                    ((Entity)o).setCustomNameVisible(name != null);
                    if (o instanceof LivingEntity) {
                        ((LivingEntity)o).setRemoveWhenFarAway(name == null);
                    }
                } else if (o instanceof ItemStack) {
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    if (m != null) {
                        m.setDisplayName(name);
                        ((ItemStack)o).setItemMeta(m);
                    }
                } else if (o instanceof Inventory) {
                    Inventory inventory = (Inventory)o;
                    ArrayList viewers = new ArrayList(inventory.getViewers());
                    if (viewers.isEmpty()) {
                        return;
                    }
                    InventoryType invType = inventory.getType();
                    if (!invType.isCreatable()) {
                        return;
                    }
                    Inventory copy = invType == InventoryType.CHEST ? (name == null ? Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize()) : Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize(), (String)name)) : (name == null ? Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)invType) : Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)invType, (String)name));
                    copy.setContents(inventory.getContents());
                    viewers.forEach(human -> {
                        InventoryView inventoryView = human.openInventory(copy);
                    });
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            String get(@Nullable Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getDisplayName();
                }
                if (o instanceof Entity) {
                    return ((Entity)o).getCustomName();
                }
                if (o instanceof ItemStack) {
                    if (!((ItemStack)o).hasItemMeta()) {
                        return null;
                    }
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    return m == null || !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (o instanceof Inventory) {
                    if (TITLE_METHOD != null) {
                        try {
                            return TITLE_METHOD.invoke(o);
                        }
                        catch (IllegalAccessException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            return null;
                        }
                        catch (Throwable e) {
                            Skript.exception(e, new String[0]);
                            return null;
                        }
                    }
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        public static final /* enum */ NameType TABLIST_NAME = new NameType("player list name", "(player|tab)[ ]list name[s]", 4, 4){

            @Override
            void set(@Nullable Object o, @Nullable String name) {
                if (o == null) {
                    return;
                }
                if (o instanceof Player) {
                    try {
                        ((Player)o).setPlayerListName(name == null ? "" : name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            String get(@Nullable Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getPlayerListName();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        final String name;
        final String pattern;
        final int from;
        final int acceptChange;
        private static final /* synthetic */ NameType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new NameType[]{NAME, DISPLAY_NAME, TABLIST_NAME};
        }

        private NameType(String name, String pattern, int from, int change) {
            this.name = name;
            this.pattern = "(" + this.ordinal() + "\u00a6)" + pattern;
            this.from = from;
            this.acceptChange = change;
        }

        abstract void set(@Nullable Object var1, @Nullable String var2);

        @Nullable
        abstract String get(@Nullable Object var1);

        String getFrom() {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < types.length) {
                if ((this.from & 1 << i) != 0 && (1 << i != 1 || Skript.isRunningMinecraft(1, 4, 5)) && (1 << i != 2 || Skript.isRunningMinecraft(1, 5))) {
                    if (b.length() != 0) {
                        b.append("/");
                    }
                    b.append(types[i]);
                }
                ++i;
            }
            return "" + b;
        }

        public static NameType[] values() {
            NameType[] nameTypeArray = ENUM$VALUES;
            int n = nameTypeArray.length;
            NameType[] nameTypeArray2 = new NameType[n];
            System.arraycopy(ENUM$VALUES, 0, nameTypeArray2, 0, n);
            return nameTypeArray2;
        }

        public static NameType valueOf(String string) {
            return Enum.valueOf(NameType.class, string);
        }
    }
}

