/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Lore")
@Description(value={"An item's lore."})
@Examples(value={"set the 1st line of the item's lore to \"<orange>Excalibur 2.0\""})
@Since(value="2.1")
public class ExprLore
extends SimpleExpression<String> {
    @Nullable
    private Expression<Number> lineNumber;
    private Expression<?> item;

    static {
        Skript.registerExpression(ExprLore.class, String.class, ExpressionType.PROPERTY, "[the] lore of %itemstack/itemtype%", "%itemstack/itemtype%'[s] lore", "[the] line %number% of [the] lore of %itemstack/itemtype%", "[the] line %number% of %itemstack/itemtype%'[s] lore", "[the] %number%(st|nd|rd|th) line of [the] lore of %itemstack/itemtype%", "[the] %number%(st|nd|rd|th) line of %itemstack/itemtype%'[s] lore");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.lineNumber = exprs.length > 1 ? exprs[0] : null;
        this.item = exprs[exprs.length - 1];
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        ItemMeta meta;
        Number n;
        Object i = this.item.getSingle(e);
        Number number = n = this.lineNumber != null ? (Number)this.lineNumber.getSingle(e) : (Number)null;
        if (n == null && this.lineNumber != null) {
            return null;
        }
        if (i == null || i instanceof ItemStack && ((ItemStack)i).getType() == Material.AIR) {
            return new String[0];
        }
        ItemMeta itemMeta = meta = i instanceof ItemStack ? ((ItemStack)i).getItemMeta() : ((ItemType)i).getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return new String[0];
        }
        List lore = meta.getLore();
        assert (lore != null);
        if (n == null) {
            return lore.toArray(new String[0]);
        }
        int l = n.intValue() - 1;
        if (l < 0 || l >= lore.size()) {
            return new String[0];
        }
        return new String[]{(String)lore.get(l)};
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        boolean acceptsMany = this.lineNumber == null;
        switch (mode) {
            case REMOVE: 
            case REMOVE_ALL: 
            case DELETE: {
                acceptsMany = false;
            }
            case ADD: 
            case SET: {
                if (Changer.ChangerUtils.acceptsChange(this.item, Changer.ChangeMode.SET, ItemStack.class, ItemType.class)) {
                    return CollectionUtils.array(acceptsMany ? String[].class : String.class);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Object[] itemDelta;
        List<Object> lore;
        ItemMeta meta;
        String[] stringDelta;
        Object i = this.item.getSingle(e);
        String[] stringArray = stringDelta = delta == null ? null : (String[])Arrays.copyOf(delta, delta.length, String[].class);
        if (i == null || i instanceof ItemStack && ((ItemStack)i).getType() == Material.AIR) {
            return;
        }
        ItemMeta itemMeta = meta = i instanceof ItemStack ? ((ItemStack)i).getItemMeta() : ((ItemType)i).getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(Material.STONE);
        }
        Number lineNumber = this.lineNumber != null ? (Number)this.lineNumber.getSingle(e) : (Number)null;
        ArrayList arrayList = lore = meta.hasLore() ? new ArrayList(meta.getLore()) : new ArrayList();
        if (lineNumber == null) {
            if (this.lineNumber != null) {
                return;
            }
            switch (mode) {
                case SET: {
                    assert (stringDelta != null);
                    ArrayList<String> newLore = new ArrayList<String>();
                    String[] stringArray2 = stringDelta;
                    int n = stringDelta.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray2[n2];
                        if (line.contains("\n")) {
                            Collections.addAll(newLore, line.split("\n"));
                        } else {
                            newLore.add(line);
                        }
                        ++n2;
                    }
                    lore = newLore;
                    break;
                }
                case ADD: {
                    assert (stringDelta != null);
                    ArrayList<String> addLore = new ArrayList<String>();
                    String[] stringArray3 = stringDelta;
                    int n = stringDelta.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String line = stringArray3[n3];
                        if (line.contains("\n")) {
                            Collections.addAll(addLore, line.split("\n"));
                        } else {
                            addLore.add(line);
                        }
                        ++n3;
                    }
                    lore.addAll(addLore);
                    break;
                }
                case DELETE: {
                    lore = null;
                    break;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    assert (stringDelta != null);
                    lore = Arrays.asList(this.handleRemove(StringUtils.join(lore, "\n"), stringDelta[0], mode == Changer.ChangeMode.REMOVE_ALL).split("\n"));
                    break;
                }
                case RESET: {
                    assert (false);
                    return;
                }
            }
        } else {
            int lineNum = Math2.fit(0, lineNumber.intValue() - 1, 99);
            while (lore.size() <= lineNum) {
                lore.add("");
            }
            switch (mode) {
                case SET: {
                    assert (stringDelta != null);
                    lore.set(lineNum, stringDelta[0]);
                    break;
                }
                case ADD: {
                    assert (stringDelta != null);
                    lore.set(lineNum, String.valueOf((String)lore.get(lineNum)) + stringDelta[0]);
                    break;
                }
                case DELETE: {
                    lore.remove(lineNum);
                    break;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    assert (stringDelta != null);
                    lore.set(lineNum, this.handleRemove((String)lore.get(lineNum), stringDelta[0], mode == Changer.ChangeMode.REMOVE_ALL));
                    break;
                }
                case RESET: {
                    assert (false);
                    return;
                }
            }
        }
        meta.setLore(lore == null || lore.size() == 0 ? null : lore);
        if (i instanceof ItemStack) {
            ((ItemStack)i).setItemMeta(meta);
        } else {
            ((ItemType)i).setItemMeta(meta);
        }
        if (Changer.ChangerUtils.acceptsChange(this.item, Changer.ChangeMode.SET, i.getClass())) {
            Object[] objectArray;
            if (i instanceof ItemStack) {
                ItemStack[] itemStackArray = new ItemStack[1];
                objectArray = itemStackArray;
                itemStackArray[0] = (ItemStack)i;
            } else {
                ItemType[] itemTypeArray = new ItemType[1];
                objectArray = itemTypeArray;
                itemTypeArray[0] = (ItemType)i;
            }
            itemDelta = objectArray;
            this.item.change(e, itemDelta, Changer.ChangeMode.SET);
        } else {
            ItemType[] itemTypeArray;
            if (i instanceof ItemStack) {
                ItemType[] itemTypeArray2 = new ItemType[1];
                itemTypeArray = itemTypeArray2;
                itemTypeArray2[0] = new ItemType((ItemStack)i);
            } else {
                ItemStack[] itemStackArray = new ItemStack[1];
                itemTypeArray = itemStackArray;
                itemStackArray[0] = ((ItemType)i).getRandom();
            }
            itemDelta = itemTypeArray;
            this.item.change(e, itemDelta, Changer.ChangeMode.SET);
        }
    }

    private String handleRemove(String input, String toRemove, boolean all) {
        if (SkriptConfig.caseSensitive.value().booleanValue()) {
            if (all) {
                return input.replace(toRemove, "");
            }
            return input.replaceFirst(Pattern.quote(toRemove), "");
        }
        Matcher m = Pattern.compile(Pattern.quote(toRemove), 66).matcher(input);
        return all ? m.replaceAll("") : m.replaceFirst("");
    }

    @Override
    public boolean isSingle() {
        return this.lineNumber != null;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.lineNumber != null ? "the line " + this.lineNumber.toString(e, debug) + " of " : "") + "the lore of " + this.item.toString(e, debug);
    }
}

