/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Creeper Max Fuse Ticks")
@Description(value={"The max fuse ticks that a creeper has."})
@Examples(value={"set target entity's max fuse ticks to 20 #1 second"})
@Since(value="2.5")
public class ExprCreeperMaxFuseTicks
extends SimplePropertyExpression<LivingEntity, Number> {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !ExprCreeperMaxFuseTicks.class.desiredAssertionStatus();
        if (Skript.methodExists(LivingEntity.class, "getMaxFuseTicks", new Class[0])) {
            ExprCreeperMaxFuseTicks.register(ExprCreeperMaxFuseTicks.class, Number.class, "[creeper] max[imum] fuse tick[s]", "livingentities");
        }
    }

    @Override
    public Number convert(LivingEntity e) {
        return e instanceof Creeper ? ((Creeper)e).getMaxFuseTicks() : 0;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int d = delta == null ? 0 : ((Number)delta[0]).intValue();
        LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity le = livingEntityArray[n2];
            if (le instanceof Creeper) {
                Creeper c = (Creeper)le;
                switch (mode) {
                    case ADD: {
                        int r1 = c.getMaxFuseTicks() + d;
                        if (r1 < 0) {
                            r1 = 0;
                        }
                        c.setMaxFuseTicks(r1);
                        break;
                    }
                    case SET: {
                        c.setMaxFuseTicks(d);
                        break;
                    }
                    case DELETE: {
                        c.setMaxFuseTicks(0);
                        break;
                    }
                    case RESET: {
                        c.setMaxFuseTicks(30);
                        break;
                    }
                    case REMOVE: {
                        int r2 = c.getMaxFuseTicks() - d;
                        if (r2 < 0) {
                            r2 = 0;
                        }
                        c.setMaxFuseTicks(r2);
                        break;
                    }
                    case REMOVE_ALL: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    protected String getPropertyName() {
        return "creeper max fuse ticks";
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }
}

