/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Arithmetic")
@Description(value={"Arithmetic expressions, e.g. 1 + 2, (health of player - 2) / 3, etc."})
@Examples(value={"set the player's health to 10 - the player's health", "loop (argument + 2) / 5 times:", "\tmessage \"Two useless numbers: %loop-num * 2 - 5%, %2^loop-num - 1%\"", "message \"You have %health of player * 2% half hearts of HP!\""})
@Since(value="1.4.2")
public class ExprArithmetic
extends SimpleExpression<Number> {
    private static final Patterns<Operator> patterns = new Patterns(new Object[][]{{"%number%[ ]+[ ]%number%", Operator.PLUS}, {"%number%[ ]-[ ]%number%", Operator.MINUS}, {"%number%[ ]*[ ]%number%", Operator.MULT}, {"%number%[ ]/[ ]%number%", Operator.DIV}, {"%number%[ ]^[ ]%number%", Operator.EXP}});
    private Expression<? extends Number> first;
    private Expression<? extends Number> second;
    private Operator op;
    private Class<? extends Number> returnType;
    private boolean integer;

    static {
        Skript.registerExpression(ExprArithmetic.class, Number.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        this.op = patterns.getInfo(matchedPattern);
        if (this.op == Operator.DIV || this.op == Operator.EXP) {
            this.returnType = Double.class;
        } else {
            Class<? extends Number> f = this.first.getReturnType();
            Class<? extends Number> s = this.second.getReturnType();
            Class[] integers = new Class[]{Long.class, Integer.class, Short.class, Byte.class};
            boolean firstIsInt = false;
            boolean secondIsInt = false;
            Class[] classArray = integers;
            int n = integers.length;
            int n2 = 0;
            while (n2 < n) {
                Class i = classArray[n2];
                firstIsInt |= i.isAssignableFrom(f);
                secondIsInt |= i.isAssignableFrom(s);
                ++n2;
            }
            this.returnType = firstIsInt && secondIsInt ? Long.class : Double.class;
        }
        this.integer = this.returnType == Long.class;
        return true;
    }

    protected Number[] get(Event e) {
        Number[] one = (Number[])Array.newInstance(this.returnType, 1);
        Number n1 = this.first.getSingle(e);
        Number n2 = this.second.getSingle(e);
        if (n1 == null) {
            n1 = 0;
        }
        if (n2 == null) {
            n2 = 0;
        }
        one[0] = this.op.calculate(n1, n2, this.integer);
        return one;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.first.toString(e, debug)) + " " + (Object)((Object)this.op) + " " + this.second.toString(e, debug);
    }

    @Override
    public Expression<? extends Number> simplify() {
        if (this.first instanceof Literal && this.second instanceof Literal) {
            return new SimpleLiteral<Number>((Number[])this.getArray(null), Number.class, false);
        }
        return this;
    }

    private static enum Operator {
        PLUS('+'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.longValue() + n2.longValue();
                }
                return n1.doubleValue() + n2.doubleValue();
            }
        }
        ,
        MINUS('-'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.longValue() - n2.longValue();
                }
                return n1.doubleValue() - n2.doubleValue();
            }
        }
        ,
        MULT('*'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return n1.longValue() * n2.longValue();
                }
                return n1.doubleValue() * n2.doubleValue();
            }
        }
        ,
        DIV('/'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    long div = n2.longValue();
                    if (div == 0L) {
                        return Long.MAX_VALUE;
                    }
                    return n1.longValue() / div;
                }
                return n1.doubleValue() / n2.doubleValue();
            }
        }
        ,
        EXP('^'){

            @Override
            public Number calculate(Number n1, Number n2, boolean integer) {
                if (integer) {
                    return (long)Math.pow(n1.longValue(), n2.longValue());
                }
                return Math.pow(n1.doubleValue(), n2.doubleValue());
            }
        };

        public final char sign;

        private Operator(char sign) {
            this.sign = sign;
        }

        public abstract Number calculate(Number var1, Number var2, boolean var3);

        public String toString() {
            return "" + this.sign;
        }
    }
}

